<form id="create-group" action="<?php echo e(url('live_chat/store_group')); ?>" method="post" autocomplete="off">
    <?php echo csrf_field(); ?>

    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Group Name')); ?></label>
                <input type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>" required>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Group Members')); ?></label>
                <select class="form-control select2" id="group-members" name="members[]" multiple data-placeholder="<?php echo e(_lang('Select Group Members')); ?>" required>
                    <optgroup label="<?php echo e(_lang('Team Members')); ?>">
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>" <?php echo e(in_array($user->id, old('members', [])) ? 'selected' : ''); ?>>
                                <?php echo e($user->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </optgroup>

                    <optgroup label="<?php echo e(_lang('Clients')); ?>">
                        <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($client->id); ?>" <?php echo e(in_array($client->id, old('members', [])) ? 'selected' : ''); ?>>
                                <?php echo e($client->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </optgroup>
                </select>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label"><?php echo e(_lang('Description')); ?></label>
                <textarea class="form-control" name="description"><?php echo e(old('description')); ?></textarea>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <button type="reset" class="btn btn-danger"><?php echo e(_lang('Reset')); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo e(_lang('Save')); ?></button>
            </div>
        </div>
    </div>
</form>
<?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/backend/live_chat/modal/create_group.blade.php ENDPATH**/ ?>