<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8" />
        <title><?php echo e(get_option('site_title', 'CRM')); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        
		<!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(get_favicon()); ?>">

		<!-- DataTables -->
        <link href="<?php echo e(URL::asset('/backend/plugins/datatables/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(URL::asset('/backend/plugins/datatables/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
        
		<!-- Responsive datatable examples -->
        <link href="<?php echo e(URL::asset('/backend/plugins/datatables/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" /> 
		
		<link href="<?php echo e(URL::asset('/backend/plugins/dropify/css/dropify.min.css')); ?>" rel="stylesheet">
		<link href="<?php echo e(URL::asset('/backend/plugins/sweet-alert2/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">
        <link href="<?php echo e(URL::asset('/backend/plugins/animate/animate.css')); ?>" rel="stylesheet" type="text/css">
		<link href="<?php echo e(URL::asset('/backend/plugins/select2/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
		<link href="<?php echo e(URL::asset('/backend/plugins/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" />
	    <link href="<?php echo e(URL::asset('/backend/plugins/jquery-toast-plugin/jquery.toast.min.css')); ?>" rel="stylesheet" />
        
		<!-- App Css -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/bootstrap.min.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/fontawesome.min.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/themify-icons.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/metisMenu.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/slicknav.min.css')); ?>">
		
		<!-- Others css -->
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/typography.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/default-css.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/piechart-css.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/styles.css?v=1.2')); ?>">
		<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/responsive.css?v=1.2')); ?>">
		
		<!-- Modernizr -->
		<script src="<?php echo e(URL::asset('/backend/assets/js/vendor/modernizr-2.8.3.min.js')); ?>"></script>
        
		<!--Chat Widget-->
		<link href="<?php echo e(URL::asset('/backend/assets/css/chat-widget.css?v=1.2')); ?>" rel="stylesheet" type="text/css" /> 

		<?php if(get_company_option('backend_direction',get_option('backend_direction')) == "rtl"): ?>
			<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/rtl/bootstrap.min.css')); ?>">
			<link rel="stylesheet" href="<?php echo e(URL::asset('/backend/assets/css/rtl/style.css')); ?>">
		<?php endif; ?>
		
		<?php echo $__env->make('layouts.others.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		 

		


    </head>

    <body>  



		<!-- Main Modal -->
		<div id="main_modal" class="modal" tabindex="-1" role="dialog">
		    <div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
				    <div class="modal-header bg-primary">
						<h5 class="modal-title mt-0 text-white"></h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						  <span aria-hidden="true">&times;</span>
						</button>
				    </div>
				  
				    <div class="alert alert-danger d-none m-3"></div>
				    <div class="alert alert-secondary d-none m-3"></div>			  
				    <div class="modal-body overflow-hidden"></div>
				  
				</div>
		    </div>
		</div>
		
		<!-- Secondary Modal -->
		<div id="secondary_modal" class="modal" tabindex="-1" role="dialog">
		    <div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
				    <div class="modal-header bg-dark">
						<h5 class="modal-title mt-0 text-white"></h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						  <span aria-hidden="true">&times;</span>
						</button>
				    </div>
				  
				    <div class="alert alert-danger d-none m-3"></div>
				    <div class="alert alert-secondary d-none m-3"></div>			  
				    <div class="modal-body overflow-hidden"></div>
				</div>
		    </div>
		</div>
	     
		<!-- Preloader area start -->
		<div id="preloader"></div>
		<!-- Preloader area end -->
		
		<div class="page-container">
		    <!-- sidebar menu area start -->
			<div class="sidebar-menu">
				<div class="sidebar-header">
					<div class="logo">
						<a href="<?php echo e(url('dashboard')); ?>"><img src="<?php echo e(Auth::user()->company_id != '' ? get_company_logo() : get_logo()); ?>" class="company-logo" alt="logo"></a>
					</div>
				</div>
				<div class="main-menu">
					<div class="menu-inner">
						<nav>
							<ul class="metismenu" id="menu">
							    <li><a href="<?php echo e(url('dashboard')); ?>"><i class="ti-dashboard"></i> <span><?php echo e(_lang('Dashboard')); ?></span></a></li>
								<?php echo $__env->make('layouts.menus.'.Auth::user()->user_type, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</ul>
						</nav>
					</div>
				</div>
			</div>
			<!-- sidebar menu area end -->
		
        
			<!-- main content area start -->
			<div class="main-content">

				<!-- header area start -->
				<div class="header-area">
					<div class="row align-items-center">
						<!-- nav and search button -->
						<div class="col-md-6 col-sm-8 clearfix">
							<div class="nav-btn float-left">
								<span></span>
								<span></span>
								<span></span>
							</div>
						</div>

						<!-- profile info & task notification -->
						<div class="col-md-6 col-sm-4 clearfix">

							<ul class="notification-area float-right">
	                            <?php if(Auth::user()->user_type != 'admin'): ?>
									<li class="dropdown">
										<i class="ti-bell dropdown-toggle" data-toggle="dropdown">
											<span><?php echo e(Auth::user()->unreadNotifications->count()); ?></span>
										</i>
										<div class="dropdown-menu bell-notify-box notify-box">
											<span class="notify-title"><?php echo e(_lang('You have').' '.Auth::user()->unreadNotifications->count().' '._lang('new notifications')); ?></span>
											<div class="nofity-list">
												<?php $__currentLoopData = Auth::user()->notifications->take(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<a href="<?php echo e(url('notification/'.$notification->id)); ?>" class="notify-item <?php echo e($notification->read_at == null ? 'unread-notification' : ''); ?>">
														<div class="notify-thumb">
															<img src="<?php echo e(URL::asset('/uploads/profile/'.$notification->user->profile_picture)); ?>">
														</div>
														<div class="notify-text">
															<p><b><?php echo e($notification->user->name); ?></b> <?php echo e($notification->data['title']); ?></p>
															<span><?php echo e($notification->data['content']); ?></span><br>
															<span><?php echo e($notification->created_at->diffForHumans()); ?></span>
														</div>
													</a>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</div>
										</div>
									</li>
								<?php endif; ?>
								<li class="dropdown">
									<i class="fas fa-mobile" data-toggle="dropdown">
										<span id="reminder_count"></span>
									</i>
									<div class="dropdown-menu bell-notify-box notify-box">
										<span class="notify-title" id="notify_title"></span>
										<div class="nofity-list" id="notify_list">
											
										</div>
									</div>
								</li>
	                            <li>
									<div class="user-profile">
										<h4 class="user-name dropdown-toggle" data-toggle="dropdown">
											<img class="avatar user-thumb" id="my-profile-img" src="<?php echo e(Auth::user()->profile_picture != '' ? URL::asset('/uploads/profile/'.Auth::user()->profile_picture) :  URL::asset('/images/avatar.png')); ?>" alt="avatar"> <?php echo e(Auth::user()->name); ?> <i class="fa fa-angle-down"></i>
										</h4>
										<div class="dropdown-menu">
											<?php if(Auth::user()->user_type == 'user' && get_option('membership_system') == 'enabled'): ?>
												<a class="dropdown-item" href="<?php echo e(url('membership/my_subscription')); ?>"><i class="ti-package text-muted mr-2"></i> <?php echo e(_lang('My Subscription')); ?></a>

												<!-- <a class="dropdown-item" href="<?php echo e(url('membership/extend')); ?>"><i class="ti-wallet text-muted mr-2"></i> <?php echo e(_lang('Upgrade Subscription')); ?></a> -->
												<a class="dropdown-item" href="#"><i class="ti-wallet text-muted mr-2"></i> <?php echo e(_lang('Upgrade Subscription')); ?></a>
											<?php endif; ?>
											<a class="dropdown-item" href="<?php echo e(url('profile/edit')); ?>"><i class="ti-settings text-muted mr-2"></i> <?php echo e(_lang('Profile Settings')); ?></a>
											<a class="dropdown-item" href="<?php echo e(url('profile/change_password')); ?>"><i class="ti-pencil text-muted mr-2"></i> <?php echo e(_lang('Change Password')); ?></a>
											<div class="dropdown-divider mb-0"></div>
											<a class="dropdown-item" href="<?php echo e(url('logout')); ?>"><i class="ti-power-off text-muted mr-2"></i> <?php echo e(_lang('Logout')); ?></a>
										</div>
									</div>
	                            </li>
	                            
	                        </ul>

						</div>
					</div>
				</div><!-- header area end -->
				
				<!-- page title area start -->
				<div class="page-title-area mb-3">
					<div class="row align-items-center py-3">
						<div class="col-sm-12">
							<div class="breadcrumbs-area clearfix">
								<h4 class="page-title float-left"><?php echo e(_lang('Dashboard')); ?></h4>
								<ul class="breadcrumbs float-left">
									<?php $segments = ''; ?>
									<?php $__currentLoopData = Request::segments(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										
										<?php if($segment == "dashboard"): ?>
											<?php continue; ?>
										<?php endif; ?>
										
										<?php $segments .= '/'.$segment; ?>
										
										<?php if(is_numeric($segment) || strlen($segment) > 30): ?>
										   <?php $segment = 'View'; ?>
										<?php endif; ?>
										
										<?php if(! checkRoute($segments)): ?>
											<?php continue; ?>
										<?php endif; ?>
										
										<?php if(! $loop->last): ?>
											<li>
												<a href="<?php echo e(url($segments)); ?>"><?php echo e(ucwords(str_replace("_"," ",$segment))); ?></a>
											</li>
										<?php else: ?>
											<li>
												<span><?php echo e(ucwords(str_replace("_"," ",$segment))); ?></span>
											</li>
										<?php endif; ?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</ul>
							</div>
						</div>
					</div>
				</div><!-- page title area end -->
				
				<div class="main-content-inner">

					
					<!-- Trial and Membership Alert -->
					<?php $user = Auth::user(); ?>

					<?php if(has_membership_system() == 'enabled' && $user->user_type == 'user'): ?>
						
					    <?php if( membership_validity() < date('Y-m-d')): ?>
							<div class="alert alert-danger">
							   <b class="float-left pt-2"><?php echo e(_lang('Please make your membership payment for further process !')); ?></b>
							   <a href="<?php echo e(url('membership/extend')); ?>" class="btn btn-primary btn-xs float-right"><b><?php echo e(_lang('Pay Now')); ?></b></a>
							   <div class="clearfix"></div>
							</div>
						<?php endif; ?>
						
						<?php if( $user->company->membership_type == 'trial' && membership_validity() > date('Y-m-d')): ?>
							<div class="alert alert-warning">
							   <b><?php echo e(_lang('You Are Currenly Using Trial Account !')); ?>&emsp;<a href="<?php echo e(url('membership/extend')); ?>" class="btn btn-danger btn-xs"><?php echo e(_lang('Upgrade Now')); ?></a></b>
							</div>
						<?php endif; ?>
						
					<?php endif; ?>
					<!-- End Trial and Membership Alert -->
					
					<div class="alert alert-success alert-dismissible mt-5" id="main_alert" role="alert">
						<button type="button" id="close_alert" class="close">
							<span aria-hidden="true"><i class="far fa-times-circle"></i></span>
						</button>
						<span class="msg"></span>
					</div>
					
					<?php echo $__env->yieldContent('content'); ?>

					
					<?php if(get_option('live_chat') == 'enabled' && has_feature('live_chat')): ?>
						<?php if(! Request::is('live_chat') && Auth::user()->user_type != 'admin'): ?>
							<?php echo $__env->make('backend.live_chat.chat-widget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						<?php endif; ?>
					<?php endif; ?>
					
					<audio id="chatSound">
					  <source src="<?php echo e(URL::asset('/sounds/messenger.mp3')); ?>" type="audio/mpeg" muted>
					</audio>
				</div><!--End main content Inner-->
				
			</div><!--End main content-->
			
			<!-- footer area start-->
			<footer>
				<div class="footer-area">
					<p>&copy; <?php echo e(date('Y').' '.get_option('company_name')); ?></p>
				</div>
			</footer>
			<!-- footer area end-->
		</div><!--End Page Container-->

        <!-- jQuery  -->
		<script src="<?php echo e(URL::asset('/backend/assets/js/vendor/jquery-2.2.4.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/assets/js/popper.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/assets/js/bootstrap.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/assets/js/metisMenu.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/assets/js/jquery.slimscroll.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/assets/js/jquery.slicknav.min.js')); ?>"></script>
        
		<script src="<?php echo e(URL::asset('/backend/assets/js/print.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/assets/js/pace.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/assets/js/clipboard.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/moment/moment.js')); ?>"></script>
        
		<!-- Dashboard Scripts -->
		<?php if(Request::is('dashboard')): ?>
			<script src="<?php echo e(URL::asset('/backend/plugins/echart/echarts.min.js')); ?>"></script>
		<?php endif; ?>
		
		<!-- Required datatable js -->
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/dataTables.bootstrap4.min.js')); ?>"></script>
        <!-- datatable Buttons -->
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/dataTables.buttons.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/buttons.bootstrap4.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/jszip.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/pdfmake.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/vfs_fonts.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/buttons.html5.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/buttons.print.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/buttons.colVis.min.js')); ?>"></script>
        <!-- Responsive datatable -->
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/dataTables.responsive.min.js')); ?>"></script>
        <script src="<?php echo e(URL::asset('/backend/plugins/datatables/responsive.bootstrap4.min.js')); ?>"></script>

		<script src="<?php echo e(URL::asset('/backend/plugins/dropify/js/dropify.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/plugins/sweet-alert2/sweetalert2.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/plugins/select2/select2.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/plugins/tinymce/tinymce.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/plugins/parsleyjs/parsley.min.js')); ?>"></script>
		<script src="<?php echo e(URL::asset('/backend/plugins/jquery-toast-plugin/jquery.toast.min.js')); ?>"></script>
    


<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

        <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
		  <script>

		    // Enable pusher logging - don't include this in production
		    Pusher.logToConsole = true;

		    var pusher = new Pusher('3cb6f40607abe987b961', {
		      cluster: 'ap2'
		    });

		    var channel = pusher.subscribe('my-channel');
		    channel.bind('my-event', function(data) {
		      alert(JSON.stringify(data));
		    });
		  </script>
		
        <!-- App js -->
        <script src="<?php echo e(URL::asset('/backend/assets/js/scripts.js?v=1.7')); ?>"></script>

		<script type="text/javascript">		
		(function($){

			"use strict";	
			
			<?php if(Request::is('dashboard')): ?>
				$(".page-title").html("<?php echo e(_lang('Dashboard')); ?>"); 
			<?php else: ?>
                $(".page-title").html($(".title").html()); 
				$(".page-title").html($(".panel-title").html());
			<?php endif; ?>			

			
			//Show Success Message
			<?php if(Session::has('success')): ?>
		       $("#main_alert > span.msg").html(" <?php echo e(session('success')); ?> ");
			   $("#main_alert").addClass("alert-success").removeClass("alert-danger");
			   $("#main_alert").css('display','block');
			<?php endif; ?>
			
			//Show Single Error Message
			<?php if(Session::has('error')): ?>
			   $("#main_alert > span.msg").html(" <?php echo e(session('error')); ?> ");
			   $("#main_alert").addClass("alert-danger").removeClass("alert-success");
			   $("#main_alert").css('display','block');
			<?php endif; ?>
			
			
			<?php $i =0; ?>

			<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			    <?php if($loop->first): ?>
					$("#main_alert > span.msg").html("<i class='typcn typcn-delete'></i> <?php echo e($error); ?> ");
					$("#main_alert").addClass("alert-danger").removeClass("alert-success");
				<?php else: ?>
                    $("#main_alert > span.msg").append("<br><i class='typcn typcn-delete'></i> <?php echo e($error); ?> ");					
				<?php endif; ?>
				
				<?php if($loop->last): ?>
					$("#main_alert").css('display','block');
				<?php endif; ?>
				
				<?php if(isset($errors->keys()[$i])): ?>
					var name = "<?php echo e($errors->keys()[$i]); ?>";
				
					$("input[name='" + name + "']").addClass('error is-invalid');
					$("select[name='" + name + "'] + span").addClass('error is-invalid');
				
					$("input[name='"+name+"'], select[name='"+name+"']").parent().append("<span class='v-error'><?php echo e($error); ?></span>");
				<?php endif; ?>
				<?php $i++; ?>
			
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			
        })(jQuery); <!-- End jQuery -->

	 </script>
	 
	 <?php if( get_option('live_chat') == 'enabled' && has_feature('live_chat')): ?>
		<script src="<?php echo e(URL::asset('/backend/assets/js/socket.js?v=1.2')); ?>" defer></script>
		
		<?php if(! Request::is('live_chat')): ?>
		<script src="<?php echo e(URL::asset('/backend/assets/js/chat-widget.js?v=1.2')); ?>" defer></script>
		<?php endif; ?>
		
	 <?php endif; ?>
	 
	 <!-- Custom JS -->
	 <?php echo $__env->yieldContent('js-script'); ?>
		<script type="text/javascript">
			// Graph Comparison
	$('#year_select_box').change(function() {
		var curr_year = new Date().getFullYear();
		var year = $('#year_select_box').val();
		$('#year_csv').val(year);
		
        var link = _url +"/graph-compare/"+year;
        if (curr_year > year) {
        	$('#upload_previous_data').css('display', 'inline-block');
        }else {
        	$('#upload_previous_data').css('display', 'none');
        }
        $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
        });
        $.ajax({
            method: 'GET',
            url: link,
			cache: false,
            success: function (datas) {
            	var returnedData = JSON.parse(datas);
                $('#piechart1').empty();
		        $('#piechart1').append(returnedData.f1);
		        $('#piechart2').empty();
		        $('#piechart2').append(returnedData.f2);
            }
        });
});


function fetchdata(){
	var link = _url +"/reminder-count/";

    $.ajax({
        method: 'GET',
        url: link,
		cache: false,
        success: function (datas) {
        	var returnedData = JSON.parse(datas);
            $('#reminder_count').empty();
	        $('#reminder_count').html(returnedData.f2);
	        $('#notify_title').empty();
	        $('#notify_title').html('You have '+returnedData.f2+' reminders');
	        $('#notify_list').empty();
	        $('#notify_list').html(returnedData.re);

	        //add 30 minutes to date
			var minutesToAdd=15;
			var minutesfive=15;
			var minutes=1;

			var currentDate = new Date();

			var remDate = new Date(returnedData.reminder[0].date);
			var remDatebefore = new Date(remDate - minutesToAdd*60000);
			var remDatebeforefive = new Date(remDate - minutesfive*60000);
			var remDatebeforeone = new Date(remDate - minutes*60000);


			var c_hours = currentDate.getHours();
  			var c_minutes = currentDate.getMinutes();
  			var c_date_m = currentDate.getMonth();
  			var c_date_y = currentDate.getFullYear();
  			var c_date_d = currentDate.getDate();

  			var r_hours = remDatebefore.getHours();
  			var r_minutes = remDatebefore.getMinutes();
  			var r_date_m = remDatebefore.getMonth();
  			var r_date_y = remDatebefore.getFullYear();
  			var r_date_d = remDatebefore.getDate();

  			var r_hoursfive = remDatebeforefive.getHours();
  			var r_minutesfive = remDatebeforefive.getMinutes();
  			var r_date_mfive = remDatebeforefive.getMonth();
  			var r_date_yfive = remDatebeforefive.getFullYear();
  			var r_date_dfive = remDatebeforefive.getDate();

  			var r_hoursone = remDatebeforeone.getHours();
  			var r_minutesone = remDatebeforeone.getMinutes();
  			var r_date_mone = remDatebeforeone.getMonth();
  			var r_date_yone = remDatebeforeone.getFullYear();
  			var r_date_done = remDatebeforeone.getDate();


  			if(c_hours == r_hoursfive && c_minutes == r_minutesfive && c_date_m == r_date_mfive && c_date_y == r_date_yfive && c_date_d == r_date_dfive){

  				Swal.fire({
				  title: "Reminder", 
				  html: returnedData.re,  
				  confirmButtonText: "Ok", 
				});

  			}

  			if(c_hours == r_hoursone && c_minutes == r_minutesone && c_date_m == r_date_mone && c_date_y == r_date_yone && c_date_d == r_date_done){

  				Swal.fire({
				  title: "Reminder", 
				  html: returnedData.re,  
				  confirmButtonText: "Ok", 
				});

  			}

  			if(c_hours == r_hours && c_minutes == r_minutes && c_date_m == r_date_m && c_date_y == r_date_y && c_date_d == r_date_d){

  				Swal.fire({
				  title: "Reminder", 
				  html: returnedData.re,  
				  confirmButtonText: "Ok", 
				});

  			}
			
        }
    });
}

$(document).ready(function(){
 	setInterval(fetchdata,30000);
});
		</script>

<!-- 		    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.21.0/moment.min.js" type="text/javascript"></script>
<script src="<?php echo e(URL::asset('/backend/assets/js/bootstrap-datetimepicker.min.js')); ?>"></script>
        <script type="text/javascript">
            $(function () {
                $('#datetimepicker1').datetimepicker();
            });
        </script> -->
         
<?php echo $__env->yieldContent('custom_js'); ?>
    </body>
</html><?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/layouts/app.blade.php ENDPATH**/ ?>