<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">
            <div class="card panel-default">
                <span class="d-none panel-title"><?php echo e(_lang('Customer Reports')); ?></span>

                <div class="card-body">
                    <form method="get" action="" enctype="multipart/form-data">
                        <div class="row">
                            <?php echo e(csrf_field()); ?>



                            <?php if(Auth::user()->role_id != 8): ?>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(_lang('Marketing Person')); ?></label>
                                        <select class="form-control select2 select-filter" name="assigned_user_id">
                                            <option value=""><?php echo e(_lang('ALL')); ?></option>
                                            <?php echo e(create_option_sales('users', 'id', 'name', '', ['company_id=' => company_id(), 'user_type=' => 'staff'])); ?>

                                        </select>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"><?php echo e(_lang('Contact Form Date')); ?></label>
                                    <input type="date" class="form-control" name="contact_from_date"
                                        value="<?php echo e(old('contact_from_date')); ?>">
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"><?php echo e(_lang('Contact To Date')); ?></label>
                                    <input type="date" class="form-control" name="contact_to_date"
                                        value="<?php echo e(old('contact_to_date')); ?>">
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"><?php echo e(_lang('Subscription Form Date')); ?></label>
                                    <input type="date" class="form-control" name="transaction_from_date"
                                        value="<?php echo e(request()->get('transaction_from_date')); ?>">
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"><?php echo e(_lang('Subscription To Date')); ?></label>
                                    <input type="date" class="form-control" name="transaction_to_date"
                                        value="<?php echo e(request()->get('transaction_to_date')); ?>">
                                </div>
                            </div>


                            <div class="col-lg-4">
                                <label><?php echo e(_lang('Timezone')); ?></label>
                                <select class="form-control select-filter" name="time_zone" id="time_zone">
                                    <option value=""><?php echo e(_lang('ALL')); ?></option>
                                    <?php $__currentLoopData = App\TimeZoneList::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tiz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tiz->id); ?>"><?php echo e($tiz->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>


                            <div class="col-lg-4">
                                <label><?php echo e(_lang('state')); ?></label>
                                <select class="form-control select2 select-filter" name="zone_state" id="zone_state">

                                </select>
                            </div>




                            <div class="form-group" style="margin-top:30px;">
                                <div class="col-md-4">
                                    <input type="hidden" class="form-control" name="paginate" value="1">
                                    <button type="submit" class="btn btn-primary"><?php echo e(_lang('Search')); ?></button>
                                </div>
                            </div>


                        </div>
                    </form>






                    <table id="leads_table" class="table table-striped"
                        style="margin-top:75px;display: block;overflow-y: scroll">
                        <thead>
                            <tr>
                                <th><?php echo e(_lang('#ID')); ?></th>
                                <th><?php echo e(_lang('Customer ID')); ?></th>
                                <th><?php echo e(_lang('Company Name')); ?></th>
                                <th><?php echo e(_lang('Contact Name')); ?></th>
                                <th><?php echo e(_lang('Email')); ?></th>
                                <th><?php echo e(_lang('Phone')); ?></th>
                                <th><?php echo e(_lang('Sales Person ')); ?></th>


                                <th><?php echo e(_lang('Total Credit')); ?></th>
                                <th><?php echo e(_lang('Total Refund')); ?></th>
                                <th><?php echo e(_lang('Total Dispute')); ?></th>

                                <th><?php echo e(_lang('Subscription Type')); ?></th>
                                <!--						<th><?php echo e(_lang('Group Name')); ?></th>-->
                                <th><?php echo e(_lang('Action')); ?></th>


                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $gtcr = $gtrf = $gtdp = 0;
                            ?>
                            <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $transactions = $data->transactions;
                                $dispute_total = 0;
                                $refund_pf = 0;
                                $total_credit = 0;
                                foreach ($transactions as $trans) {
                                    if ($trans->refund_type == 'Dispute') {
                                        $dispute_total = $dispute_total + ($trans->refundable_amount ?? 0);
                                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                                        $refund_pf = $refund_pf + ($trans->refundable_amount ?? 0);
                                    }
                                    $total_credit = $total_credit + ($trans->amount ?? 0); //(($trans->refund_payment_date != null) ? ($trans->amount ?? 0) : 0);
                                
                                    $subscription_type = $trans->subscription_type ?? '';
                                    $group_name = $trans->group->name ?? '';
                                
                                    //print_r($trans); die;
                                }
                                $gtcr = $gtcr + $total_credit;
                                $gtrf = $gtrf + $refund_pf;
                                $gtdp = $gtdp + $dispute_total;
                                ?>






                                </tr>
                                <td><?php echo e($data->id); ?></td>
                                <td><?php echo e($data->customer_id); ?></td>
                                <td><?php echo e($data->company_name); ?></td>
                                <td><?php echo e($data->contact_name); ?></td>
                                <td><?php echo e($data->contact_email); ?></td>
                                <td><?php echo e($data->contact_phone); ?></td>
                                <td><?php echo e($data->assignuser->name ?? 'NA'); ?></td>

                                <td><?php echo e($total_credit); ?></td>
                                <td><?php echo e($refund_pf); ?></td>
                                <td><?php echo e($dispute_total); ?></td>
                                <td><?php echo e($subscription_type ?? ''); ?></td>
                                <!--					<td><?php echo e($group_name ?? ''); ?></td>-->
                                <td>
                                    <form action="<?php echo e(action('ContactController@destroy', $data['id'])); ?>"
                                        style="    text-align: center !important;width: max-content;" method="post">
                                        <a href="<?php echo e(action('ContactController@show', $data['id'])); ?>"
                                            class="btn btn-primary btn-xs"><i class="ti-eye"></i></a>
                                        <a href="<?php echo e(action('SaleTransactionController@subscription_payment', $data['id'])); ?>"
                                            class="btn btn-info btn-xs"><i class="ti-receipt"></i></a>
                                        <a href="<?php echo e(action('ContactController@edit', $data['id'])); ?>"
                                            class="btn btn-warning btn-xs"><i class="ti-pencil"></i></a>
                                        <?php echo csrf_field(); ?>
                                        <input name="_method" type="hidden" value="DELETE">
                                        <button class="btn btn-danger btn-xs btn-remove" type="submit"><i
                                                class="ti-eraser"></i></button>
                                    </form>
                                </td>


                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php if(isset($refundData) && count($refundData) > 0): ?>
                                <tr>
                                    <td colspan="12">
                                        <h3>Old Data</h3>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            <?php
                                $gtcr_old = $refund_old = $dispute_old = 0;
                            ?>
                            <?php $__currentLoopData = $refundData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $transactions = $data->transactions;
                                $dispute_total = 0;
                                $refund_pf = 0;
                                $total_credit = 0;
                                foreach ($transactions as $trans) {
                                    if ($trans->refund_type == 'Dispute') {
                                        $dispute_total = $dispute_total + ($trans->refundable_amount ?? 0);
                                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                                        $refund_pf = $refund_pf + ($trans->refundable_amount ?? 0);
                                    }
                                    $total_credit = $total_credit + ($trans->amount ?? 0);
                                
                                    $subscription_type = $trans->subscription_type ?? '';
                                    $group_name = $trans->group->name ?? '';
                                
                                    //print_r($trans); die;
                                }
                                $gtcr_old = $gtcr_old + $total_credit;
                                $refund_old = $refund_old + $refund_pf;
                                $dispute_old = $dispute_old + $dispute_total;
                                ?>






                                </tr>
                                <td><?php echo e($data->id); ?></td>
                                <td><?php echo e($data->customer_id); ?></td>
                                <td><?php echo e($data->company_name); ?></td>
                                <td><?php echo e($data->contact_name); ?></td>
                                <td><?php echo e($data->contact_email); ?></td>
                                <td><?php echo e($data->contact_phone); ?></td>
                                <td><?php echo e($data->assignuser->name ?? 'NA'); ?></td>

                                <td><?php echo e($total_credit); ?></td>
                                <td><?php echo e($refund_pf); ?></td>
                                <td><?php echo e($dispute_total); ?></td>
                                <td><?php echo e($subscription_type ?? ''); ?></td>
                                <!--					<td><?php echo e($group_name ?? ''); ?></td>-->
                                <td>
                                    <form action="<?php echo e(action('ContactController@destroy', $data['id'])); ?>"
                                        style="    text-align: center !important;width: max-content;" method="post">
                                        <a href="<?php echo e(action('ContactController@show', $data['id'])); ?>"
                                            class="btn btn-primary btn-xs"><i class="ti-eye"></i></a>
                                        <a href="<?php echo e(action('SaleTransactionController@subscription_payment', $data['id'])); ?>"
                                            class="btn btn-info btn-xs"><i class="ti-receipt"></i> </a>
                                        <a href="<?php echo e(action('ContactController@edit', $data['id'])); ?>"
                                            class="btn btn-warning btn-xs"><i class="ti-pencil"></i></a>
                                        <?php echo csrf_field(); ?>
                                        <input name="_method" type="hidden" value="DELETE">
                                        <button class="btn btn-danger btn-xs btn-remove" type="submit"><i
                                                class="ti-eraser"></i></button>
                                    </form>
                                </td>


                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td colspan="12">
                                    <h3>Gross Total</h3>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td style="font-weight: bold">Total</td>
                                <td style="font-weight: bold"><?php echo e($gtcr); ?></td>
                                <td style="font-weight: bold"><?php echo e($gtrf + $refund_old); ?></td>
                                <td style="font-weight: bold"><?php echo e($gtdp + $dispute_old); ?></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>Total Credit</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold"><?php echo e($gtcr); ?></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>Total Refund</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold">-</td>
                                <td style="font-weight: bold"><?php echo e($gtrf + $refund_old); ?></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>Total Dispute</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold">-</td>
                                <td style="font-weight: bold"><?php echo e($gtdp + $dispute_old); ?></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td style="font-weight: bold">Gross Income</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold"><?php echo e($gtcr - $gtrf - $refund_old - $gtdp - $dispute_old); ?>

                                </td>
                            </tr>
                        </tbody>
                    </table>

                </div>
                <div class="card-header">
                    <?php if($paginate != 1): ?>
                        <?php echo e($datas->appends(request()->query())->links()); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->startSection('js-script'); ?>
    <script>
        $(document).ready(function() {
            $('#time_zone').on('change', function() {
                var idCountry = this.value;
                $("#zone_state").html('');
                $.ajax({
                    url: "<?php echo e(url('fetch-states')); ?>",
                    type: "POST",
                    data: {
                        zone_id: idCountry,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#zone_state').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            $("#zone_state").append('<option value="' + value
                                .name + '">' + value.name + '</option>');
                        });
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/backend/accounting/sale_transcation/customer_reports_list.blade.php ENDPATH**/ ?>