<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-3">
		<div class="card">
			<div class="d-none panel-title"><?php echo e(_lang('View Contact')); ?></div>

			<div class="card-body p-3">
				<div class="row">
					<div class="col-lg-12 align-self-center">
						<div class="contact-profile text-center">
							<div class="contact-profile-image">
								<img src="<?php echo e(URL::asset('/uploads/contacts/'.($contact->contact_image??''))); ?>" alt="" class="thumb-contact rounded-circle">
							</div>
							<div class="contact-profile-detail">
								<h4 class="mt-2"><?php echo e($contact->contact_name??''); ?></h4>                                             
								<p class="mb-0"><?php echo e($contact->group->name??''); ?></p>
							</div>
						</div>                                                
					</div><!--end col-->
				</div><!--end row-->                                                                              
			</div><!--end card-body-->
			
			<div class="card-body p-3">
			  <ul class="nav flex-column nav-tabs settings-tab">
				  <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#general-info" aria-expanded="true"><i class="far fa-user"></i> <?php echo e(_lang('General')); ?></a></li>
				 <!-- <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#projects" aria-expanded="false"><i class="fas fa-briefcase"></i> <?php echo e(_lang('Projects')); ?></a></li>
				  <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#invoices" aria-expanded="false"><i class="fas fa-file-invoice-dollar"></i> <?php echo e(_lang('Invoices')); ?></a></li>
				  <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#quotations" aria-expanded="false"><i class="fas fa-file-invoice"></i> <?php echo e(_lang('Quotations')); ?></a></li>-->
				  <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#transactions" aria-expanded="false"><i class="fas fa-credit-card"></i> <?php echo e(_lang('Transactions')); ?></a></li>
				  <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#notes" aria-expanded="false"><i class="fas fa-sticky-note-o"></i> <?php echo e(_lang('Notes')); ?></a></li>

				  <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#email" aria-expanded="false"><i class="far fa-envelope-open"></i> <?php echo e(_lang('Email')); ?></a></li>
				  <li class="nav-item"><a class="nav-link" href="<?php echo e(action('ContactController@edit', $contact['id']??'')); ?>"><i class="far fa-edit"></i> <?php echo e(_lang('Edit')); ?></a></li>
			  </ul>
			</div><!--end card-body-->
		</div><!--end card-->
	</div><!--end col-->

	<?php 

	$currency = currency();
	$base_currency = base_currency();
    $date_format = get_company_option('date_format','Y-m-d');
    
    ?>
	  
	<div class="col-md-9">	  
	  <div class="tab-content" id="crm-tab">
	
	      <div id="general-info" class="tab-pane active">
			  <div class="card">
				  <div class="card-body">

                    <div class="row">

					<!--	<div class="col-lg-6 mb-3">
                       		<div class="card">
								<div class="seo-fact sbg2">
									<div class="p-4">
										<div class="seofct-icon">
										    <i class="ti-briefcase"></i> 
											<span class="float-right"><?php echo e(_lang('Total Project')); ?></span>
										</div>
										<h2 class="text-right">
											<?php echo e($total_project); ?>

										</h2>
									</div>
								</div>
							</div>
						</div>-->

						<!--<div class="col-lg-6 mb-3">
                       		<div class="card">
								<div class="seo-fact sbg1">
									<div class="p-4">
										<div class="seofct-icon">
										    <i class="ti-file"></i> 
											<span class="float-right"><?php echo e(_lang('Invoice Value')); ?></span>
										</div>
										<h2 class="text-right">
											<?php echo e(decimalPlace($invoice_value->grand_total, $currency)); ?>

										</h2>
									</div>
								</div>
							</div>
						</div>-->

<!--						<div class="col-lg-6 mb-3">
                       		<div class="card">
								<div class="seo-fact sbg2">
									<div class="p-4">
										<div class="seofct-icon">
										    <i class="ti-check-box"></i> 
											<span class="float-right"><?php echo e(_lang('Total Payment')); ?></span>
										</div>
										<h2 class="text-right">
											<?php echo e(decimalPlace($contact->paid, $currency)); ?>

										</h2>
									</div>
								</div>
							</div>
						</div>-->

<!--						<div class="col-lg-6 mb-3">
                       		<div class="card">
								<div class="seo-fact sbg3">
									<div class="p-4">
										<div class="seofct-icon">
										    <i class="ti-info-alt"></i> 
											<span class="float-right"><?php echo e(_lang('Total Due')); ?></span>
										</div>
										<h2 class="text-right">
											<?php echo e(decimalPlace(($invoice_due_amount->grand_total - $invoice_due_amount->paid), $currency)); ?>

										</h2>
									</div>
								</div>
							</div>
						</div>-->


					</div>

					<table class="table table-striped">
						<thead>
						    <th colspan="2"><h5><?php echo e(_lang('General Information')); ?></h5></th>
						</thead>
						<tbody>
						    <tr><td><?php echo e(_lang('Customer ID')); ?></td><td><b><?php echo e($contact->customer_id??''); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Profile Type')); ?></td><td><b><?php echo e($contact->profile_type??''); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Company Name')); ?></td><td><b><?php echo e($contact->company_name??''); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Assign Lead')); ?></td><td><b><?php echo e($contact->assignuser->name??''); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Current Assign Lead')); ?></td><td><b><?php echo e($contact->assignuser_lead->name??''); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Contact Name')); ?></td><td><b><?php echo e($contact->contact_name??''); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Type')); ?></td><td><b><?php echo e($contact->group->name); ?></b></td></tr>
						<!--	<tr><td><?php echo e(_lang('VAT ID')); ?></td><td><b><?php echo e($contact->vat_id); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Client IP')); ?></td><td><b><?php echo e($contact->client_ip); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Reg No')); ?></td><td><b><?php echo e($contact->reg_no); ?></b></td></tr>-->
							<tr><td><?php echo e(_lang('Contact Email')); ?></td><td><b><?php echo e($contact->contact_email); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Contact Phone')); ?></td><td><b><?php echo e($contact->contact_phone); ?></b></td></tr>
						<!--	<tr><td><?php echo e(_lang('Country')); ?></td><td><b><?php echo e($contact->country); ?></b></td></tr>-->
							<tr><td><?php echo e(_lang('Currency')); ?></td><td><b><?php echo e($contact->currency); ?> (<?php echo clean(get_currency_symbol( $contact->currency )); ?>)</b></td></tr>
						<!--	<tr><td><?php echo e(_lang('City')); ?></td><td><b><?php echo e($contact->city); ?></b></td></tr>
							<tr><td><?php echo e(_lang('State')); ?></td><td><b><?php echo e($contact->state); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Zip')); ?></td><td><b><?php echo e($contact->zip); ?></b></td></tr>-->
						<!--	<tr><td><?php echo e(_lang('Amount')); ?></td><td><b><?php echo $contact->amount; ?></b></td></tr>
							<tr><td><?php echo e(_lang('Subscription frequescy')); ?></td><td><b><?php echo $contact->subscription_type; ?></b></td></tr>-->
							<tr><td><?php echo e(_lang('TimeZone')); ?></td><td><b><?php echo $contact->zonename->name??''; ?></b></td></tr>
								<tr><td><?php echo e(_lang('States')); ?></td><td><b><?php echo $contact->zone_state; ?></b></td></tr>
							<tr><td><?php echo e(_lang('Address')); ?></td><td><b><?php echo $contact->address; ?></b></td></tr>
							<!--<tr><td><?php echo e(_lang('Facebook')); ?></td><td><b><?php echo e($contact->facebook); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Twitter')); ?></td><td><b><?php echo e($contact->twitter); ?></b></td></tr>
							<tr><td><?php echo e(_lang('Linkedin')); ?></td><td><b><?php echo e($contact->linkedin); ?></b></td></tr>-->
							<tr><td><?php echo e(_lang('Remarks')); ?></td><td><b><?php echo e($contact->remarks); ?></b></td></tr>
								
							
						</tbody>
					</table>
				  </div>
			  </div>
		  </div>

		  <div id="projects" class="tab-pane fade"> 
		  	<div class="card">
				<div class="card-body">
				  	<table class="table table-bordered data-table">
					      <thead>
						    <tr>
								<th><?php echo e(_lang('Name')); ?></th>	
								<th><?php echo e(_lang('Start Date')); ?></th>
								<th><?php echo e(_lang('End Date')); ?></th>
								<th><?php echo e(_lang('Status')); ?></th>
								<th><?php echo e(_lang('Progress')); ?></th>
								<th class="text-center"><?php echo e(_lang('Action')); ?></th>
						    </tr>
						</thead>
						<tbody>
							<?php $__currentLoopData = $contact->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><a href="<?php echo e(action('ProjectController@show', $project->id)); ?>"><?php echo e($project->name); ?></a></td>
									<td><?php echo e(date($date_format,strtotime($project->start_date))); ?></td>
									<td><?php echo e(date($date_format,strtotime($project->end_date))); ?></td>
									<td><?php echo clean(project_status($project->status)); ?></td>
									<td>
										<div class="progress">
										  <div class="progress-bar" role="progressbar" style="width: <?php echo e($project->progress); ?>%;" aria-valuenow="<?php echo e($project->progress); ?>" aria-valuemin="0" aria-valuemax="100"><?php echo e($project->progress); ?>%</div>
										</div>
									</td>
									<td>
										<form action="<?php echo e(action('ProjectController@destroy', $project['id'])); ?>" class="text-center" method="post">
											<a href="<?php echo e(action('ProjectController@show', $project['id'])); ?>" class="btn btn-primary btn-xs"><i class="ti-eye"></i></a>
											<a href="<?php echo e(action('ProjectController@edit', $project['id'])); ?>" data-title="'. _lang('Update Project') .'" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
											<?php echo e(csrf_field()); ?>

											<input name="_method" type="hidden" value="DELETE">
											<button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
										</form>
									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		  </div>

		  <div id="invoices" class="tab-pane fade"> 
			  <div class="card">
				    <div class="card-body">
					  <table class="table table-bordered data-table">
						<thead>
						  <tr>
							<th><?php echo e(_lang('Invoice Number')); ?></th>
							<th><?php echo e(_lang('Due Date')); ?></th>
							<th class="text-right"><?php echo e(_lang('Grand Total')); ?></th>
							<th class="text-right"><?php echo e(_lang('Paid')); ?></th>
							<th class="text-center"><?php echo e(_lang('Status')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
						  </tr>
						</thead>
						<tbody>
						  
						  <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						  <tr id="row_<?php echo e($invoice->id); ?>">
							<td class='invoice_number'><?php echo e($invoice->invoice_number); ?></td>
							<td class='due_date'><?php echo e(date($date_format,strtotime($invoice->due_date))); ?></td>
							<td class='grand_total text-right'><?php echo e(decimalPlace($invoice->grand_total, $currency)); ?></td>
							<td class='paid text-right'><?php echo e(decimalPlace($invoice->paid, $currency)); ?></td>
							<td class='status text-center'><?php echo strip_tags(invoice_status($invoice->status),'<span>'); ?></td>
							<td class="text-center">

								<div class="dropdown">
									<button class="btn btn-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown"><?php echo e(_lang('Action')); ?>

									<i class="fa fa-angle-down"></i></button>
									<ul class="dropdown-menu">
										<a class="dropdown-item" href="<?php echo e(action('InvoiceController@edit', $invoice->id)); ?>"><i class="fas fa-edit"></i> <?php echo e(_lang('Edit')); ?></a>
										<a class="dropdown-item" href="<?php echo e(action('InvoiceController@show', $invoice->id)); ?>" data-title="<?php echo e(_lang('View Invoice')); ?>" data-fullscreen="true"><i class="fas fa-eye"></i> <?php echo e(_lang('View')); ?></a>
										<a class="dropdown-item ajax-modal" href="<?php echo e(url('invoices/create_payment/'.$invoice->id)); ?>" data-title="<?php echo e(_lang('Make Payment')); ?>"><i class="fas fa-credit-card"></i> <?php echo e(_lang('Make Payment')); ?></a>
										<a class="dropdown-item ajax-modal" href="<?php echo e(url('invoices/view_payment/'.$invoice->id)); ?>" data-title="<?php echo e(_lang('View Payment')); ?>" data-fullscreen="true"><i class="fas fa-credit-card"></i> <?php echo e(_lang('View Payment')); ?></a>
										
										<form action="<?php echo e(action('InvoiceController@destroy', $invoice['id'])); ?>" method="post">									
											<?php echo e(csrf_field()); ?>

											<input name="_method" type="hidden" value="DELETE">
											<button class="button-link btn-remove" type="submit"><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
										</form>
											
									</ul>
								</div>
							</td>
						  </tr>
						  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					  </table>
				    </div>
			    </div>
		  </div>
		  
		  <div id="quotations" class="tab-pane fade">
		      <?php $currency = currency() ?>
			  <div class="card">
				    <div class="card-body">
					  <table class="table table-bordered data-table">
						<thead>
						  <tr>
							<th><?php echo e(_lang('Quotation Number')); ?></th>
							<th><?php echo e(_lang('Date')); ?></th>
							<th class="text-right"><?php echo e(_lang('Grand Total')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
						  </tr>
						</thead>
						<tbody>
						  
						  <?php $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						  <tr id="row_<?php echo e($quotation->id); ?>">
							<td class='invoice_number'><?php echo e($quotation->quotation_number); ?></td>
							<td class='due_date'><?php echo e(date($date_format, strtotime($quotation->quotation_date))); ?></td>
							<td class='grand_total text-right'><?php echo e(decimalPlace($quotation->grand_total, $currency)); ?></td>
							<td class="text-center">

								<div class="dropdown">
									<button class="btn btn-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown"><?php echo e(_lang('Action')); ?>

									<i class="fa fa-angle-down"></i></button>
									<ul class="dropdown-menu">
										<a class="dropdown-item" href="<?php echo e(action('QuotationController@edit', $quotation->id)); ?>"><i class="fas fa-edit"></i> <?php echo e(_lang('Edit')); ?></a>
										<a class="dropdown-item" href="<?php echo e(action('QuotationController@show', $quotation->id)); ?>" data-title="<?php echo e(_lang('View Invoice')); ?>" data-fullscreen="true"><i class="fas fa-eye"></i> <?php echo e(_lang('View')); ?></a>
										<a class="dropdown-item" href="<?php echo e(action('QuotationController@convert_invoice', $quotation->id)); ?>"><i class="fas fa-credit-card"></i> <?php echo e(_lang('Convert to Invoice')); ?></a>
										
										<form action="<?php echo e(action('QuotationController@destroy', $quotation->id)); ?>" method="post">									
											<?php echo e(csrf_field()); ?>

											<input name="_method" type="hidden" value="DELETE">
											<button class="button-link btn-remove" type="submit"><i class="fas fa-trash-alt"></i> <?php echo e(_lang('Delete')); ?></button>
										</form>
										
									</ul>
								</div>
							</td>
						  </tr>
						  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					  </table>
				    </div>
			    </div>
		  </div>
		  
		  <div id="transactions" class="tab-pane fade">
			<div class="card">
				<div class="card-body">	
					<table class="table table-bordered data-table">
						<thead>			
						<th><?php echo e(_lang('Type')); ?></th>
					<th><?php echo e(_lang('Subscription frequescy')); ?></th>
					<th><?php echo e(_lang('Amount')); ?></th>
				<th><?php echo e(_lang('Payment Mode')); ?></th>
				<th><?php echo e(_lang('Payment status')); ?></th>
				<th><?php echo e(_lang('Payment Date')); ?></th>
				<th><?php echo e(_lang('Status')); ?></th>
				<th class="text-center"><?php echo e(_lang('Action')); ?></th>
				
						</thead>
						<tbody>
						   <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
			    
			    <?php
			      $ccNum          = $data->card_number??0;
   // function getTruncatedCCNumber($ccNum){
       /* $last4Digits    = preg_replace( "#(.*?)(\d{4})$#", "$2", $ccNum);
        $firstDigits    = preg_replace( "#(.*?)(\d{4})$#", "$1", $ccNum);
        $firstDigits1    = preg_replace( "#(.*?)(\d{15})$#", "$1", $ccNum);
     $fvcard1=  preg_replace("#(\d)#", "*", $firstDigits) . $last4Digits;*/
								   $last4= substr(str_replace(['-',' '],'',$ccNum), -4);
								   $fvcard1= str_pad($last4, 16, '*', STR_PAD_LEFT);
								   $first_digit=substr($ccNum, 0, 1);

								   if(Auth::user()->role_id!=0){
									   $fvcard=$first_digit.$fvcard1;
								   }else{
									   if(Auth::user()->card_show==1){
										   $fvcard=$first_digit.$fvcard1;
									   }else{
										   $fvcard= $ccNum;
									   }
								   }
    //}
//$fvcard=   getTruncatedCCNumber($ccNum);
			    ?>
			   <tr>
			    <td><?php echo e($data->group->name??''); ?></td>
			     <td><?php echo e($data->subscription_type); ?></td>
			    <td><?php echo e($data->amount); ?></td>
			    <td><?php echo e($data->payment_mode); ?></td>
			    <td><?php echo e($data->dr_cr); ?></td>
			    <td><?php echo e($data->payment_date); ?></td>
			    <?php if(empty($data->refund_type)): ?>
			    <td>Credit</td>
			    <?php else: ?>
			     <td><?php echo e($data->refund_type??'NA'); ?> Refund</td>
			    <?php endif; ?>
			    
			   <td><button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-default<?php echo e($key); ?>">
View All Details
</button>
<!--<button type="button" class="btn btn-info" onclick="window.location.href='refund-payment'">-->
<!--    Refund-->
<!--</button>-->
<?php if(empty($data->refund_type)): ?>
					   <a href="<?php echo e(url('sale/sale_transaction-edit/'.$data->id)); ?>" class="btn btn-primary">Edit</a>
<a href="<?php echo e(url('sale/refund-payment/'.$data->id)); ?>" class="btn btn-info">Refund</a>

 <form method="POST" action="<?php echo e(url('sale/refund-payment/dispute/'.$data->id)); ?>" style="display: inline;">
    <?php echo csrf_field(); ?>
    <button type="submit" class="btn btn-warning" onclick="return confirm('Do you want to dispute or not?')">Dispute</button>
</form>
					   <form method="POST" action="<?php echo e(url('sale/sale_transaction-delete/'.$data->id)); ?>" style="display: inline;">
						   <?php echo csrf_field(); ?>
						   <button type="submit" class="btn btn-danger" onclick="return confirm('Do you want to Delete or not?')">Delete</button>
					   </form>



<?php endif; ?>

</td></tr>
			  
			 
			   
</div>
<div class="modal fade" id="modal-default<?php echo e($key); ?>">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h4 class="modal-title">Details</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>
<div class="modal-body">
    
<div class="row"> 

<div class="col-md-6">
    <p class="tbl-dt"><b>Type:-</b> <?php echo e($data->group->name??''); ?></p>
<p class="tbl-dt"><b>Amount:-</b> <?php echo e($data->amount); ?></p>
<p class="tbl-dt"><b>Payment Id:-</b> <?php echo e($data->payment_id); ?></p>
<p class="tbl-dt"><b>Payment Mode:-</b> <?php echo e($data->payment_mode); ?></p>
<p class="tbl-dt"><b>Payment frequescy:-</b> <?php echo e($data->subscription_type); ?></p>
<p class="tbl-dt"><b>Account Number:-</b> <?php echo e($data->account_number??'NA'); ?></p>
<p class="tbl-dt"><b>Routing No:-</b> <?php echo e($data->route_name??'NA'); ?></p>
<p class="tbl-dt"><b>Bank Name:-</b> <?php echo e($data->bank_name??'NA'); ?></p>
<p class="tbl-dt"><b>Card Number:-</b> <?php echo e($fvcard??'NA'); ?></p>
</div>


<div class="col-md-6">
<p class="tbl-dt"><b>Payment Date:-</b> <?php echo e($data->payment_date); ?></p>
<p class="tbl-dt"><b>Type:-</b> <?php echo e($data->dr_cr); ?></p>
<p class="tbl-dt"><b>Payee Name:-</b> <?php echo e($data->payee_name); ?></p>
<p class="tbl-dt"><b>Expiry Month:-</b> <?php echo e($data->expiry_month??'NA'); ?></p>

<p class="tbl-dt"><b>Expiry Year:-</b> <?php echo e($data->expiry_year??'NA'); ?></p>
<p class="tbl-dt"><b>Cvv:-</b> <?php echo e($data->cvv??'NA'); ?></p>
<p class="tbl-dt"><b>Cheque no:-</b> <?php echo e($data->check_no??'NA'); ?></p>

<?php if($data->refund_type=='Full amount' || $data->refund_type=='Partial'): ?>

<p class="tbl-dt"><b>Refund Amount:-</b> <?php echo e($data->refundable_amount); ?></p>
<?php endif; ?>

 

<?php if($data->refund_type=='Dispute'): ?>

<p class="tbl-dt"><b>Dispute Amount:-</b> <?php echo e($data->amount); ?></p>
<?php endif; ?>



<?php if($data->refund_payment_id): ?>

<p class="tbl-dt"><b>Refund payment Id :-</b> <?php echo e($data->refund_payment_id); ?></p>
<?php endif; ?>
</div>


</div>

</div>
<div class="modal-footer justify-content-between d-none">
<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
</div>
</div>

</div>

</div>   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			   
			    
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
				   </table>
				</div>
			 </div>
		  </div>
		   <div id="notes" class="tab-pane fade">
		       <div class="card">
				<div class="card-body">	
					<form action="<?php echo e(url('contacts/notes/'.$contact->id)); ?>"  method="post">
						<?php echo e(csrf_field()); ?>

					
						<div class="col-md-12">
						  <div class="form-group">
							<label class="control-label"><?php echo e(_lang('Notes')); ?> *</label>						
							<textarea class="form-control summernote" name="note"><?php echo e(old('note')); ?></textarea>
						  </div>
						</div>
						<div class="col-md-12">
						  <div class="form-group">
							<button type="submit" class="btn btn-primary"><?php echo e(_lang('Save')); ?></button>
						  </div>
						</div>
					</form>
			     </div>
			  </div>
			<div class="card">
				<div class="card-body">	
					<table class="table table-bordered data-table">
						<thead>			
						<th><?php echo e(_lang('Note')); ?></th>
				<th><?php echo e(_lang('Date')); ?></th>
			<!--	<th class="text-center"><?php echo e(_lang('Action')); ?></th>-->
				
						</thead>
						<tbody>
						   <?php $__currentLoopData = $notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$na): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
			    
			
			    <tr>
			    <td><?php echo $na->note??''; ?></td>
			    <td><?php echo e($na->created_at); ?></td>
		</tr>
			   
			   
			   
			   
</div>
 
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
				   </table>
				</div>
			 </div>
		  </div>
		  
		  <div id="email" class="tab-pane fade">
		    <div class="card">
				<div class="card-body">	
					<form action="<?php echo e(url('contacts/send_email/'.$contact->id)); ?>" class="validate" method="post">
						<?php echo e(csrf_field()); ?>

						<div class="col-md-12">
						  <div class="form-group">
							<label class="control-label"><?php echo e(_lang('Email Subject')); ?></label>						
							<input type="text" class="form-control" name="email_subject" value="<?php echo e(old('email_subject')); ?>" required>
						  </div>
						</div>
						<div class="col-md-12">
						  <div class="form-group">
							<label class="control-label"><?php echo e(_lang('Email Message')); ?> *</label>						
							<textarea class="form-control summernote" name="email_message"><?php echo e(old('email_message')); ?></textarea>
						  </div>
						</div>
						<div class="col-md-12">
						  <div class="form-group">
							<button type="submit" class="btn btn-primary"><?php echo e(_lang('Send Email')); ?></button>
						  </div>
						</div>
					</form>
			     </div>
			  </div>
		  </div>
 
	  </div> <!--End TAB-->
	</div><!--End Col-->
</div><!--End Row-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js-script'); ?>
<script>
(function($) {
    "use strict";
    
	$('.nav-tabs a').on('shown.bs.tab', function(event){
		var tab = $(event.target).attr("href");
		var url = "<?php echo e(url('contacts/'.$contact->id)); ?>";
	    history.pushState({}, null, url + "?tab=" + tab.substring(1));
	});

	<?php if(isset($_GET['tab'])): ?>
	   $('.nav-tabs a[href="#<?php echo e($_GET['tab']); ?>"]').tab('show')
	<?php endif; ?>

})(jQuery);
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/backend/accounting/contacts/contact/view.blade.php ENDPATH**/ ?>