<form id="create-group" action="{{ url('live_chat/store_group') }}" method="post" autocomplete="off">
    @csrf

    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label">{{ _lang('Group Name') }}</label>
                <input type="text" class="form-control" name="name" value="{{ old('name') }}" required>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label">{{ _lang('Group Members') }}</label>
                <select class="form-control select2" id="group-members" name="members[]" multiple data-placeholder="{{ _lang('Select Group Members') }}" required>
                    <optgroup label="{{ _lang('Team Members') }}">
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ in_array($user->id, old('members', [])) ? 'selected' : '' }}>
                                {{ $user->name }}
                            </option>
                        @endforeach
                    </optgroup>

                    <optgroup label="{{ _lang('Clients') }}">
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ in_array($client->id, old('members', [])) ? 'selected' : '' }}>
                                {{ $client->name }}
                            </option>
                        @endforeach
                    </optgroup>
                </select>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="control-label">{{ _lang('Description') }}</label>
                <textarea class="form-control" name="description">{{ old('description') }}</textarea>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <button type="reset" class="btn btn-danger">{{ _lang('Reset') }}</button>
                <button type="submit" class="btn btn-primary">{{ _lang('Save') }}</button>
            </div>
        </div>
    </div>
</form>
