@extends('layouts.app')

@section('content')

@if (\Session::has('paypal_success'))
  <div class="alert alert-success text-center">
	<b>{{ \Session::get('paypal_success') }}</b>
  </div>
  <br>
@endif

@php 
$currency = currency(); 
$date_format = get_company_option('date_format','Y-m-d');
@endphp

<!--Start Card-->
<div class="row">
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg1">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Customers') }}</span>
					</div>
					<h2>{{ $converted_by_user_id }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg2">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Current Month Sale') }}</span>
					</div>
					<h2>{{ decimalPlace($total_current_month_sale, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg4">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Previous Month Sale') }}</span>
					</div>
					<h2>{{ decimalPlace($total_previous_month_sale, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg2">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Current Year Sale') }}</span>
					</div>
					<h2>{{ decimalPlace($total_current_year_sale, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg3">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Previous Year Sale') }}</span>
					</div>
					<h2>{{ decimalPlace($total_previous_year_sale, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg1">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Gross Income') }}</span>
					</div>
					<h2>{{ decimalPlace($total_sale, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>

</div>
{{--<div class="row">--}}
{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg1">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Current Month Income') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ decimalPlace($current_month_income, $currency) }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}
{{--	--}}
{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg2">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Current Month Expense') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ decimalPlace($current_month_expense, $currency) }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg4">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Project In Progress') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ isset($project_status['in_progress']) ? $project_status['in_progress'] : '0' }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}
{{--	--}}
{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg2">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Completed Project') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ isset($project_status['completed']) ? $project_status['completed'] : '0' }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<!-- **************************** Start lead section ************************************ -->--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg1">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Total Leads') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_lead_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}
{{--	--}}
{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg2">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Converted') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_converted_lead_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg4">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Hot Prospect') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_hot_lead_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}
{{--	--}}
{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg2">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Follow Up') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_follow_lead_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<!-- **************************** End lead section ************************************** -->--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg1">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Total Invoice') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_invoice_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg3">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Unpaid Invoice') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $unpaid_invoice_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg4">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Current Month Renewals') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $upcoming_renewal }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg3">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Canceled Invoice') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $canceled_invoice_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<!-- ************************************************** EMployees Section ********************************* -->--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg1">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Total Employees') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_employees_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg3">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('New Joinee') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_new_employees_count }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg4">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Total Demo') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $total_demo }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<div class="col-md-3 mb-3">--}}
{{--		<div class="card">--}}
{{--			<div class="seo-fact sbg3">--}}
{{--				<div class="p-4">--}}
{{--					<div class="seofct-icon">--}}
{{--						<span>{{ _lang('Canceled Demo') }}</span>--}}
{{--					</div>--}}
{{--					<h2>{{ $canceled_demo }}</h2>--}}
{{--				</div>--}}
{{--			</div>--}}
{{--		</div>--}}
{{--	</div>--}}

{{--	<!-- ************************************************** End section *************************************** -->--}}

{{--</div>--}}
<!--end row-->
<!--End Card-->

<div class="row">
  <div class="col-md-6">
	 <div class="card">
		<div class="card-body">
		   <h4 class="header-title mt-0">{{ _lang('Income VS Expense')." - ".date('Y') }}</h4>
		   <div id="yearly_income_expense"></div>	
		</div>
	 </div>
  </div>

  <div class="col-md-6">
	 <div class="card">
		<div class="card-body">
			<div>
				<select id="year_select_box" class="form-control year_select_box">
           		<option value="">Select Year</option>
       			@php
			  		$currently_selected = date('Y');
			  		$earliest_year = 2015;
			  		$latest_year = date('Y'); 
			  	@endphp
				@foreach( range( $latest_year, $earliest_year ) as $i )
				    <option value="{{$i}}">{{ $i }}</option>
				@endforeach	
           	</select>
<a class="btn btn-primary btn-xs" id="upload_previous_data" style="display: none;" href="#" data-toggle="modal" data-target="#myModal">Upload File</a>
<a class="btn btn-primary btn-xs" href="https://crm.projectdigitalhubsolution.com/xlsx_sample/month.csv">Sample File</a>
			</div>
           	

			<div class="row">
		    <div class="col-md-6">
	<div id="piechart1" class="piechart">
		{!! $graph1 !!} 
	</div>
</div>
<div class="col-md-6">
	<div id="piechart2" class="piechart">
		{!! $graph2 !!} 
	</div>

  </div>	
</div>
		</div>
	 </div>
  </div>
 
</div>


<div class="container">
<!--   <h2>Modal Example</h2> -->
  <!-- Button to Open the Modal -->
<!--   <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
    Open modal
  </button> -->

  <!-- The Modal -->
  <div class="modal" id="myModal">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Upload CSV</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        
        <!-- Modal body -->
        <div class="modal-body">
         <form action="{{ url('/previous-data') }}" enctype="multipart/form-data" method="post">
         	{{ csrf_field() }}
		  <div class="form-group">
		    <label for="email">Attach File:</label>
		    <input type="hidden" class="form-control" name="year" id="year_csv">
		    <input type="file" class="form-control" placeholder="Enter email" id="email" name="file">
		  </div>
		  <button type="submit" class="btn btn-primary">Submit</button>
		</form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<div class="row d-flex align-items-stretch">

  <!-- Panel 1 -->
  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		    <h4 class="header-title mt-0">{{ _lang('Recent Projects') }}</h4>
		    <div class="table-responsive card-scroll">
			    <table class="table">
				      <thead>
					    <tr>
							<th>{{ _lang('Name') }}</th>	
							<th>{{ _lang('Start Date') }}</th>
							<th>{{ _lang('End Date') }}</th>
							<th>{{ _lang('Status') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
						@foreach(Auth::user()->projects->take(10) as $project)
						    <tr>
								<td><a href="{{ action('ProjectController@show', $project->id) }}">{{ $project->name }}</a></td>
								<td>{{ date($date_format,strtotime($project->start_date)) }}</td>
								<td>{{ date($date_format,strtotime($project->end_date)) }}</td>
								<td>{!! clean(project_status($project->status)) !!}</td>
								<td>
									<form action="{{ action('ProjectController@destroy', $project['id']) }}" class="text-center" method="post">
										<a href="{{ action('ProjectController@edit', $project['id']) }}" data-title="'. _lang('Update Project') .'" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
										{{ csrf_field() }}
										<input name="_method" type="hidden" value="DELETE">
										<button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
									</form>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div>
  <!-- End Panel 1 -->

  <!-- Panel 2 -->
  <!-- <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">{{ _lang('Recent Tasks') }}</h4>
		   <div class="table-responsive card-scroll">
			   <table class="table">
				    <thead>
					    <tr>
							<th>{{ _lang('Name') }}</th>	
							<th>{{ _lang('Priority') }}</th>
							<th>{{ _lang('Status') }}</th>
							<th>{{ _lang('Deadline') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
						@foreach(Auth::user()->tasks->take(10) as $task)
						    <tr>
								<td><a href="{{ action('TaskController@show', $task->id) }}" data-title="{{ $task->title }}" class="ajax-modal">{{ $task->title }}</a></td>
								<td>{!! clean(task_priority($task->priority)) !!}</td>
								<td>
									<span class='badge badge-primary' style='background:{$task->status->color}'>{{ $task->status->title }}</span>
								</td>
								<td>{{ date($date_format,strtotime($task->end_date)) }}</td>
								<td>
									<form action="{{ action('TaskController@destroy', $task['id']) }}" class="text-center" method="post">
										<a href="{{ action('TaskController@edit', $task['id']) }}" data-title="'. _lang('Update Project') .'" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
										{{ csrf_field() }}
										<input name="_method" type="hidden" value="DELETE">
										<button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
									</form>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div> -->

  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">{{ _lang('Hot Prospect') }}</h4>
		   <div class="table-responsive card-scroll">
			   <table class="table">
				    <thead>
					    <tr>
							<th>{{ _lang('Name') }}</th>
							<th>{{ _lang('Email') }}</th>
							<th>{{ _lang('Phone') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
						@foreach($leads as $key => $lead)
						    <tr>
								<td><a href="{{ action('LeadController@show', $lead->id) }}" data-title="{{ _lang('View Lead Details') }}" class="ajax-modal">{{ $lead->name }}</a></td>
								<td>{{ $lead->email }}</td>
								<td>{{ $lead->phone }}</td>
								<td>
							<form action="{{ action('LeadController@destroy', $lead['id']) }}" class="text-center" method="post">
								<a href="{{ action('LeadController@show', $lead['id']) }}" data-title="{{ _lang('View Lead Details') }}" class="btn btn-primary btn-xs ajax-modal"><i class="ti-eye"></i></a>
								<a href="{{ action('LeadController@edit', $lead['id']) }}" data-title="{{ _lang('Update Lead') }}" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
                                {{ csrf_field() }}
                                <input name="_method" type="hidden" value="DELETE">
                                <button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
                            </form>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div>
  <!-- End Panel 2 -->

</div>

<div class="row mt-4 d-flex align-items-stretch">
  <!-- Panel 3 -->
  <!-- <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">{{ _lang('Income vs Expense')." - ".date('M, Y') }}</h4>
		   <div id="dn_income_expense"></div>
		</div>
	 </div>
  </div> -->

  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">Reminders</h4>
		   <div class="table-responsive">
			<table class="table table-bordered">
				<thead>
				  <tr>
					<th>Client</th>
					<th>Email</th>
					<th>Phone</th>
					<th>Note</th>
					<th>View</th>
				  </tr>
				</thead>
				<tbody>

				  @foreach($reminders as $key => $value)
				  @php
				  	$today = \Carbon\Carbon::now();
    				$td = $today->format('Y-m-d');
    				$re_date = date("Y-m-d", strtotime($value->date) );
				  @endphp
				  <tr id="row_{{ $value->id }}" class="@if($re_date >= $td) {{ 'alert alert-success' }} @else {{ 'alert alert-danger' }} @endif">
					<td class='account_title'>{{ client_name($value->lead_id) }}</td>
					<td class='account_number'>{{ client_email($value->lead_id) }}</td>
					<td class='opening_balance'>{{ client_phone($value->lead_id) }}</td>
					<td class='opening_balance'>{{ $value->description }}</td>
					<td class='opening_balance text-center'><a class="btn btn-primary btn-xs" href="{{ url('/') }}/leads/{{ $value->lead_id }}"><i class="ti-eye"></i></a></td>
				  </tr>
				  @endforeach
				</tbody>
			  </table>
            </div>
		</div>
	 </div>
  </div>


  <!-- End Panel 3 -->
  <!-- Panel 4 -->

<div class="col-md-6">
	<div class="card h-100">
		<div class="card-body">
		  	<h4 class="header-title mt-0">Employee of the month</h4>
		  	<div class="table-responsive">
				<table class="table table-bordered">
					<thead>
					  <tr>
						<th>Name</th>
						<th>Email</th>
						<th>Score</th>
					  </tr>
					</thead>
					@if($user == 'no')
					<tbody>
						<tr id="row_1">
						<td>No record found!</td>
					  	</tr>
					</tbody>
					@else
					<tbody>
					  @foreach($user as $key => $value)
					  <tr id="row_{{ $value['id'] }}" class="alert alert-success">
						<td class='account_title'>{{ $value['name'] }}</td>
						<td class='account_number'>{{ $value['email'] }}</td>
						<td class='opening_balance text-right'>{{ round($percentage) }}%</td>
					  </tr>
					  @endforeach
					</tbody>
					@endif
				</table>
            </div>
		</div>
	</div>
</div>


   {{-- <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		  <h4 class="header-title mt-0">{{ _lang('Financial Balance Status') }}</h4>
		  <div class="table-responsive">
			<table class="table table-bordered">
				<thead>
				  <tr>
					<th>{{ _lang('A/C') }}</th>
					<th>{{ _lang('A/C Number') }}</th>
					<th class="text-right">{{ _lang('Balance') }}</th>
				  </tr>
				</thead>
				<tbody>
				  @foreach(get_financial_balance() as $account)
				  <tr id="row_{{ $account->id }}">
					<td class='account_title'>{{ $account->account_title.' ('.$account->account_currency.')' }}</td>
					<td class='account_number'>{{ $account->account_number }}</td>
					<td class='opening_balance text-right'>{{ decimalPlace($account->balance, currency($account->account_currency)) }}</td>
				  </tr>
				  @endforeach
				</tbody>
			  </table>
            </div>
		</div>
	 </div>
  </div>  --}}
  <!-- End Panel 4 -->
</div>
@endsection

@section('js-script')
<script src="{{ URL::asset('/backend/assets/js/dashboard.js?v=1.1') }}"></script>
<script type="text/javascript">
 $(function () {
 $('[data-toggle="tooltip"]').tooltip()
})
</script>
@endsection
