@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card panel-default">
                <span class="d-none panel-title">{{ _lang('Sale Transcation') }} </span>
                @php /*<span class="panel-title">{{ $contact->contact_name }} ({{$contact->company_name }} )</span> */@endphp

                <div class="card-body">
                    <h4>Company Name : {{ $contact->company_name }} </h4><br>
                    <form method="post" class="validate" autocomplete="off" action="{{ url('sale/sale_transaction_update/'.$data->id) }}" enctype="multipart/form-data">
                        <div class="row">

                            {{ csrf_field() }}

                            <div class="col-md-6">
                                <div class="form-group">
                                    <a href="{{ route('contact_groups.create') }}" data-reload="false" data-title="{{ _lang('Add Contact Group') }}" class="ajax-modal-2 select2-add"><i class="ti-plus"></i> {{ _lang('Add New') }}</a>
                                    <label class="control-label">{{ _lang('Type') }}</label>
                                    <select class="form-control select2-ajax" data-value="id" data-display="name" data-table="contact_groups" data-where="1" name="group_id" required>
                                        <option value="">{{ _lang('- Select Type -') }}</option>
                                        {{ create_option("contact_groups","id","name",$data->group_id,array("company_id="=>company_id())) }}
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Subscription frequescy') }}</label>
                                    <select class="form-control select2" name="subscription_type" required>
                                        <option value="Yearly" {{$data->subscription_type=='Yearly'?'selected':''}}>{{ _lang('Yearly') }}</option>
                                        <option value="Half Yearly" {{$data->subscription_type=='Half Yearly'?'selected':''}}>{{ _lang('Half Yearly') }}</option>

                                        <option value="Quarterly" {{$data->subscription_type=='Quarterly'?'selected':''}}>{{ _lang('Quarterly') }}</option>
                                        <option value="monthly" {{$data->subscription_type=='monthly'?'selected':''}}>{{ _lang('monthly') }}</option>
                                        <option value="2 Yearly" {{$data->subscription_type=='2 Yearly'?'selected':''}}>{{ _lang('2 Yearly') }}</option>
                                        <option value="3 Yearly" {{$data->subscription_type=='3 Yearly'?'selected':''}}>{{ _lang('3 Yearly') }}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Amount') }}</label>
                                    <input type="number" min="0" step="any" class="form-control" name="amount" value="{{$data->amount}}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Payment Mode') }}</label>
                                    <select class="form-control" name="payment_mode" id="paymentmode" required>
                                        <option value="">Select Payment Mode</option>
                                        <option value="Credit Card" {{$data->payment_mode=='Credit Card'?'selected':''}}>Credit Card</option>
                                        <option value="Cheque Payee" {{$data->payment_mode=='Cheque Payee'?'selected':''}}>Cheque</option>
                                    </select>
                                </div>
                            </div>




                            <div class="col-md-6 d-none">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Payment status') }}</label>
                                    <select class="form-control" data-selected="{{ old('dr_cr') }}" id="dr_cr" name="dr_cr" required>
                                        <!-- <option value="Debit">Debit </option>-->
                                        <option value="Credit" selected>Credit </option>
                                        <!-- <option value="Refund">Refund </option>
                                          <option value="Partial">Partial </option>
                                           <option value="Full amount">Full amount </option>
                                            <option value="Dispute amount">Dispute amount</option>-->
                                    </select>
                                </div>
                            </div>




                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Payment Date') }}</label>
                                    <input type="date" class="form-control" name="payment_date" value="{{ \Carbon\Carbon::parse($data->payment_date)->format('Y-m-d')}}" autocomplete="on" required>
                                </div>
                            </div>



                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Payment Id') }}</label>
                                    <input type="text" class="form-control" name="payment_id" value="{{$data->payment_id }}" >
                                </div>
                            </div>


                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Notes') }}</label>
                                    <textarea class="form-control" name="notes"  >{{$data->notes}} </textarea>
                                </div>
                            </div>



                            <div class="col-md-6" style="display:none" id="payee_name">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('name on the card/cheque') }}</label>
                                    <input type="text" class="form-control" name="payee_name" value="{{ $data->payee_name }}">
                                </div>
                            </div>
                            <!-- card details -->
                            <div class="col-md-6" style="display:none" id="card_number">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Card Number') }}</label>
                                    <input type="text" class="form-control"  name="card_number" value="{{ $data->card_number }}">
                                </div>
                            </div>

                            <div class="col-md-6" style="display:none" id="expiry_month">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Expiry Month') }}</label>
                                    <input type="text" class="form-control" name="expiry_month" value="{{ $data->expiry_month }}">
                                </div>
                            </div>
                            <div class="col-md-6" style="display:none" id="expiry_year">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Expiry Year') }}</label>
                                    <input type="text" class="form-control" name="expiry_year" value="{{ $data->expiry_year }}">
                                </div>
                            </div>

                            <div class="col-md-6" style="display:none" id="cvv">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('CVV Number') }}</label>
                                    <input type="text" class="form-control" name="cvv" value="{{ $data->cvv }}">
                                </div>
                            </div>

                            <!-- UPI input -->

                            <!--	<div class="col-md-6" style="display:none" id="aph">
					  	   <div class="form-group">
							<label class="control-label">{{ _lang('APH No.') }}</label>
					      <input type="text" class="form-control" name="apbh" value="{{ old('aph') }}">
					  	</div>
					</div>-->
                            <!-- check input -->
                            <div class="col-md-6" style="display:none" id="check_no">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Check Number') }}</label>
                                    <input type="text" class="form-control" name="check_no" value="{{ $data->check_no }}">
                                </div>
                            </div>
                            <!--	<div class="col-md-6" style="display:none" id="check_date">
					  	   <div class="form-group">
							<label class="control-label">{{ _lang('Check Date') }}</label>
					      <input type="text" class="form-control" name="check_date" value="{{ old('check_date') }}">
					  	</div>
					</div>-->
                            <!-- Account input -->


                            <div class="col-md-6" style="display:none" id="route_name">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Routing Name') }}</label>
                                    <input type="text" class="form-control" name="route_name" value="{{ $data->route_name }}">
                                </div>
                            </div>

                            <div class="col-md-6" style="display:none" id="bank_name">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Bank Name') }}</label>
                                    <input type="text" class="form-control" name="bank_name" value="{{ $data->bank_name }}">
                                </div>
                            </div>

                            <div class="col-md-6" style="display:none" id="account_number">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Account Number') }}</label>
                                    <input type="text" class="form-control" name="account_number" value="{{ $data->account_number }}">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary">{{ _lang('Save') }}</button>
                                </div>
                            </div>

                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>


    <style>
        .tbl-dt{ font-size: 15px; line-height: 32px; color: #444; margin-bottom: 0; BORDER: 1px solid;  padding: 5px;}
    </style>


    <!-- Data list show-->

    </div>



@endsection

@section('js-script')

    <script src="https://crm.digitalhubsolution.com/backend/assets/js/vendor/jquery-2.2.4.min.js"></script>

    <script>
        (function($) {
            "use strict";

            document.title = $(".panel-title").html();
            $("#trans_type").val("{{ isset($dr_cr) ? $dr_cr : 'all' }}");

        })(jQuery);
    </script>

    <script type="text/javascript">
        // $('#mySelect').bind('onchange',function(){
        //     alert("test");
        // if (this.value==='Credit Card')
        // {
        //     alert("cc");
        // //this.myform['other'].style.visibility='visible'
        // document.getElementById("element").style.display = "none";
        // }
        // else {
        // this.myform['other'].style.visibility='hidden'};
        // }


        $(document).ready(function () {
            $('#paymentmode').change(function () {

                if ($('#paymentmode').val() == 'Credit Card') {

                    document.getElementById("payee_name").style.display = "block";
                    document.getElementById("card_number").style.display = "block";
                    document.getElementById("expiry_month").style.display = "block";
                    document.getElementById("expiry_year").style.display = "block";
                    document.getElementById("cvv").style.display = "block";
                    document.getElementById("bank_name").style.display = "block";

                    document.getElementById("account_number").style.display = "none";
                    document.getElementById("route_name").style.display = "none";
                    document.getElementById("check_no").style.display = "none";

                    /* document.getElementsByName("payee_name")[0].setAttribute('required', '');
                     document.getElementsByName("card_number")[0].setAttribute('required', '');
                     document.getElementsByName("expiry_month")[0].setAttribute('required', '');
                     document.getElementsByName("expiry_year")[0].setAttribute('required', '');
                     document.getElementsByName("cvv")[0].setAttribute('required', '');

                     document.getElementsByName("account_number")[0].setAttribute('', '');
                     document.getElementsByName("route_name")[0].setAttribute('', '');
                     document.getElementsByName("check_no")[0].setAttribute('', '');
     */


                    //   $('#other').show();
                }else if($('#paymentmode').val() == 'Debit Card'){
                    document.getElementById("payee_name").style.display = "block";
                    document.getElementById("card_number").style.display = "block";
                    document.getElementById("expiry_month").style.display = "block";
                    document.getElementById("expiry_year").style.display = "block";
                    document.getElementById("cvv").style.display = "block";

                    document.getElementById("upi_id").style.display = "none";
                    document.getElementById("account_number").style.display = "none";
                    document.getElementById("ifsc_code").style.display = "none";
                    document.getElementById("bank_name").style.display = "none";
                    document.getElementById("check_no").style.display = "none";
                    document.getElementById("check_date").style.display = "none";


                    //   style
                    /*  document.getElementsByName("payee_name")[0].setAttribute('required', '');
                      document.getElementsByName("card_number")[0].setAttribute('required', '');
                      document.getElementsByName("expiry_month")[0].setAttribute('required', '');
                      document.getElementsByName("expiry_year")[0].setAttribute('required', '');

                      document.getElementsByName("cvv")[0].setAttribute('required', '');
                      document.getElementsByName("upi_id")[0].setAttribute('', '');
                      document.getElementsByName("account_number")[0].setAttribute('', '');
                      document.getElementsByName("ifsc_code")[0].setAttribute('', '');
                      document.getElementsByName("check_no")[0].setAttribute('', '');
                      document.getElementsByName("check_date")[0].setAttribute('', ''); */



                }else if($('#paymentmode').val() == 'UPI'){
                    document.getElementById("payee_name").style.display = "block";
                    document.getElementById("upi_id").style.display = "block";


                    document.getElementById("card_number").style.display = "none";
                    document.getElementById("expiry_month").style.display = "none";
                    document.getElementById("expiry_year").style.display = "none";
                    document.getElementById("cvv").style.display = "none";
                    document.getElementById("account_number").style.display = "none";
                    document.getElementById("ifsc_code").style.display = "none";
                    document.getElementById("bank_name").style.display = "none";
                    document.getElementById("check_no").style.display = "none";
                    document.getElementById("check_date").style.display = "none";

                    //  style
                    /*
                            document.getElementsByName("payee_name")[0].setAttribute('required', '');
                            document.getElementsByName("upi_id")[0].setAttribute('required', '');
                        document.getElementsByName("card_number")[0].setAttribute('', '');
                        document.getElementsByName("expiry_month")[0].setAttribute('', '');
                        document.getElementsByName("expiry_year")[0].setAttribute('', '');
                        document.getElementsByName("cvv")[0].setAttribute('', '');

                        document.getElementsByName("account_number")[0].setAttribute('', '');
                        document.getElementsByName("ifsc_code")[0].setAttribute('', '');
                        document.getElementsByName("check_no")[0].setAttribute('', '');
                        document.getElementsByName("check_date")[0].setAttribute('', '');
                               */


                }else if($('#paymentmode').val() == 'Cheque Payee'){
                    document.getElementById("payee_name").style.display = "block";
                    document.getElementById("route_name").style.display = "block";
                    document.getElementById("check_no").style.display = "block";
                    document.getElementById("account_number").style.display = "block";
                    document.getElementById("bank_name").style.display = "block";
                    document.getElementById("card_number").style.display = "none";
                    document.getElementById("expiry_month").style.display = "none";
                    document.getElementById("expiry_year").style.display = "none";
                    document.getElementById("cvv").style.display = "none";



                    //  style
                    /*
                            document.getElementsByName("payee_name")[0].setAttribute('required', '');
                                           document.getElementsByName("check_no")[0].setAttribute('required', '');
                                             document.getElementsByName("account_number")[0].setAttribute('required', '');
                        document.getElementsByName("route_name")[0].setAttribute('required', '');
                        document.getElementsByName("card_number")[0].setAttribute('', '');
                        document.getElementsByName("expiry_month")[0].setAttribute('', '');
                        document.getElementsByName("expiry_year")[0].setAttribute('', '');
                        document.getElementsByName("cvv")[0].setAttribute('', '');
                        */






                }else if($('#paymentmode').val() == 'Account Payee'){
                    document.getElementById("payee_name").style.display = "block";
                    document.getElementById("account_number").style.display = "block";
                    document.getElementById("ifsc_code").style.display = "block";
                    document.getElementById("bank_name").style.display = "block";

                    document.getElementById("card_number").style.display = "none";
                    document.getElementById("expiry_month").style.display = "none";
                    document.getElementById("expiry_year").style.display = "none";
                    document.getElementById("cvv").style.display = "none";
                    document.getElementById("upi_id").style.display = "none";
                    document.getElementById("check_no").style.display = "none";
                    document.getElementById("check_date").style.display = "none";




                    //  style

                    /*  document.getElementsByName("payee_name")[0].setAttribute('required', '');
                     document.getElementsByName("account_number")[0].setAttribute('required', '');
                     document.getElementsByName("ifsc_code")[0].setAttribute('required', '');

                         document.getElementsByName("upi_id")[0].setAttribute('', '');
                     document.getElementsByName("card_number")[0].setAttribute('', '');
                     document.getElementsByName("expiry_month")[0].setAttribute('', '');
                     document.getElementsByName("expiry_year")[0].setAttribute('', '');
                     document.getElementsByName("cvv")[0].setAttribute('', '');

                     document.getElementsByName("check_no")[0].setAttribute('', '');
                     document.getElementsByName("check_date")[0].setAttribute('', '');
                            */




                }
                else {
                    //   $('#other').hide();
                }
            });
        });



        //btn alert

        function confirmation() {
            swal({
                title: "Are you sure?",
                text: "Once deleted, you will not be able to recover this imaginary file!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
                .then((willDelete) => {
                    if (willDelete) {
                        swal("Poof! Your imaginary file has been deleted!", {
                            icon: "success",
                        });
                    } else {
                        swal("Your imaginary file is safe!");
                    }
                });
        }

    </script>






@endsection


