@extends('layouts.app')

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card panel-default">
                <span class="d-none panel-title">{{ _lang('Customer Reports') }}</span>

                <div class="card-body">
                    <form method="get" action="" enctype="multipart/form-data">
                        <div class="row">
                            {{ csrf_field() }}


                            @if (Auth::user()->role_id != 8)
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>{{ _lang('Marketing Person') }}</label>
                                        <select class="form-control select2 select-filter" name="assigned_user_id">
                                            <option value="">{{ _lang('ALL') }}</option>
                                            {{ create_option_sales('users', 'id', 'name', '', ['company_id=' => company_id(), 'user_type=' => 'staff']) }}
                                        </select>
                                    </div>
                                </div>
                            @endif
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Contact Form Date') }}</label>
                                    <input type="date" class="form-control" name="contact_from_date"
                                        value="{{ old('contact_from_date') }}">
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Contact To Date') }}</label>
                                    <input type="date" class="form-control" name="contact_to_date"
                                        value="{{ old('contact_to_date') }}">
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Subscription Form Date') }}</label>
                                    <input type="date" class="form-control" name="transaction_from_date"
                                        value="{{ request()->get('transaction_from_date') }}">
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('Subscription To Date') }}</label>
                                    <input type="date" class="form-control" name="transaction_to_date"
                                        value="{{ request()->get('transaction_to_date') }}">
                                </div>
                            </div>


                            <div class="col-lg-4">
                                <label>{{ _lang('Timezone') }}</label>
                                <select class="form-control select-filter" name="time_zone" id="time_zone">
                                    <option value="">{{ _lang('ALL') }}</option>
                                    @foreach (App\TimeZoneList::all() as $tiz)
                                        <option value="{{ $tiz->id }}">{{ $tiz->name }}</option>
                                    @endforeach
                                </select>
                            </div>


                            <div class="col-lg-4">
                                <label>{{ _lang('state') }}</label>
                                <select class="form-control select2 select-filter" name="zone_state" id="zone_state">

                                </select>
                            </div>




                            <div class="form-group" style="margin-top:30px;">
                                <div class="col-md-4">
                                    <input type="hidden" class="form-control" name="paginate" value="1">
                                    <button type="submit" class="btn btn-primary">{{ _lang('Search') }}</button>
                                </div>
                            </div>


                        </div>
                    </form>






                    <table id="leads_table" class="table table-striped"
                        style="margin-top:75px;display: block;overflow-y: scroll">
                        <thead>
                            <tr>
                                <th>{{ _lang('Customer ID') }}</th>
                                <th>{{ _lang('Company Name') }}</th>
                                <th>{{ _lang('Contact Name') }}</th>
                                <th>{{ _lang('Email') }}</th>
                                <th>{{ _lang('Phone') }}</th>
                                <th>{{ _lang('Sales Person ') }}</th>


                                <th>{{ _lang('Total Credit') }}</th>
                                <th>{{ _lang('Total Refund') }}</th>
                                <th>{{ _lang('Total Dispute') }}</th>

                                <th>{{ _lang('Subscription Type') }}</th>
                                <!--						<th>{{ _lang('Group Name') }}</th>-->
                                <th>{{ _lang('Action') }}</th>


                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $gtcr = $gtrf = $gtdp = 0;
                            @endphp
                            @foreach ($datas as $data)
                                <?php
                                $transactions = $data->transactions; 
                                $dispute_total = 0;
                                $refund_pf = 0;
                                $total_credit = 0;
                                foreach ($transactions as $trans) {
                                    if ($trans->refund_type == 'Dispute') {
                                        $dispute_total = $dispute_total + ($trans->refundable_amount ?? 0);
                                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                                        $refund_pf = $refund_pf + ($trans->refundable_amount ?? 0);
                                    }
                                    $total_credit = $total_credit + ($trans->amount ?? 0);
                                
                                    $subscription_type = $trans->subscription_type ?? '';
                                    $group_name = $trans->group->name ?? '';
                                
                                    //	print_r($trans); die;
                                }
                                $gtcr = $gtcr + $total_credit;
                                $gtrf = $gtrf + $refund_pf;
                                $gtdp = $gtdp + $dispute_total;
                                ?>

 


							

                                </tr>
                                <td>{{ $data->customer_id }}</td>
                                <td>{{ $data->company_name }}</td>
                                <td>{{ $data->contact_name }}</td>
                                <td>{{ $data->contact_email }}</td>
                                <td>{{ $data->contact_phone }}</td>
                                <td>{{ $data->assignuser->name ?? 'NA' }}</td>

                                <td>{{ $total_credit }}</td>
                                <td>{{ $refund_pf }}</td>
                                <td>{{ $dispute_total }}</td>
                                <td>{{ $subscription_type ?? '' }}</td>
                                <!--					<td>{{ $group_name ?? '' }}</td>-->
                                <td>
                                    <form action="{{ action('ContactController@destroy', $data['id']) }}"
                                        style="    text-align: center !important;width: max-content;" method="post">
                                        <a href="{{ action('ContactController@show', $data['id']) }}"
                                            class="btn btn-primary btn-xs"><i class="ti-eye"></i></a>
                                        <a href="{{ action('SaleTransactionController@subscription_payment', $data['id']) }}"
                                            class="btn btn-info btn-xs"><i class="ti-receipt"></class=></a>
                                        <a href="{{ action('ContactController@edit', $data['id']) }}"
                                            class="btn btn-warning btn-xs"><i class="ti-pencil"></i></a>
                                        @csrf
                                        <input name="_method" type="hidden" value="DELETE">
                                        <button class="btn btn-danger btn-xs btn-remove" type="submit"><i
                                                class="ti-eraser"></i></button>
                                    </form>
                                </td>


                                </tr>
                            @endforeach

							
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td style="font-weight: bold">Total</td>
                                <td style="font-weight: bold">{{ $gtcr }}</td>
                                <td style="font-weight: bold">{{ $gtrf }}</td>
                                <td style="font-weight: bold">{{ $gtdp }}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>Total Credit</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold">{{ $gtcr }}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>Total Refund</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold">-</td>
                                <td style="font-weight: bold">{{ $gtrf }}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>Total Dispute</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold">-</td>
                                <td style="font-weight: bold">{{ $gtdp }}</td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td style="font-weight: bold">Gross Income</td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold"></td>
                                <td style="font-weight: bold">{{ $gtcr - $gtrf - $gtdp }}</td>
                            </tr>
                        </tbody>
                    </table>

                </div>
                <div class="card-header">
                    @if ($paginate != 1)
                        {{ $datas->appends(request()->query())->links() }}
                    @endif
                </div>
            </div>
        </div>
    </div>
@section('js-script')
    <script>
        $(document).ready(function() {
            $('#time_zone').on('change', function() {
                var idCountry = this.value;
                $("#zone_state").html('');
                $.ajax({
                    url: "{{ url('fetch-states') }}",
                    type: "POST",
                    data: {
                        zone_id: idCountry,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#zone_state').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            $("#zone_state").append('<option value="' + value
                                .name + '">' + value.name + '</option>');
                        });
                    }
                });
            });

        });
    </script>
@endsection

@endsection
