@extends('layouts.app')

@section('content')

<div class="row">
	<div class="col-lg-12">
		<div class="card mt-2">
		    
			<span class="panel-title d-none">{{ _lang('Lead List') }}</span>
				
			<div class="card-body">
				<form method="post" action="{{ url('leads/not-assigned-leads') }}">
                            {{ csrf_field() }}
                <div class="row">
                    <div class="col-lg-3">
                     	<label>{{ _lang('Assigned') }}</label>
                     	<select class="form-control" name="assigned_user_id">
                            <option value="">{{ _lang('ALL') }}</option>
                            @foreach($users as $key => $value)
                            <option value="{{ $value['id'] }}">{{ $value['name'] }}</option>
                            @endforeach
                     	</select>
                    </div>	

                    <div class="col-lg-3">
                     	<button class="btn btn-primary btn-xs" type="submit">Assign</button>
                    </div>	
                </div>

                <hr>

				<table id="leads_table" class="table table-striped">
					<thead>
					  <tr>
					  	<th><input type="checkbox" name="select" id="select_lead" value=""></th>
					  	<th>ID</th>
						<th>{{ _lang('Name') }}</th>
						<th>{{ _lang('Company') }}</th>
						<th>{{ _lang('Email') }}</th>
						<th>{{ _lang('Phone') }}</th>
						<!-- <th>{{ _lang('Status') }}</th>
						<th>{{ _lang('Source') }}</th>	 -->
						<th class="text-center">{{ _lang('Action') }}</th>
					  </tr>
					</thead>
					<tbody>  
					    
					</tbody>
				</table>
			</form>
			</div>
		</div>
	</div>
</div>

@endsection

@section('js-script')
<script src="{{ URL::asset('/backend/assets/js/ajax-datatable/not-assigned-leads.js') }}"></script>
@endsection