@extends('layouts.app')

@section('content')

			<div class="row">

	<div class="col-lg-12">

		<div class="card">

			<div class="card-header bg-primary text-white">

				<span class="panel-title">Calculate Lead</span>

			</div>

			<div class="card-body">

			    <form method="post" autocomplete="off" action="{{ url('/leads/calculate') }}" enctype="multipart/form-data" novalidate="">

					{{ csrf_field() }}

					<div class="row">

					    <div class="col-md-4">

					        <div class="form-group">
					            
                                <label class="control-label">Sales Person</label>
                                
						        <select class="form-control select2 select-filter" name="assigned_user_id">
                                    <option value="">{{ _lang('ALL') }}</option>
                                    {{ create_option_sales('users','id','name','',array('company_id=' => company_id(), 'user_type=' => 'staff')) }}
                             	</select>

					        </div>

					    </div>



						<div class="col-md-4">

					        <div class="form-group">

						        <label class="control-label">Month</label>		
                                <select class="form-control select2 select-filter" name="month">
                                    <option value="">Select</option>
                                    <option value="01">01</option>
                                    <option value="02">02</option>
                                    <option value="03">03</option>
                                    <option value="04">04</option>
                                    <option value="05">05</option>
                                    <option value="06">06</option>
                                    <option value="07">07</option>
                                    <option value="08">08</option>
                                    <option value="09">09</option>
                                    <option value="10">10</option>
                                    <option value="11">11</option>
                                    <option value="12">12</option>
                             	</select>

					        </div>

					    </div>



					    <div class="col-md-4">

					        <div class="form-group">

						        <label class="control-label">Year</label>		

						        <select class="form-control select2 select-filter" name="year">
                                    <option value="">Select</option>
                                    <option value="2021">2021</option>
                                    <option value="2022">2022</option>
                             	</select>

					        </div>

					    </div>



						

						<div class="col-md-12">

						    <div class="form-group">

							    <button type="reset" class="btn btn-danger">Reset</button>

							    <button type="submit" class="btn btn-primary">Submit</button>

						    </div>

						</div>

					</div>			

			    </form>
			    @if(isset($leads))
			    <div class="row">
			        <div class="col-md-3 mb-3">
                		<div class="card">
                			<div class="seo-fact sbg1">
                				<div class="p-4">
                					<div class="seofct-icon">
                						<span>Total Leads</span>
                					</div>
                					<h2>{{ count($leads) }}</h2>
                				</div>
                			</div>
                		</div>
                	</div>
			    </div>
                
                
                <hr>

				<table id="leads_table" class="table table-bordered data-table">
					<thead>
					  <tr>
					      <th>ID</th>
						<th>{{ _lang('Name') }}</th>
						<th>{{ _lang('Email') }}</th>
						<th>{{ _lang('Phone') }}</th>
						<th>{{ _lang('Assigned Date ') }}</th>
					  </tr>
					</thead>
					<tbody>
					    @foreach($leads as $key => $value)  
					    <tr>
					      <td>{{ $value->id }}</td>
						<td>{{ $value->name }}</td>
						<td>{{ $value->email }}</td>
						<td>{{ $value->phone }}</td>
						<td>{{ $value->assigned_date }}</td>
					  </tr>
					  @endforeach
					</tbody>
				</table>
				@endif
			</div>

		</div>

    </div>

</div>


@endsection

@section('js-script')

@endsection