@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header bg-primary text-white">
				<span class="panel-title">{{ _lang('View Customer Details') }}</span>
			</div>

			@php $date_format = get_company_option('date_format','Y-m-d'); @endphp
			
			<div class="card-body">  
				<table class="table table-bordered">
					<tr><td>{{ _lang('Customer ID') }}</td><td>{{ $task->customer_id }}</td></tr>
					<tr><td>{{ _lang('Customer Name') }}</td><td>{{ $task->name }}</td></tr>
					<tr><td>{{ _lang('Customer Email') }}</td><td>{{ $task->email }}</td></tr>
					<tr><td>{{ _lang('Customer Number') }}</td><td>{{ $task->phone }}</td></tr>
					<tr><td>{{ _lang('Customer Device Type') }}</td><td>{{ $task->customer_device }}</td></tr>
					<tr><td>{{ _lang('Printer Use Case') }}</td><td>{{ ucwords($task->printer_use_case) }}</td></tr>
					<tr><td>{{ _lang('Printer Problem') }}</td><td>{{ ucwords($task->printer_problem) }}</td></tr>
					<tr><td>{{ _lang('Agent Name') }}</td><td>{{ ucwords($task->agent->name??'') }}</td></tr>
					<tr><td>{{ _lang('Assigned User') }}</td><td>{{ ucwords($task->assigneduser->name??'Admin') }}</td></tr>
					<tr><td>{{ _lang('Type Status') }}</td>
						<td><span class="badge badge-primary">{{ $task->type_status }}</span></td></tr>
					<tr><td>{{ _lang('Comment - Remarks') }}</td><td>{!!  ucwords($task->comments) !!}</td></tr>
					<tr><td>{{ _lang('Subscription Duration *') }}</td><td>{{ $task->subscription_duration }}</td></tr>
					<tr><td>{{ _lang('Amount') }}</td><td>{{ $task->amount }}</td></tr>
					<tr><td>{{ _lang('Customer Address') }}</td><td>{{ $task->address }}</td></tr>
					<tr><td>{{ _lang('Payment Method') }}</td><td>{{ $task->payment_method }}</td></tr>
					<tr><td>{{ _lang('Remote ID') }}</td><td>{{ $task->remote_id }}</td></tr>
					<tr><td>{{ _lang('ID') }}</td><td>{{ $task->loginId }}</td></tr>
					<tr><td>{{ _lang('Password') }}</td><td>{{ $task->password }}</td></tr>
					@if(Auth::user()->user_type == 'user' || Auth::user()->role_id == 17 || Auth::user()->role_id == 8)
					<tr><td>{{ _lang('Document File') }}</td><td>
								<a target="_blank" class="btn btn btn-primary btn-xs" data-title="{{ _lang('View') }}" href="{{ URL::asset('/uploads/caller/'.$task->file) }}">
									<i class="ti-plus"></i> {{ _lang('View File') }}
								</a>
							</td></tr>@endif
{{--					<tr><td>{{ _lang('Exact Name on Card / Check *') }}</td><td>{{ $task->name_card_check }}</td></tr>--}}
{{--					<tr><td>{{ _lang('Card Number ') }}</td><td>{{ $task->card_number }}</td></tr>--}}
{{--					<tr><td>{{ _lang('Card Expiry') }}</td><td>{{ $task->expiry_date }}</td></tr>--}}
{{--					<tr><td>{{ _lang('Card CVV ') }}</td><td>{{ $task->card_cvv }}</td></tr>--}}
{{--					<tr><td>{{ _lang('Routing Number') }}</td><td>{{ $task->routing_number }}</td></tr>--}}
{{--					<tr><td>{{ _lang('Account Number') }}</td><td>{{ $task->account_number }}</td></tr>--}}
{{--					<tr><td>{{ _lang('Check Number') }}</td><td>{{ $task->check_number }}</td></tr>--}}
					<tr><td>{{ _lang('Date') }}</td><td>{{ date("$date_format",strtotime($task->created_at)) }}</td></tr>

				</table>

			</div>
	    </div>
	</div>
</div>
@endsection


