@extends('layouts.app')

@section('content')

<div class="row">
	<div class="col-lg-12">
		<a class="btn btn-primary btn-xs" data-title="{{ _lang('Create Customer') }}" href="{{ route('customer.create') }}">
			<i class="ti-plus"></i> {{ _lang('Add New') }}
		</a>
		@if(Auth::user()->user_type == 'user' || Auth::user()->role_id == 17 || Auth::user()->role_id == 8)
		<a class="btn btn btn-primary btn-xs" data-title="{{ _lang('Export Data') }}" href="{{ route('customer.report') }}">
			<i class="ti-plus"></i> {{ _lang('Export') }}
		</a>
		@endif
		<!--<a class="btn btn-secondary btn-xs" href="{{ url('tasks/kanban') }}"><i class="ti-layout-column3"></i> {{ _lang('Kanban View') }}</a>-->
		<div class="card mt-2">

			<span class="panel-title d-none">{{ _lang('Customer List') }}</span>
				
			<div class="card-body">
				<div class="row">
					<div class="col-md-3">
						<div class="form-group"><label class="control-label">{{ _lang('Assigned User') }}</label>
							<select class="form-control select2 select-filter"
									data-placeholder="{{ _lang('All Customer') }}" name="assigned_user">
								<option value="">Please Select</option>
								<option value="0">Admin</option>
								@foreach($callermanager as $c)
									<option value="{{$c->id}}">{{$c->name}}</option>
								@endforeach

							</select></div>
					</div>
					<div class="col-md-3">
						<div class="form-group"><label
									class="control-label">{{ _lang('Remote ID') }}</label> <select
									class="form-control select2 select-filter"
									data-placeholder="{{ _lang('Remote ID') }}" name="remote_id" id="remote_id" >
								<option value="">Please Select</option>
								<option value="Supremo">Supremo</option>
								<option value="LMI">LMI</option>

							</select></div>
					</div>
					<div class="col-md-3">
						<div class="form-group"><label
									class="control-label">{{ _lang('Payment Method') }}</label> <select
									class="form-control select2 select-filter"
									data-placeholder="{{ _lang('Payment Method') }}" name="payment_method">
								<option value="">Please Select</option>
								<option value="Card with Paypal">Card with Paypal</option>
								<option value="Card with Bill.com">Card with Bill.com</option>
								<option value="Physical Check Mailed" >
									Physical Check Mailed
								</option>
								<option value="Echeck from scan check" >
									Echeck from scan check
								</option>

							</select></div>
					</div>
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Status') }}</label>
                     	 <select class="form-control select2 select-filter" data-placeholder="{{ _lang('All Status') }}" name="type_status" >
							 <option value="">Please Select</option>
							 <option value="Resolved">Resolved</option>
							 <option value="Pending">Pending</option>
                     	 </select>
                     </div>
<!--					<div class="col-md-3">
						<div class="form-group"><label
									class="control-label">{{ _lang('Search') }}</label> <input
									type="text" class="form-control search-filter" name="search"
									value="{{ old('search') }}" ></div>
					</div>-->
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Date Range') }}</label>
                     	 <input type="text" class="form-control select-filter" id="date_range" autocomplete="off" name="date_range">
                     </div>	
	
                </div>

                <hr>

				<table id="caller_table" class="table table-bordered">
					<thead>
					    <tr>
						    <th>{{ _lang('Company ID') }}</th>
							<th>{{ _lang('Customer Name') }}</th>
							<th>{{ _lang('Customer Number ') }}</th>
							<th>{{ _lang('Customer Email') }}</th>
							<th>{{ _lang('Customer Name') }}</th>
							<th>{{ _lang('Amount') }}</th>
							<th>{{ _lang('Assigned User') }}</th>
							<th>{{ _lang('Status') }}</th>
							<th>{{ _lang('Date') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
					</tbody>
				</table>
			</div>
		</div>

	</div>
</div>

@endsection

@section('js-script')
<script src="{{ URL::asset('/backend/assets/js/ajax-datatable/caller.js') }}"></script>
@endsection

