@extends('layouts.app')@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header bg-primary text-white"><span
                            class="panel-title">{{ _lang('Update Customer') }}</span></div>
                <div class="card-body">
                    <form method="post" id="caller" class="validate" autocomplete="off"
                          action="{{ action('CallerController@update', $id) }}"
                          enctype="multipart/form-data">                        {{ csrf_field()}} <input name="_method"
                                                                                                         type="hidden"
                                                                                                         value="PATCH">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Name') }}</label> <input
                                            type="text" class="form-control" name="name" value="{{ $task->name }}"
                                            required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Number') }}</label> <input
                                            type="text" class="form-control" name="phone" value="{{ $task->phone }}"
                                            required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Email') }}</label> <input
                                            type="email" class="form-control" name="email" value="{{ $task->email }}"
                                            required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Device Type') }}</label> <select
                                            class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('Customer Device Type') }}"
                                            name="customer_device">
                                        <option value="">Please Select</option>
                                        <option value="Windows" {{$task->customer_device=='Windows'?'selected':''}}>
                                            Windows
                                        </option>
                                        <option value="Mac" {{$task->customer_device=='Mac'?'selected':''}}>Mac</option>
                                        <option value="Chromebook" {{$task->customer_device=='Chromebook'?'selected':''}}>
                                            Chromebook
                                        </option>
                                        <option value="Mobile" {{$task->customer_device=='Mobile'?'selected':''}}>
                                            Mobile
                                        </option>
                                    </select></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Printer Use Case') }}</label> <select
                                            class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('Printer Use Case') }}" name="printer_use_case">
                                        <option value="">Please Select</option>
                                        <option value="Office --- ready to pay" {{$task->printer_use_case=='Office --- ready to pay'?'selected':''}}>
                                            Office --- ready to pay
                                        </option>
                                        <option value="Office --- not ready to pay" {{$task->printer_use_case=='Office --- not ready to pay'?'selected':''}}>
                                            Office --- not ready to pay
                                        </option>
                                        <option value="Personal --- ready to pay" {{$task->printer_use_case=='Personal --- ready to pay'?'selected':''}}>
                                            Personal --- ready to pay
                                        </option>
                                        <option value="Personal --- not ready to pay" {{$task->printer_use_case=='Personal --- not ready to pay'?'selected':''}}>
                                            Personal --- not ready to pay
                                        </option>
                                    </select></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Printer Problem') }}</label> <textarea
                                            class="form-control"
                                            name="printer_problem">{{ $task->printer_problem }}</textarea></div>
                            </div>
{{--<!--                            <div class="col-md-6">--}}
{{--                                <div class="form-group"><label class="control-label">{{ _lang('Caller Name') }}</label>--}}
{{--                                    <input type="text" class="form-control" name="caller_name"--}}
{{--                                           value="{{ $task->caller_name}}" required></div>--}}
{{--                            </div>-->--}}
                            <div class="col-md-6">
                                <div class="form-group"><label class="control-label">{{ _lang('Status') }}</label>
                                    <select class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('All Status') }}" name="type_status">
                                        <option value="">Please Select</option>
                                        <option value="Resolved" {{$task->type_status=='Resolved'?'selected':''}}>
                                            Resolved
                                        </option>
                                        <option value="Pending" {{$task->type_status=='Pending'?'selected':''}}>
                                            Pending
                                        </option>
                                    </select></div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Subscription Duration') }}</label>
                                    <select class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('All Subscription Duration') }}" name="subscription_duration" required>
                                        <option value="">Please Select</option>
                                        <option value="One Time Fix-3 Months" {{$task->subscription_duration=='One Time Fix-3 Months'?'selected':''}}>One Time Fix-3 Months</option>
                                        <option value="6 months" {{$task->subscription_duration=='6 months'?'selected':''}}>6 months</option>
                                        <option value="1 year" {{$task->subscription_duration=='1 year'?'selected':''}}>1 Year</option>
                                        <option value="2 year" {{$task->subscription_duration=='2 year'?'selected':''}}>2 Year</option>
                                        <option value="3 year" {{$task->subscription_duration=='3 year'?'selected':''}}>3 Year</option>
                                        <option value="4 year" {{$task->subscription_duration=='4 year'?'selected':''}}>4 Year</option>
                                        <option value="5 year" {{$task->subscription_duration=='5 year'?'selected':''}}>5 Year</option>
                                        <option value="Lifetime" {{$task->subscription_duration=='Lifetime'?'selected':''}}>Lifetime</option>

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label class="control-label">{{ _lang('Amount') }}</label>
                                    <input type="number" min="0" value="0" step="any" class="form-control" name="amount"
                                           value="{{ $task->amount }}" required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer  Address') }}</label> <textarea
                                            class="form-control" name="address">{{ $task->address }}</textarea></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">{{ _lang('File') }}</label>
                                    <input type="file" class="form-control dropify" name="file" data-default-file="{{ URL::asset('/uploads/caller/'.$task->file) }}">
                                </div>
                                </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Comment - Remarks') }}</label> <textarea
                                            class="form-control"
                                            name="comments">{!! $task->comments !!} </textarea></div>

                                @if(Auth::user()->user_type == 'user' || Auth::user()->role_id == 17 || Auth::user()->role_id == 8)
                                <a target="_blank" class="btn btn btn-primary btn-xs" data-title="{{ _lang('View') }}" href="{{ URL::asset('/uploads/caller/'.$task->file) }}">
                                    <i class="ti-plus"></i> {{ _lang('View File') }}
                                </a>
                                @endif
                            </div>


                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Payment Method') }}</label> <select
                                            class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('Payment Method') }}" name="payment_method">
                                        <option value="">Please Select</option>
                                        <option value="Card with Paypal" {{$task->payment_method=='Card with Paypal'?'selected':''}}>Card with Paypal</option>
                                        <option value="Card with Bill.com" {{$task->payment_method=='Card with Bill.com'?'selected':''}}>Card with Bill.com</option>
                                        <option value="Physical Check Mailed" {{$task->payment_method=='Physical Check Mailed'?'selected':''}}>
                                            Physical Check Mailed
                                        </option>
                                        <option value="Echeck from scan check" {{$task->payment_method=='Echeck from scan check'?'selected':''}}>
                                            Echeck from scan check
                                        </option>

                                    </select></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Remote ID') }}</label> <select
                                            class="form-control"
                                            data-placeholder="{{ _lang('Remote ID') }}" name="remote_id" id="remote_id" >
                                        <option value="">Please Select</option>
                                        <option value="Supremo" {{$task->remote_id=='Supremo'?'selected':''}}>Supremo</option>
                                        <option value="LMI" {{$task->remote_id=='LMI'?'selected':''}}>LMI</option>

                                    </select></div>
                            </div>

                            <div class="col-md-6" style="display:none" id="loginId">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Id') }}</label>
                                    <input type="text" class="form-control" name="loginId"
                                           value="{{ $task->loginId }}" ></div>
                            </div>
                            <div class="col-md-6" style="display:none" id="password">
                                <div class="form-group"><label class="control-label">{{ _lang('Password') }}</label>
                                    <input type="text" class="form-control" name="password"
                                           value="{{ $task->password }}" ></div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group"><label class="control-label">{{ _lang('Assigned User') }}</label>
                                    <select class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('All User') }}" name="assigned_user">
                                        <option value="">Please Select</option>
                                        <option value="0" {{$task->assigned_user=='0'?'selected':''}}>Admin</option>
                                        @foreach($callermanager as $c)
                                            <option value="{{$c->id}}" {{$c->id==$task->assigned_user?'selected':''}}>{{$c->name}}</option>
                                        @endforeach
                                        <!--                                        <option value="Pending">Pending</option>-->
                                    </select></div>
                            </div>

                            <input type="hidden" name="related_to" value="projects">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <button type="reset" class="btn btn-danger">{{ _lang('Reset') }}</button>
                                    <button type="submit" class="btn btn-primary">{{ _lang('Save') }}</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js-script')
    <script>
        $(document).ready(function () {
            $('#remote_id').change(function () {

                if ($('#remote_id').val() == "Supremo") {

                    document.getElementById("loginId").style.display = "block";
                    document.getElementById("password").style.display = "block";


                    document.getElementsByName("loginId")[0].setAttribute('required', '');
                    document.getElementsByName("password")[0].setAttribute('required', '');

                }else if($('#remote_id').val() == 'LMI'){
                    document.getElementById("loginId").style.display = "block";
                    document.getElementById("password").style.display = "none";

                    document.getElementsByName("loginId")[0].setAttribute('required', '');
                    document.getElementsByName("password")[0].setAttribute('', '');
                }
                else {

                }
            });
        });
    </script>
@endsection