DROP TABLE IF EXISTS accounts;

CREATE TABLE `accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_date` date NOT NULL,
  `account_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_currency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_balance` decimal(10,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO accounts VALUES('1','DHS Dehradun','2020-12-04','9876541230741025','INR','5000.00','Test Account','1','2020-12-04 18:47:09','2020-12-04 18:47:09');



DROP TABLE IF EXISTS activity_logs;

CREATE TABLE `activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `related_to` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_id` bigint(20) DEFAULT NULL,
  `activity` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO activity_logs VALUES('1','projects','1','Created Project','3','1','2020-11-05 11:56:12','2020-11-05 11:56:12');
INSERT INTO activity_logs VALUES('2','projects','1','Assign To Kapil','3','1','2020-11-05 11:56:12','2020-11-05 11:56:12');
INSERT INTO activity_logs VALUES('3','leads','1','Created Lead','3','1','2020-11-05 12:14:23','2020-11-05 12:14:23');
INSERT INTO activity_logs VALUES('4','leads','1','Assign To Kapil','3','1','2020-11-05 12:14:23','2020-11-05 12:14:23');
INSERT INTO activity_logs VALUES('5','leads','1','Updated Lead','4','1','2020-11-05 12:36:47','2020-11-05 12:36:47');
INSERT INTO activity_logs VALUES('6','leads','2','Created Lead','3','1','2020-11-05 16:57:36','2020-11-05 16:57:36');
INSERT INTO activity_logs VALUES('7','leads','2','Assign To Kapil','3','1','2020-11-05 16:57:36','2020-11-05 16:57:36');
INSERT INTO activity_logs VALUES('16','leads','7','Created Lead','3','1','2020-11-05 17:04:20','2020-11-05 17:04:20');
INSERT INTO activity_logs VALUES('17','leads','7','Assign To Kapil','3','1','2020-11-05 17:04:20','2020-11-05 17:04:20');
INSERT INTO activity_logs VALUES('26','leads','12','Created Lead','3','1','2020-11-05 17:08:28','2020-11-05 17:08:28');
INSERT INTO activity_logs VALUES('27','leads','12','Assign To Kapil','3','1','2020-11-05 17:08:28','2020-11-05 17:08:28');
INSERT INTO activity_logs VALUES('28','leads','13','Created Lead','3','1','2020-11-05 17:12:46','2020-11-05 17:12:46');
INSERT INTO activity_logs VALUES('29','leads','13','Assign To Kapil','3','1','2020-11-05 17:12:46','2020-11-05 17:12:46');
INSERT INTO activity_logs VALUES('32','leads','15','Created Lead','3','1','2020-11-05 17:17:30','2020-11-05 17:17:30');
INSERT INTO activity_logs VALUES('33','leads','15','Assign To Kapil','3','1','2020-11-05 17:17:30','2020-11-05 17:17:30');
INSERT INTO activity_logs VALUES('34','leads','15','Added Note','3','1','2020-11-06 10:59:41','2020-11-06 10:59:41');
INSERT INTO activity_logs VALUES('35','leads','15','Uploaded File','3','1','2020-11-06 11:05:09','2020-11-06 11:05:09');
INSERT INTO activity_logs VALUES('36','leads','15','Assign To Viprq','3','1','2020-11-06 11:35:01','2020-11-06 11:35:01');
INSERT INTO activity_logs VALUES('37','leads','15','Updated Lead','3','1','2020-11-06 11:35:01','2020-11-06 11:35:01');
INSERT INTO activity_logs VALUES('38','leads','15','Updated Lead','3','1','2020-11-06 11:54:27','2020-11-06 11:54:27');
INSERT INTO activity_logs VALUES('39','leads','15','Converted Lead To Customer','3','1','2020-11-06 11:55:18','2020-11-06 11:55:18');
INSERT INTO activity_logs VALUES('40','projects','1','Change Project Status - In Progress','3','1','2020-11-06 11:56:53','2020-11-06 11:56:53');
INSERT INTO activity_logs VALUES('41','projects','1','Updated Project','3','1','2020-11-06 11:56:53','2020-11-06 11:56:53');
INSERT INTO activity_logs VALUES('42','leads','15','Updated Lead','3','1','2020-11-09 11:30:54','2020-11-09 11:30:54');
INSERT INTO activity_logs VALUES('43','leads','16','Created Lead','4','1','2020-11-09 21:16:56','2020-11-09 21:16:56');
INSERT INTO activity_logs VALUES('44','leads','16','Assign To Kapil','4','1','2020-11-09 21:16:56','2020-11-09 21:16:56');
INSERT INTO activity_logs VALUES('45','leads','16','Updated Lead','3','1','2020-11-09 23:38:31','2020-11-09 23:38:31');
INSERT INTO activity_logs VALUES('46','leads','16','Added Note','3','1','2020-11-10 16:09:18','2020-11-10 16:09:18');
INSERT INTO activity_logs VALUES('47','leads','16','Uploaded File','3','1','2020-11-10 17:34:50','2020-11-10 17:34:50');
INSERT INTO activity_logs VALUES('48','leads','16','Updated Lead','4','1','2020-11-10 18:27:37','2020-11-10 18:27:37');
INSERT INTO activity_logs VALUES('49','leads','17','Created Lead','9','3','2020-11-10 23:00:12','2020-11-10 23:00:12');
INSERT INTO activity_logs VALUES('50','leads','17','Assign To Test 1','9','3','2020-11-10 23:00:12','2020-11-10 23:00:12');
INSERT INTO activity_logs VALUES('51','leads','18','Created Lead','9','3','2020-11-10 23:00:14','2020-11-10 23:00:14');
INSERT INTO activity_logs VALUES('52','leads','18','Assign To Test 1','9','3','2020-11-10 23:00:14','2020-11-10 23:00:14');
INSERT INTO activity_logs VALUES('53','leads','19','Created Lead','9','3','2020-11-10 23:00:15','2020-11-10 23:00:15');
INSERT INTO activity_logs VALUES('54','leads','19','Assign To Test 1','9','3','2020-11-10 23:00:15','2020-11-10 23:00:15');
INSERT INTO activity_logs VALUES('55','leads','20','Created Lead','9','3','2020-11-10 23:00:16','2020-11-10 23:00:16');
INSERT INTO activity_logs VALUES('56','leads','20','Assign To Test 1','9','3','2020-11-10 23:00:16','2020-11-10 23:00:16');
INSERT INTO activity_logs VALUES('57','leads','21','Created Lead','9','3','2020-11-10 23:00:17','2020-11-10 23:00:17');
INSERT INTO activity_logs VALUES('58','leads','21','Assign To Test 1','9','3','2020-11-10 23:00:17','2020-11-10 23:00:17');
INSERT INTO activity_logs VALUES('59','leads','22','Created Lead','9','3','2020-11-10 23:00:18','2020-11-10 23:00:18');
INSERT INTO activity_logs VALUES('60','leads','22','Assign To Test 1','9','3','2020-11-10 23:00:18','2020-11-10 23:00:18');
INSERT INTO activity_logs VALUES('61','leads','22','Uploaded File','9','3','2020-11-10 23:01:01','2020-11-10 23:01:01');
INSERT INTO activity_logs VALUES('62','leads','20','Assign To kstest','9','3','2020-11-10 23:11:53','2020-11-10 23:11:53');
INSERT INTO activity_logs VALUES('63','leads','20','Updated Lead','9','3','2020-11-10 23:11:53','2020-11-10 23:11:53');
INSERT INTO activity_logs VALUES('64','leads','23','Created Lead','3','1','2020-11-10 23:59:06','2020-11-10 23:59:06');
INSERT INTO activity_logs VALUES('65','leads','23','Assign To Kapil','3','1','2020-11-10 23:59:06','2020-11-10 23:59:06');
INSERT INTO activity_logs VALUES('66','leads','24','Created Lead','3','1','2020-11-10 23:59:07','2020-11-10 23:59:07');
INSERT INTO activity_logs VALUES('67','leads','24','Assign To Kapil','3','1','2020-11-10 23:59:07','2020-11-10 23:59:07');
INSERT INTO activity_logs VALUES('68','leads','25','Created Lead','3','1','2020-11-10 23:59:08','2020-11-10 23:59:08');
INSERT INTO activity_logs VALUES('69','leads','25','Assign To Kapil','3','1','2020-11-10 23:59:08','2020-11-10 23:59:08');
INSERT INTO activity_logs VALUES('70','leads','26','Created Lead','3','1','2020-11-10 23:59:09','2020-11-10 23:59:09');
INSERT INTO activity_logs VALUES('71','leads','26','Assign To Kapil','3','1','2020-11-10 23:59:09','2020-11-10 23:59:09');
INSERT INTO activity_logs VALUES('72','leads','27','Created Lead','3','1','2020-11-10 23:59:10','2020-11-10 23:59:10');
INSERT INTO activity_logs VALUES('73','leads','27','Assign To Kapil','3','1','2020-11-10 23:59:10','2020-11-10 23:59:10');
INSERT INTO activity_logs VALUES('74','leads','28','Created Lead','3','1','2020-11-10 23:59:11','2020-11-10 23:59:11');
INSERT INTO activity_logs VALUES('75','leads','28','Assign To Kapil','3','1','2020-11-10 23:59:11','2020-11-10 23:59:11');
INSERT INTO activity_logs VALUES('76','leads','28','Updated Lead','3','1','2020-11-11 00:06:58','2020-11-11 00:06:58');
INSERT INTO activity_logs VALUES('77','leads','28','Updated Lead','3','1','2020-11-11 17:36:33','2020-11-11 17:36:33');
INSERT INTO activity_logs VALUES('78','leads','28','Converted Lead To Customer','3','1','2020-11-12 22:03:49','2020-11-12 22:03:49');
INSERT INTO activity_logs VALUES('79','leads','29','Created Lead','3','1','2020-11-17 16:21:29','2020-11-17 16:21:29');
INSERT INTO activity_logs VALUES('80','leads','29','Assign To ','3','1','2020-11-17 16:21:29','2020-11-17 16:21:29');
INSERT INTO activity_logs VALUES('81','leads','30','Created Lead','3','1','2020-11-17 16:22:17','2020-11-17 16:22:17');
INSERT INTO activity_logs VALUES('82','leads','30','Assign To ','3','1','2020-11-17 16:22:17','2020-11-17 16:22:17');
INSERT INTO activity_logs VALUES('83','leads','31','Created Lead','3','1','2020-11-17 16:39:37','2020-11-17 16:39:37');
INSERT INTO activity_logs VALUES('84','leads','31','Assign To ','3','1','2020-11-17 16:39:37','2020-11-17 16:39:37');
INSERT INTO activity_logs VALUES('85','leads','31','Assign To Kapil','3','1','2020-11-19 22:52:17','2020-11-19 22:52:17');
INSERT INTO activity_logs VALUES('86','leads','31','Updated Lead','3','1','2020-11-19 22:52:17','2020-11-19 22:52:17');
INSERT INTO activity_logs VALUES('87','leads','31','Converted Lead To Customer','4','1','2020-11-20 16:49:09','2020-11-20 16:49:09');
INSERT INTO activity_logs VALUES('88','leads','31','Assign To Vipra','3','1','2020-11-20 21:01:48','2020-11-20 21:01:48');
INSERT INTO activity_logs VALUES('89','leads','31','Updated Lead','3','1','2020-11-20 21:01:48','2020-11-20 21:01:48');
INSERT INTO activity_logs VALUES('90','leads','31','Added Note','3','1','2020-11-20 21:33:01','2020-11-20 21:33:01');
INSERT INTO activity_logs VALUES('91','leads','26','Added Note','3','1','2020-11-20 21:33:29','2020-11-20 21:33:29');
INSERT INTO activity_logs VALUES('92','leads','26','Updated Lead','3','1','2020-11-20 21:34:15','2020-11-20 21:34:15');
INSERT INTO activity_logs VALUES('93','leads','26','Added Note','3','1','2020-11-20 21:34:47','2020-11-20 21:34:47');
INSERT INTO activity_logs VALUES('94','leads','31','Name has been changed from Jhon Doe to Deepak Lehri','3','1','2020-11-20 21:58:08','2020-11-20 21:58:08');
INSERT INTO activity_logs VALUES('95','leads','31','Updated Lead','3','1','2020-11-20 21:58:08','2020-11-20 21:58:08');
INSERT INTO activity_logs VALUES('96','leads','31','Name has been changed from Deepak Lehri to Deepak Lehri mehra','3','1','2020-11-20 22:12:36','2020-11-20 22:12:36');
INSERT INTO activity_logs VALUES('97','leads','31','Company name has been changed from Jhon\'s Company to Jhon\'s Company test','3','1','2020-11-20 22:12:36','2020-11-20 22:12:36');
INSERT INTO activity_logs VALUES('98','leads','31','Company name has been changed from Jhon\'s Company to Jhon\'s Company test','3','1','2020-11-20 22:12:36','2020-11-20 22:12:36');
INSERT INTO activity_logs VALUES('99','leads','31','Email has been changed from jhondoedfgdfg@gmail.com to jhondoe123@gmail.com','3','1','2020-11-20 22:12:36','2020-11-20 22:12:36');
INSERT INTO activity_logs VALUES('102','leads','31','Status has been changed from 8 to 11','3','1','2020-11-21 18:36:17','2020-11-21 18:36:17');
INSERT INTO activity_logs VALUES('103','leads','31','Status has been changed from 11 to 13','3','1','2020-11-21 18:37:16','2020-11-21 18:37:16');
INSERT INTO activity_logs VALUES('104','leads','31','Status has been changed from 13 to 15','3','1','2020-11-21 18:41:48','2020-11-21 18:41:48');
INSERT INTO activity_logs VALUES('105','leads','31','Assign To Vipra','3','1','2020-11-21 18:41:48','2020-11-21 18:41:48');
INSERT INTO activity_logs VALUES('106','leads','31','Status has been changed from 16 to 15','3','1','2020-11-21 18:53:01','2020-11-21 18:53:01');
INSERT INTO activity_logs VALUES('107','leads','31','Status has been changed from  to ','3','1','2020-11-21 19:08:06','2020-11-21 19:08:06');
INSERT INTO activity_logs VALUES('108','leads','31','Assign To ','3','1','2020-11-21 19:08:06','2020-11-21 19:08:06');
INSERT INTO activity_logs VALUES('110','leads','31','Status has been changed from Wrong Number to Follow Up','3','1','2020-11-21 19:11:22','2020-11-21 19:11:22');
INSERT INTO activity_logs VALUES('111','leads','31','Status has been changed from Follow Up to Loss','3','1','2020-11-21 19:12:03','2020-11-21 19:12:03');
INSERT INTO activity_logs VALUES('112','leads','31','Status has been changed from Loss to Wrong Number','3','1','2020-11-21 19:13:43','2020-11-21 19:13:43');
INSERT INTO activity_logs VALUES('113','leads','31','Status has been changed from Wrong Number to Loss','3','1','2020-11-21 19:13:57','2020-11-21 19:13:57');
INSERT INTO activity_logs VALUES('114','leads','31','Status has been changed from Loss to Wrong Number','3','1','2020-11-21 19:27:08','2020-11-21 19:27:08');
INSERT INTO activity_logs VALUES('115','leads','31','Assign To ','3','1','2020-11-21 19:27:08','2020-11-21 19:27:08');
INSERT INTO activity_logs VALUES('116','leads','31','Status has been changed from Wrong Number to Loss','3','1','2020-11-21 19:27:24','2020-11-21 19:27:24');
INSERT INTO activity_logs VALUES('122','leads','31','Status has been changed from Loss to Wrong Number','3','1','2020-11-21 21:36:32','2020-11-21 21:36:32');
INSERT INTO activity_logs VALUES('123','leads','31','Assign To ','3','1','2020-11-21 21:36:32','2020-11-21 21:36:32');
INSERT INTO activity_logs VALUES('124','leads','31','Status has been changed from Wrong Number to Loss','3','1','2020-11-21 21:37:16','2020-11-21 21:37:16');
INSERT INTO activity_logs VALUES('125','leads','32','Created Lead','3','1','2020-11-23 21:03:31','2020-11-23 21:03:31');
INSERT INTO activity_logs VALUES('126','leads','32','Assign To Kapil','3','1','2020-11-23 21:03:31','2020-11-23 21:03:31');
INSERT INTO activity_logs VALUES('127','leads','32','Converted Lead To Customer','3','1','2020-11-24 17:48:16','2020-11-24 17:48:16');
INSERT INTO activity_logs VALUES('128','leads','25','Converted Lead To Customer','3','1','2020-11-24 17:54:20','2020-11-24 17:54:20');
INSERT INTO activity_logs VALUES('130','leads','25','Source has been changed from 1 to ','3','1','2020-12-03 21:56:07','2020-12-03 21:56:07');
INSERT INTO activity_logs VALUES('131','leads','25','Assign To Kapil','3','1','2020-12-03 21:56:26','2020-12-03 21:56:26');
INSERT INTO activity_logs VALUES('132','leads','26','Status has been changed from Disconnected to Loss','3','1','2020-12-03 21:58:58','2020-12-03 21:58:58');
INSERT INTO activity_logs VALUES('133','leads','26','Assign To ','3','1','2020-12-03 21:59:23','2020-12-03 21:59:23');
INSERT INTO activity_logs VALUES('134','leads','32','Added Note','4','1','2020-12-03 22:08:43','2020-12-03 22:08:43');
INSERT INTO activity_logs VALUES('135','leads','24','Added Note','4','1','2020-12-03 22:09:23','2020-12-03 22:09:23');
INSERT INTO activity_logs VALUES('136','leads','33','Created Lead','3','1','2020-12-08 22:29:24','2020-12-08 22:29:24');
INSERT INTO activity_logs VALUES('137','leads','33','Assign To Kapil','3','1','2020-12-08 22:29:24','2020-12-08 22:29:24');
INSERT INTO activity_logs VALUES('138','leads','33','Added the card details.','3','1','2020-12-22 18:32:24','2020-12-22 18:32:24');
INSERT INTO activity_logs VALUES('139','leads','33','DHS Dehradun  to 4111111111111111','3','1','2020-12-22 18:33:21','2020-12-22 18:33:21');
INSERT INTO activity_logs VALUES('140','leads','33','DHS Dehradun  to 12','3','1','2020-12-22 18:33:21','2020-12-22 18:33:21');
INSERT INTO activity_logs VALUES('141','leads','33','DHS Dehradun  to 22','3','1','2020-12-22 18:33:21','2020-12-22 18:33:21');
INSERT INTO activity_logs VALUES('142','leads','33','DHS Dehradun  to 564','3','1','2020-12-22 18:33:21','2020-12-22 18:33:21');
INSERT INTO activity_logs VALUES('143','leads','33','DHS Dehradun  to Anuj kumar Sharma','3','1','2020-12-22 18:33:21','2020-12-22 18:33:21');
INSERT INTO activity_logs VALUES('144','leads','33',' to 4111111111111111','3','1','2020-12-22 18:39:40','2020-12-22 18:39:40');
INSERT INTO activity_logs VALUES('145','leads','33',' to 10','3','1','2020-12-22 18:39:40','2020-12-22 18:39:40');
INSERT INTO activity_logs VALUES('146','leads','33',' to 24','3','1','2020-12-22 18:39:40','2020-12-22 18:39:40');
INSERT INTO activity_logs VALUES('147','leads','33',' to 564','3','1','2020-12-22 18:39:40','2020-12-22 18:39:40');
INSERT INTO activity_logs VALUES('148','leads','33',' to Anuj kumar Sharma','3','1','2020-12-22 18:39:40','2020-12-22 18:39:40');
INSERT INTO activity_logs VALUES('149','leads','33',' to 4111111111111118','3','1','2020-12-22 18:41:59','2020-12-22 18:41:59');
INSERT INTO activity_logs VALUES('150','leads','33',' to 10','3','1','2020-12-22 18:41:59','2020-12-22 18:41:59');
INSERT INTO activity_logs VALUES('151','leads','33',' to 25','3','1','2020-12-22 18:41:59','2020-12-22 18:41:59');
INSERT INTO activity_logs VALUES('152','leads','33',' to 567','3','1','2020-12-22 18:41:59','2020-12-22 18:41:59');
INSERT INTO activity_logs VALUES('153','leads','33',' to Anuj kumar Sharma','3','1','2020-12-22 18:41:59','2020-12-22 18:41:59');
INSERT INTO activity_logs VALUES('154','leads','33',' to 4111111111111118','3','1','2020-12-22 18:46:04','2020-12-22 18:46:04');
INSERT INTO activity_logs VALUES('155','leads','33',' to 12','3','1','2020-12-22 18:46:04','2020-12-22 18:46:04');
INSERT INTO activity_logs VALUES('156','leads','33',' to 24','3','1','2020-12-22 18:46:04','2020-12-22 18:46:04');
INSERT INTO activity_logs VALUES('157','leads','33',' to 568','3','1','2020-12-22 18:46:04','2020-12-22 18:46:04');
INSERT INTO activity_logs VALUES('158','leads','33',' to Anuj kumar Sharma','3','1','2020-12-22 18:46:04','2020-12-22 18:46:04');
INSERT INTO activity_logs VALUES('159','leads','33','4111111111111118 to 41111111111111112','3','1','2020-12-22 18:59:22','2020-12-22 18:59:22');
INSERT INTO activity_logs VALUES('160','leads','33','12 to 10','3','1','2020-12-22 18:59:22','2020-12-22 18:59:22');
INSERT INTO activity_logs VALUES('161','leads','33','24 to 22','3','1','2020-12-22 18:59:22','2020-12-22 18:59:22');
INSERT INTO activity_logs VALUES('162','leads','33','568 to 567','3','1','2020-12-22 18:59:22','2020-12-22 18:59:22');
INSERT INTO activity_logs VALUES('163','leads','33','Card number changed from 41111111111111112 to 41111111111111111','3','1','2020-12-22 19:01:24','2020-12-22 19:01:24');
INSERT INTO activity_logs VALUES('164','leads','33','Card Exp Month changed from 10 to 12','3','1','2020-12-22 19:01:24','2020-12-22 19:01:24');
INSERT INTO activity_logs VALUES('165','leads','33','Card Exp Date changed from 22 to 24','3','1','2020-12-22 19:01:24','2020-12-22 19:01:24');
INSERT INTO activity_logs VALUES('166','leads','33','Card CVV number changed from 567 to 123','3','1','2020-12-22 19:01:24','2020-12-22 19:01:24');
INSERT INTO activity_logs VALUES('167','leads','33','Name on card changed from Anuj kumar Sharma to Anuj Sharma','3','1','2020-12-22 19:01:24','2020-12-22 19:01:24');



DROP TABLE IF EXISTS card_details;

CREATE TABLE `card_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `c_number` bigint(20) NOT NULL,
  `c_exp_month` int(11) NOT NULL,
  `c_exp_year` int(11) NOT NULL,
  `c_cvv` int(11) NOT NULL,
  `c_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO card_details VALUES('3','33','1','41111111111111111','12','24','123','Anuj Sharma','2020-12-22 13:02:24','2020-12-22 13:31:24');



DROP TABLE IF EXISTS chart_of_accounts;

CREATE TABLE `chart_of_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO chart_of_accounts VALUES('1','Test payment acceptance','income','1','2020-12-04 18:47:47','2020-12-04 18:47:47');



DROP TABLE IF EXISTS chat_group_users;

CREATE TABLE `chat_group_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS chat_groups;

CREATE TABLE `chat_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_by` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS chat_messages;

CREATE TABLE `chat_messages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from` bigint(20) NOT NULL,
  `to` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachment` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO chat_messages VALUES('1','4','3','hello','','1','1','2020-11-03 17:46:00','2020-11-03 17:46:07');
INSERT INTO chat_messages VALUES('2','3','4','hi','','1','1','2020-11-03 17:46:44','2020-11-03 17:46:52');
INSERT INTO chat_messages VALUES('3','3','4','test','','1','1','2020-11-03 17:54:21','2020-11-03 17:54:32');
INSERT INTO chat_messages VALUES('4','3','4','tested','','1','1','2020-11-03 18:13:50','2020-11-03 18:13:56');
INSERT INTO chat_messages VALUES('5','4','3','done','','1','1','2020-11-03 18:14:02','2020-11-03 18:14:11');
INSERT INTO chat_messages VALUES('6','3','4','deepak','','1','1','2020-11-03 18:14:24','2020-11-03 18:14:29');
INSERT INTO chat_messages VALUES('7','4','3','kapil','','1','1','2020-11-03 18:14:37','2020-11-03 18:14:45');
INSERT INTO chat_messages VALUES('8','4','3','kapil to deepak','','1','1','2020-11-03 18:16:26','2020-11-03 18:16:36');
INSERT INTO chat_messages VALUES('9','3','4','deepak to kapil','','1','1','2020-11-03 18:16:52','2020-11-03 18:18:14');
INSERT INTO chat_messages VALUES('10','3','4','test','','1','1','2020-11-03 18:18:05','2020-11-03 18:18:14');
INSERT INTO chat_messages VALUES('11','4','3','kaps to dk','','1','1','2020-11-03 18:38:39','2020-11-03 18:38:44');
INSERT INTO chat_messages VALUES('12','3','4','dk to kaps','','1','1','2020-11-03 18:39:06','2020-11-03 18:39:12');
INSERT INTO chat_messages VALUES('13','3','4','final dk to kaps','','1','1','2020-11-03 18:40:44','2020-11-03 18:40:50');
INSERT INTO chat_messages VALUES('14','4','3','final kaps to dk','','1','1','2020-11-03 18:41:16','2020-11-03 18:41:25');
INSERT INTO chat_messages VALUES('15','3','4','hi','','1','1','2020-11-05 15:37:03','2020-11-05 15:37:58');
INSERT INTO chat_messages VALUES('16','3','4','hello','','1','1','2020-11-05 15:37:10','2020-11-05 15:37:58');
INSERT INTO chat_messages VALUES('17','4','3','hello deepak','','1','1','2020-11-05 15:38:04','2020-11-05 15:38:19');
INSERT INTO chat_messages VALUES('18','4','3','hi dk','','1','1','2020-11-05 15:38:42','2020-11-05 15:38:50');
INSERT INTO chat_messages VALUES('19','3','4','hello kapil','','1','1','2020-11-05 15:39:09','2020-11-05 15:39:21');
INSERT INTO chat_messages VALUES('20','4','3','hello','','1','1','2020-11-05 15:39:44','2020-11-05 15:46:29');
INSERT INTO chat_messages VALUES('21','4','3','hello anuj','','1','1','2020-11-09 20:47:12','2020-11-09 21:19:47');
INSERT INTO chat_messages VALUES('22','4','3','hello deepak kapil this side','','1','1','2020-11-09 22:34:03','2020-11-09 22:34:15');
INSERT INTO chat_messages VALUES('23','3','4','hi kapil','','1','1','2020-11-09 22:34:23','2020-11-09 22:34:30');
INSERT INTO chat_messages VALUES('24','4','3','help me','','1','1','2020-11-09 22:34:51','2020-11-09 22:35:03');
INSERT INTO chat_messages VALUES('25','10','9','hello','','1','3','2020-11-11 21:34:51','2020-11-11 21:34:56');
INSERT INTO chat_messages VALUES('26','5','4','hi kapil','','1','1','2020-11-11 21:36:53','2020-11-11 21:36:57');
INSERT INTO chat_messages VALUES('27','4','5','hello vipra','','1','1','2020-11-11 21:37:03','2020-11-11 21:37:04');
INSERT INTO chat_messages VALUES('28','5','4','chat is working fine now','','1','1','2020-11-11 21:37:16','2020-11-11 21:37:18');
INSERT INTO chat_messages VALUES('29','4','5','not','','1','1','2020-11-11 21:37:34','2020-11-11 21:37:35');
INSERT INTO chat_messages VALUES('30','5','4','ok','','1','1','2020-11-11 21:37:38','2020-11-11 21:37:39');
INSERT INTO chat_messages VALUES('31','4','5','yes now its working fine','','1','1','2020-11-11 21:38:05','2020-11-11 21:38:08');
INSERT INTO chat_messages VALUES('32','4','5','ok','','1','1','2020-11-11 21:38:16','2020-11-11 21:38:18');
INSERT INTO chat_messages VALUES('33','3','4','hi kapil','','1','1','2020-11-17 18:49:11','2020-11-27 23:34:27');
INSERT INTO chat_messages VALUES('34','3','4','r u working on new web','','1','1','2020-11-17 18:49:17','2020-11-27 23:34:27');
INSERT INTO chat_messages VALUES('35','3','5','hi','','1','1','2020-11-27 23:34:23','2020-11-27 23:34:27');
INSERT INTO chat_messages VALUES('36','5','3','hello','','1','1','2020-11-27 23:34:34','2020-11-27 23:34:36');



DROP TABLE IF EXISTS cm_email_subscribers;

CREATE TABLE `cm_email_subscribers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cm_email_subscribers VALUES('1','test@gmail.com','127.0.0.1','2020-11-06 10:43:10','2020-11-06 10:43:10');



DROP TABLE IF EXISTS cm_faqs;

CREATE TABLE `cm_faqs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cm_faqs VALUES('1','a:1:{s:7:\"English\";s:4:\"Test\";}','a:1:{s:7:\"English\";s:11:\"<p>Test</p>\";}','2021-01-13 15:24:58','2021-01-13 15:24:58');



DROP TABLE IF EXISTS cm_features;

CREATE TABLE `cm_features` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `icon` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cm_features VALUES('1','<i class=\'lni lni-package\'></i>','Easy Accounting','Manage Account without any accounting knowledge','','');
INSERT INTO cm_features VALUES('2','<i class=\'lni lni-files\'></i>','Invoice','Create professional Invoice and accept online payments','','');
INSERT INTO cm_features VALUES('3','<i class=\'lni lni-user\'></i>','CRM','Contacts with Contact Group and Rich Customer Portal','','');
INSERT INTO cm_features VALUES('4','<i class=\'lni lni-phone-set\'></i>','Leads','Manage leads from different lead sources with kanban view','','');
INSERT INTO cm_features VALUES('5','<i class=\'lni lni-briefcase\'></i>','Projects','Manage different types of projects with milestone','','');
INSERT INTO cm_features VALUES('6','<i class=\'lni lni-alarm\'></i>','Tasks','Manage tasks with kanban view and assign task to staff','','');
INSERT INTO cm_features VALUES('7','<i class=\'lni lni-empty-file\'></i>','Quotation','Create Professional Quotation for getting customer attention','','');
INSERT INTO cm_features VALUES('8','<i class=\'lni lni-facebook-messenger\'></i>','Live Chat','Real time Chat with staffs, customers and private groups','','');
INSERT INTO cm_features VALUES('9','<i class=\'lni lni-credit-cards\'></i>','Online Payments','Accept Online Payments from Clients','','');



DROP TABLE IF EXISTS companies;

CREATE TABLE `companies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL,
  `package_id` int(11) DEFAULT NULL,
  `package_type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `membership_type` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valid_to` date NOT NULL,
  `last_email` date DEFAULT NULL,
  `staff_limit` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contacts_limit` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_limit` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_limit` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring_transaction` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_chat` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_manager` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inventory_module` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pos_module` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hrm_module` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payroll_module` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `project_management_module` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `online_payment` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO companies VALUES('1','DHS Dehradun','1','2','yearly','member','2022-01-13','','20','50','500','500','Yes','Yes','No','Yes','','','','Yes','No','2020-11-03 16:58:41','2021-01-13 15:15:22');
INSERT INTO companies VALUES('2','Vijay Textiles','1','3','monthly','trial','2021-11-10','','Unlimited','Unlimited','Unlimited','Unlimited','Yes','Yes','Yes','Yes','','','','Yes','Yes','2020-11-03 16:21:40','2020-11-11 16:24:33');
INSERT INTO companies VALUES('3','Comapny 11','1','3','monthly','member','2020-12-11','','30','Unlimited','300','300','Yes','Yes','Yes','Yes','','','','Yes','Yes','2020-11-10 22:38:52','2021-01-13 15:13:50');
INSERT INTO companies VALUES('4','Dem','1','2','monthly','member','2021-01-22','','10','30','300','300','Yes','Yes','No','Yes','','','','Yes','No','2020-12-22 21:07:53','2020-12-22 21:11:47');
INSERT INTO companies VALUES('5','Demo Company','1','3','monthly','member','2021-01-22','','30','Unlimited','300','300','Yes','Yes','Yes','Yes','','','','Yes','Yes','2020-12-22 21:41:41','2020-12-22 21:43:51');
INSERT INTO companies VALUES('6','Marilo Marketplace','1','3','monthly','member','2021-01-23','','27','Unlimited','300','300','Yes','Yes','Yes','Yes','','','','Yes','Yes','2020-12-23 22:29:24','2020-12-23 22:46:02');



DROP TABLE IF EXISTS company_email_template;

CREATE TABLE `company_email_template` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `related_to` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO company_email_template VALUES('1','Digital Hub CRM Invoice','Invoice for your project','<pre id=\"invoice-paremeter\" class=\"border border-info p-2  \">Dear {customer_name},<br /><br />Your payment invoice:<br /><br />Invoice Number: {invoice_no}<br />Invoice Date: {invoice_date}<br />Invoice Due Date: {due_date}<br />Amount: {grand_total}<br />Amount Due: {amount_due}<br /><br />Please <a href=\"https://crm.projectdigitalhubsolution.com/company_email_template/1/{invoice_link}\" target=\"_blank\" rel=\"noopener\">click here</a> to check your invoice</pre>','invoice','1','2020-11-06 12:02:45','2020-12-03 20:58:09');



DROP TABLE IF EXISTS company_settings;

CREATE TABLE `company_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO company_settings VALUES('1','company_logo','company_logo1605681778.jpg','1','2020-11-05 13:04:06','2020-11-18 17:42:58');
INSERT INTO company_settings VALUES('2','quotation_starting','2','1','2020-11-06 11:48:46','2021-01-13 15:08:26');
INSERT INTO company_settings VALUES('3','invoice_starting','1006','1','2020-11-06 11:58:27','2021-01-13 15:08:26');
INSERT INTO company_settings VALUES('4','company_logo','company_logo1604994069.png','2','2020-11-10 18:41:09','2020-11-10 18:41:09');
INSERT INTO company_settings VALUES('5','company_logo','company_logo1605008527.jpg','3','2020-11-10 22:42:07','2020-11-10 22:42:07');
INSERT INTO company_settings VALUES('6','paypal_active','no','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('7','paypal_currency','USD','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('8','paypal_email','','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('9','stripe_active','no','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('10','stripe_currency','USD','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('11','stripe_secret_key','','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('12','stripe_publishable_key','','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('13','razorpay_active','yes','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('14','razorpay_currency','INR','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('15','razorpay_key_id','rzp_test_AQgbp7wQbHxLpd','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('16','razorpay_secret_key','WA2sULsL9JgGFNd89vzGVvc1','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('17','paystack_active','no','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('18','paystack_public_key','','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('19','paystack_secret_key','','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('20','paystack_currency','GHS','1','2020-11-18 00:22:33','2020-12-04 18:48:16');
INSERT INTO company_settings VALUES('21','company_name','Digital hub solution Dehradun','1','2020-12-04 18:36:06','2021-01-13 15:08:14');
INSERT INTO company_settings VALUES('22','phone','9876543210','1','2020-12-04 18:36:06','2021-01-13 15:08:14');
INSERT INTO company_settings VALUES('23','vat_id','98765432','1','2020-12-04 18:36:06','2021-01-13 15:08:14');
INSERT INTO company_settings VALUES('24','reg_no','98752364','1','2020-12-04 18:36:06','2021-01-13 15:08:14');
INSERT INTO company_settings VALUES('25','email','deepakmehradhs@gmail.com','1','2020-12-04 18:36:06','2021-01-13 15:08:14');
INSERT INTO company_settings VALUES('26','address','NH-24, D-247','1','2020-12-04 18:36:06','2021-01-13 15:08:14');
INSERT INTO company_settings VALUES('27','base_currency','INR','1','2020-12-04 18:36:47','2020-12-04 18:36:47');
INSERT INTO company_settings VALUES('28','currency_position','left','1','2020-12-04 18:36:47','2020-12-04 18:36:47');
INSERT INTO company_settings VALUES('29','backend_direction','ltr','1','2020-12-04 18:36:47','2020-12-04 18:36:47');
INSERT INTO company_settings VALUES('30','timezone','Asia/Kolkata','1','2020-12-04 18:36:47','2020-12-04 18:36:47');
INSERT INTO company_settings VALUES('31','date_format','Y-m-d','1','2020-12-04 18:36:47','2020-12-04 18:36:47');
INSERT INTO company_settings VALUES('32','time_format','24','1','2020-12-04 18:36:47','2020-12-04 18:36:47');
INSERT INTO company_settings VALUES('33','invoice_prefix','DHS','1','2020-12-04 18:48:04','2021-01-13 15:08:26');
INSERT INTO company_settings VALUES('34','default_account','1','1','2020-12-04 18:48:04','2021-01-13 15:08:26');
INSERT INTO company_settings VALUES('35','default_chart_id','1','1','2020-12-04 18:48:04','2021-01-13 15:08:26');
INSERT INTO company_settings VALUES('36','quotation_prefix','','1','2020-12-04 18:48:04','2021-01-13 15:08:26');
INSERT INTO company_settings VALUES('37','invoice_footer','','1','2020-12-04 18:48:04','2021-01-13 15:08:26');
INSERT INTO company_settings VALUES('38','quotation_footer','','1','2020-12-04 18:48:04','2021-01-13 15:08:26');



DROP TABLE IF EXISTS contact_groups;

CREATE TABLE `contact_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO contact_groups VALUES('1','Web Development','Web Development','1','2020-11-05 11:55:05','2020-11-20 17:29:48');
INSERT INTO contact_groups VALUES('2','Web Designing','Web Designing','1','2021-01-13 14:59:07','2021-01-13 14:59:07');



DROP TABLE IF EXISTS contacts;

CREATE TABLE `contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `profile_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vat_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reg_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `facebook` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci,
  `contact_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `converted_by_user_id` int(11) DEFAULT NULL,
  `custom_fields` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO contacts VALUES('1','Individual','DHS','DHS','sagar@gmail.com','15','789456','09654871230','India','INR','Noida','VA - Virginia','201301','NH-24, D-247','','','','','avatar.png','1','','1','5','','2020-11-05 11:55:16','2020-11-05 11:55:16');
INSERT INTO contacts VALUES('2','Individual','DHS','Jhon Doe','kapil.quickmicrobooks@gmail.com','','','09654871230','India','USD','Noida','VA - Virginia','201301','3167  Desert Broom Court','','','','','avatar.png','1','7','1','4','','2020-11-06 11:55:18','2020-11-06 11:56:10');
INSERT INTO contacts VALUES('3','Individual','test 5 company','test 5 edit file','test5@gmail.com','','','+6898784','India','USD','Newark','NJ','7102','3167  Desert Broom Court','','','','','avatar.png','1','','2','3','','2020-11-12 22:03:49','2020-11-12 22:03:49');
INSERT INTO contacts VALUES('4','Company','Jhon\'s Company','Jhon Doe','jhondoedfgdfg@gmail.com','','','+6898784','United States of America','USD','Newark','NJ','7102','3167  Desert Broom Court','','','','','avatar.png','1','','1','4','','2020-11-20 16:49:09','2020-11-20 17:29:03');
INSERT INTO contacts VALUES('5','Individual','Jhon\'s Company','Jhon Doe','jhondoe@gmail.com','','','+6898784','United States of America','USD','Newark','NJ','7102','3167  Desert Broom Court','','','','','avatar.png','1','','1','3','','2020-11-24 21:14:40','2020-11-24 17:48:16');
INSERT INTO contacts VALUES('6','Individual','test 2 company','test2','test2@gmail.com','','','+6898784','United States of America','INR','Newark','NJ','7102','3167  Desert Broom Court','','','','','avatar.png','1','','1','3','','2020-11-24 17:54:20','2020-11-24 17:54:20');
INSERT INTO contacts VALUES('7','Individual','DHS','test now','nikhil@digitalhubsolution.com','','','+449876543210','United Kingdom','INR','Noida','Utah','201301','NH-24
D-247','','','','','avatar.png','1','','1','','','2021-01-13 14:58:26','2021-01-13 14:58:42');



DROP TABLE IF EXISTS currency_rates;

CREATE TABLE `currency_rates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` decimal(10,6) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO currency_rates VALUES('1','AED','4.101083','','');
INSERT INTO currency_rates VALUES('2','AFN','85.378309','','');
INSERT INTO currency_rates VALUES('3','ALL','123.510844','','');
INSERT INTO currency_rates VALUES('4','AMD','548.849773','','');
INSERT INTO currency_rates VALUES('5','ANG','2.008050','','');
INSERT INTO currency_rates VALUES('6','AOA','556.155120','','');
INSERT INTO currency_rates VALUES('7','ARS','70.205746','','');
INSERT INTO currency_rates VALUES('8','AUD','1.809050','','');
INSERT INTO currency_rates VALUES('9','AWG','2.009782','','');
INSERT INTO currency_rates VALUES('10','AZN','1.833159','','');
INSERT INTO currency_rates VALUES('11','BAM','1.966840','','');
INSERT INTO currency_rates VALUES('12','BBD','2.245460','','');
INSERT INTO currency_rates VALUES('13','BDT','95.162306','','');
INSERT INTO currency_rates VALUES('14','BGN','1.952383','','');
INSERT INTO currency_rates VALUES('15','BHD','0.421787','','');
INSERT INTO currency_rates VALUES('16','BIF','2117.865003','','');
INSERT INTO currency_rates VALUES('17','BMD','1.116545','','');
INSERT INTO currency_rates VALUES('18','BND','1.583270','','');
INSERT INTO currency_rates VALUES('19','BOB','7.718004','','');
INSERT INTO currency_rates VALUES('20','BRL','5.425949','','');
INSERT INTO currency_rates VALUES('21','BSD','1.121775','','');
INSERT INTO currency_rates VALUES('22','BTC','0.000244','','');
INSERT INTO currency_rates VALUES('23','BTN','82.818317','','');
INSERT INTO currency_rates VALUES('24','BWP','12.683055','','');
INSERT INTO currency_rates VALUES('25','BYN','2.621037','','');
INSERT INTO currency_rates VALUES('26','BYR','9999.999999','','');
INSERT INTO currency_rates VALUES('27','BZD','2.261248','','');
INSERT INTO currency_rates VALUES('28','CAD','1.552879','','');
INSERT INTO currency_rates VALUES('29','CDF','1898.127343','','');
INSERT INTO currency_rates VALUES('30','CHF','1.056023','','');
INSERT INTO currency_rates VALUES('31','CLF','0.033950','','');
INSERT INTO currency_rates VALUES('32','CLP','936.781769','','');
INSERT INTO currency_rates VALUES('33','CNY','7.827878','','');
INSERT INTO currency_rates VALUES('34','COP','4491.872864','','');
INSERT INTO currency_rates VALUES('35','CRC','635.520417','','');
INSERT INTO currency_rates VALUES('36','CUC','1.116545','','');
INSERT INTO currency_rates VALUES('37','CUP','29.588450','','');
INSERT INTO currency_rates VALUES('38','CVE','110.887227','','');
INSERT INTO currency_rates VALUES('39','CZK','26.906059','','');
INSERT INTO currency_rates VALUES('40','DJF','198.432393','','');
INSERT INTO currency_rates VALUES('41','DKK','7.472892','','');
INSERT INTO currency_rates VALUES('42','DOP','60.196240','','');
INSERT INTO currency_rates VALUES('43','DZD','134.499489','','');
INSERT INTO currency_rates VALUES('44','EGP','17.585483','','');
INSERT INTO currency_rates VALUES('45','ERN','16.748349','','');
INSERT INTO currency_rates VALUES('46','ETB','36.696587','','');
INSERT INTO currency_rates VALUES('47','EUR','1.000000','','');
INSERT INTO currency_rates VALUES('48','FJD','2.549240','','');
INSERT INTO currency_rates VALUES('49','FKP','0.908257','','');
INSERT INTO currency_rates VALUES('50','GBP','0.907964','','');
INSERT INTO currency_rates VALUES('51','GEL','3.115301','','');
INSERT INTO currency_rates VALUES('52','GGP','0.908257','','');
INSERT INTO currency_rates VALUES('53','GHS','6.220337','','');
INSERT INTO currency_rates VALUES('54','GIP','0.908257','','');
INSERT INTO currency_rates VALUES('55','GMD','56.605069','','');
INSERT INTO currency_rates VALUES('56','GNF','9999.999999','','');
INSERT INTO currency_rates VALUES('57','GTQ','8.576324','','');
INSERT INTO currency_rates VALUES('58','GYD','234.489495','','');
INSERT INTO currency_rates VALUES('59','HKD','8.674753','','');
INSERT INTO currency_rates VALUES('60','HNL','27.678062','','');
INSERT INTO currency_rates VALUES('61','HRK','7.590196','','');
INSERT INTO currency_rates VALUES('62','HTG','106.356510','','');
INSERT INTO currency_rates VALUES('63','HUF','341.150311','','');
INSERT INTO currency_rates VALUES('64','IDR','9999.999999','','');
INSERT INTO currency_rates VALUES('65','ILS','4.159226','','');
INSERT INTO currency_rates VALUES('66','IMP','0.908257','','');
INSERT INTO currency_rates VALUES('67','INR','82.763894','','');
INSERT INTO currency_rates VALUES('68','IQD','1339.198712','','');
INSERT INTO currency_rates VALUES('69','IRR','9999.999999','','');
INSERT INTO currency_rates VALUES('70','ISK','151.202539','','');
INSERT INTO currency_rates VALUES('71','JEP','0.908257','','');
INSERT INTO currency_rates VALUES('72','JMD','151.606351','','');
INSERT INTO currency_rates VALUES('73','JOD','0.791685','','');
INSERT INTO currency_rates VALUES('74','JPY','118.278988','','');
INSERT INTO currency_rates VALUES('75','KES','115.283224','','');
INSERT INTO currency_rates VALUES('76','KGS','81.395812','','');
INSERT INTO currency_rates VALUES('77','KHR','4603.144194','','');
INSERT INTO currency_rates VALUES('78','KMF','495.355724','','');
INSERT INTO currency_rates VALUES('79','KPW','1004.922902','','');
INSERT INTO currency_rates VALUES('80','KRW','1372.190164','','');
INSERT INTO currency_rates VALUES('81','KWD','0.344879','','');
INSERT INTO currency_rates VALUES('82','KYD','0.934921','','');
INSERT INTO currency_rates VALUES('83','KZT','456.318281','','');
INSERT INTO currency_rates VALUES('84','LAK','9978.233671','','');
INSERT INTO currency_rates VALUES('85','LBP','1696.373291','','');
INSERT INTO currency_rates VALUES('86','LKR','206.967335','','');
INSERT INTO currency_rates VALUES('87','LRD','221.076044','','');
INSERT INTO currency_rates VALUES('88','LSL','18.121543','','');
INSERT INTO currency_rates VALUES('89','LTL','3.296868','','');
INSERT INTO currency_rates VALUES('90','LVL','0.675387','','');
INSERT INTO currency_rates VALUES('91','LYD','1.557311','','');
INSERT INTO currency_rates VALUES('92','MAD','10.730569','','');
INSERT INTO currency_rates VALUES('93','MDL','19.734707','','');
INSERT INTO currency_rates VALUES('94','MGA','4165.265277','','');
INSERT INTO currency_rates VALUES('95','MKD','61.516342','','');
INSERT INTO currency_rates VALUES('96','MMK','1566.586511','','');
INSERT INTO currency_rates VALUES('97','MNT','3088.650418','','');
INSERT INTO currency_rates VALUES('98','MOP','8.975925','','');
INSERT INTO currency_rates VALUES('99','MRO','398.607011','','');
INSERT INTO currency_rates VALUES('100','MUR','43.205754','','');
INSERT INTO currency_rates VALUES('101','MVR','17.250725','','');
INSERT INTO currency_rates VALUES('102','MWK','825.239292','','');
INSERT INTO currency_rates VALUES('103','MXN','24.963329','','');
INSERT INTO currency_rates VALUES('104','MYR','4.810633','','');
INSERT INTO currency_rates VALUES('105','MZN','73.591410','','');
INSERT INTO currency_rates VALUES('106','NAD','18.121621','','');
INSERT INTO currency_rates VALUES('107','NGN','408.099790','','');
INSERT INTO currency_rates VALUES('108','NIO','37.844015','','');
INSERT INTO currency_rates VALUES('109','NOK','11.405599','','');
INSERT INTO currency_rates VALUES('110','NPR','132.508354','','');
INSERT INTO currency_rates VALUES('111','NZD','1.847363','','');
INSERT INTO currency_rates VALUES('112','OMR','0.429801','','');
INSERT INTO currency_rates VALUES('113','PAB','1.121880','','');
INSERT INTO currency_rates VALUES('114','PEN','3.958258','','');
INSERT INTO currency_rates VALUES('115','PGK','3.838505','','');
INSERT INTO currency_rates VALUES('116','PHP','57.698037','','');
INSERT INTO currency_rates VALUES('117','PKR','176.121721','','');
INSERT INTO currency_rates VALUES('118','PLN','4.386058','','');
INSERT INTO currency_rates VALUES('119','PYG','7386.917924','','');
INSERT INTO currency_rates VALUES('120','QAR','4.065302','','');
INSERT INTO currency_rates VALUES('121','RON','4.826717','','');
INSERT INTO currency_rates VALUES('122','RSD','117.627735','','');
INSERT INTO currency_rates VALUES('123','RUB','83.568390','','');
INSERT INTO currency_rates VALUES('124','RWF','1067.822267','','');
INSERT INTO currency_rates VALUES('125','SAR','4.190432','','');
INSERT INTO currency_rates VALUES('126','SBD','9.235251','','');
INSERT INTO currency_rates VALUES('127','SCR','14.529548','','');
INSERT INTO currency_rates VALUES('128','SDG','61.772847','','');
INSERT INTO currency_rates VALUES('129','SEK','10.785247','','');
INSERT INTO currency_rates VALUES('130','SGD','1.587844','','');
INSERT INTO currency_rates VALUES('131','SHP','0.908257','','');
INSERT INTO currency_rates VALUES('132','SLL','9999.999999','','');
INSERT INTO currency_rates VALUES('133','SOS','653.732410','','');
INSERT INTO currency_rates VALUES('134','SRD','8.327212','','');
INSERT INTO currency_rates VALUES('135','STD','9999.999999','','');
INSERT INTO currency_rates VALUES('136','SVC','9.816821','','');
INSERT INTO currency_rates VALUES('137','SYP','575.019506','','');
INSERT INTO currency_rates VALUES('138','SZL','18.038821','','');
INSERT INTO currency_rates VALUES('139','THB','35.884679','','');
INSERT INTO currency_rates VALUES('140','TJS','10.875343','','');
INSERT INTO currency_rates VALUES('141','TMT','3.907909','','');
INSERT INTO currency_rates VALUES('142','TND','3.186636','','');
INSERT INTO currency_rates VALUES('143','TOP','2.635661','','');
INSERT INTO currency_rates VALUES('144','TRY','7.131927','','');
INSERT INTO currency_rates VALUES('145','TTD','7.585158','','');
INSERT INTO currency_rates VALUES('146','TWD','33.739208','','');
INSERT INTO currency_rates VALUES('147','TZS','2582.397529','','');
INSERT INTO currency_rates VALUES('148','UAH','29.335146','','');
INSERT INTO currency_rates VALUES('149','UGX','4169.685347','','');
INSERT INTO currency_rates VALUES('150','USD','1.116545','','');
INSERT INTO currency_rates VALUES('151','UYU','48.718630','','');
INSERT INTO currency_rates VALUES('152','UZS','9999.999999','','');
INSERT INTO currency_rates VALUES('153','VEF','11.151499','','');
INSERT INTO currency_rates VALUES('154','VND','9999.999999','','');
INSERT INTO currency_rates VALUES('155','VUV','133.944917','','');
INSERT INTO currency_rates VALUES('156','WST','3.074259','','');
INSERT INTO currency_rates VALUES('157','XAF','659.652615','','');
INSERT INTO currency_rates VALUES('158','XAG','0.088073','','');
INSERT INTO currency_rates VALUES('159','XAU','0.000756','','');
INSERT INTO currency_rates VALUES('160','XCD','3.017519','','');
INSERT INTO currency_rates VALUES('161','XDR','0.809234','','');
INSERT INTO currency_rates VALUES('162','XOF','659.646672','','');
INSERT INTO currency_rates VALUES('163','XPF','119.931356','','');
INSERT INTO currency_rates VALUES('164','YER','279.475009','','');
INSERT INTO currency_rates VALUES('165','ZAR','18.603040','','');
INSERT INTO currency_rates VALUES('166','ZMK','9999.999999','','');
INSERT INTO currency_rates VALUES('167','ZMW','17.892580','','');
INSERT INTO currency_rates VALUES('168','ZWL','359.527584','','');



DROP TABLE IF EXISTS current_stocks;

CREATE TABLE `current_stocks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `quantity` decimal(8,2) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO current_stocks VALUES('1','1','-3.00','1','2020-11-06 11:48:20','2021-01-13 15:00:06');



DROP TABLE IF EXISTS email_templates;

CREATE TABLE `email_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO email_templates VALUES('1','registration','Registration Sucessfully','<div style=\"padding: 15px 30px;\">
						 <h2 style=\"color: #555555;\">Registration Successful</h2>
						 <p style=\"color: #555555;\">Hi {name},<br /><span style=\"color: #555555;\">Welcome to ElitKit and thank you for joining with us. You can now sign in to your account using your email and password.<br /><br />Regards<br />Tricky Code<br /></span></p>
						 </div>','','');
INSERT INTO email_templates VALUES('2','premium_membership','Premium Membership','<div style=\"padding: 15px 30px;\">
						<h2 style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\">ElitKit Premium Subscription</h2>
						<p style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\">Hi {name},<br>
						<span style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\"><strong>Congratulations</strong> your paymnet was made sucessfully. Your current membership is valid <strong>until</strong> <strong>{valid_to}</strong></span><span style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\"><strong>.</strong>&nbsp;</span></p>
						<p><br style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\" /><span style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\">Thank You</span><br style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\" /><span style=\"color: #555555; font-family: \"PT Sans\", sans-serif;\">Tricky Code</span></p>
						</div>','','');
INSERT INTO email_templates VALUES('3','alert_notification','Renewals','<div style=\"padding: 15px 30px;\">
<h2 style=\"color: #555555;\">Account Renew Notification</h2>
<p style=\"color: #555555;\">Hi {name},<br /><span style=\"color: #555555;\">Your package is due to <strong>expire on {valid_to}</strong> s</span><span style=\"color: #555555;\">o you will need to renew by then to keep your account active.</span></p>
<p><br style=\"color: #555555;\" /><span style=\"color: #555555;\">Regards</span><br style=\"color: #555555;\" /><span style=\"color: #555555;\">Tricky Code</span></p>
</div>','','2020-11-11 16:44:48');



DROP TABLE IF EXISTS file_manager;

CREATE TABLE `file_manager` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_dir` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_by` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS files;

CREATE TABLE `files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `related_to` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_id` bigint(20) DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO files VALUES('1','leads','15','1604640909footer_logo_w.png','3','1','2020-11-06 11:05:09','2020-11-06 11:05:09');
INSERT INTO files VALUES('2','leads','16','1604990090avatar_02.png','3','1','2020-11-10 17:34:50','2020-11-10 17:34:50');
INSERT INTO files VALUES('3','leads','22','1605009661pie-chart.jpg','9','3','2020-11-10 23:01:01','2020-11-10 23:01:01');



DROP TABLE IF EXISTS group_chat_message_status;

CREATE TABLE `group_chat_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` bigint(20) NOT NULL,
  `group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS group_chat_messages;

CREATE TABLE `group_chat_messages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachment` text COLLATE utf8mb4_unicode_ci,
  `sender_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS invoice_items;

CREATE TABLE `invoice_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `quantity` decimal(10,2) NOT NULL,
  `unit_cost` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `tax_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `sub_total` decimal(10,2) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO invoice_items VALUES('1','1','1','Test','1.00','50.00','0.00','inclusive','0','0.00','50.00','1','2020-11-06 11:58:27','2020-11-06 11:58:27');
INSERT INTO invoice_items VALUES('4','2','1','Test','1.00','50.00','0.00','inclusive','0','0.00','50.00','1','2020-12-03 17:25:45','2020-12-03 17:25:45');
INSERT INTO invoice_items VALUES('5','3','2','','1.00','125.00','0.00','inclusive','0','0.00','125.00','1','2020-12-03 18:46:50','2020-12-03 18:46:50');
INSERT INTO invoice_items VALUES('6','4','2','All tax are inclusive.','1.00','125.00','0.00','inclusive','0','0.00','125.00','1','2020-12-03 21:07:20','2020-12-03 21:07:20');
INSERT INTO invoice_items VALUES('7','5','1','Test','1.00','50.00','0.00','inclusive','0','0.00','50.00','1','2021-01-13 15:00:06','2021-01-13 15:00:06');



DROP TABLE IF EXISTS invoice_templates;

CREATE TABLE `invoice_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `editor` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_css` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS invoices;

CREATE TABLE `invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_date` date NOT NULL,
  `due_date` date NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `tax_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) DEFAULT NULL,
  `converted_total` decimal(10,2) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `template` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `related_to` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_id` bigint(20) DEFAULT NULL,
  `client_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO invoices VALUES('1','1001','2020-11-06','2020-11-09','50.00','0.00','0.00','50.00','Unpaid','modern','Please paid as soon as possible','projects','1','2','1','2020-11-06 11:58:27','2020-11-06 11:58:27');
INSERT INTO invoices VALUES('2','1002','2020-11-04','2020-10-05','50.00','0.00','0.00','50.00','Unpaid','classic','Please pay it.','contacts','2','2','1','2020-11-06 12:00:51','2020-12-03 17:25:45');
INSERT INTO invoices VALUES('3','1003','2020-12-03','2020-12-03','125.00','0.00','9265.62','125.00','Paid','classic','test','contacts','2','2','1','2020-12-03 18:46:50','2020-12-04 18:49:02');
INSERT INTO invoices VALUES('4','1004','2020-12-03','2020-12-03','125.00','0.00','9265.62','125.00','Paid','classic','test','contacts','4','4','1','2020-12-03 21:07:20','2020-12-04 17:26:22');
INSERT INTO invoices VALUES('5','1005','2021-01-13','2021-01-13','50.00','0.00','0.00','0.67','Unpaid','classic','Testing','contacts','4','4','1','2021-01-13 15:00:06','2021-01-13 15:00:06');



DROP TABLE IF EXISTS items;

CREATE TABLE `items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO items VALUES('1','Testing Product','product','1','2020-11-06 11:48:20','2020-11-06 11:48:20');
INSERT INTO items VALUES('2','Space for rent test','service','1','2020-12-03 16:59:31','2021-01-13 14:59:35');
INSERT INTO items VALUES('3','Test','service','1','2021-01-13 14:59:24','2021-01-13 14:59:24');



DROP TABLE IF EXISTS lead_sources;

CREATE TABLE `lead_sources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO lead_sources VALUES('1','Google','','1','2020-11-05 12:09:59','2020-11-05 12:09:59');
INSERT INTO lead_sources VALUES('2','google','','3','2020-11-10 22:49:03','2020-11-10 22:49:03');



DROP TABLE IF EXISTS lead_statuses;

CREATE TABLE `lead_statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO lead_statuses VALUES('3','Followp','#1f30c1','1','3','2020-11-10 22:45:40','2020-11-10 22:48:00');
INSERT INTO lead_statuses VALUES('4','Done','#1cd122','2','3','2020-11-10 22:46:44','2020-11-10 22:46:44');
INSERT INTO lead_statuses VALUES('5','Lost','#ed2d14','3','3','2020-11-10 22:47:14','2020-11-10 22:47:14');
INSERT INTO lead_statuses VALUES('6','In Progress','#eaed14','4','3','2020-11-10 22:47:31','2020-11-10 22:47:31');
INSERT INTO lead_statuses VALUES('7','Open','#28d1c9','5','3','2020-11-10 22:57:50','2020-11-10 22:57:50');
INSERT INTO lead_statuses VALUES('8','Follow Up','#1b56e8','2','1','2020-11-12 21:24:18','2020-11-12 21:41:25');
INSERT INTO lead_statuses VALUES('9','Not Answering','#1954e8','7','1','2020-11-12 21:24:49','2020-11-12 21:41:42');
INSERT INTO lead_statuses VALUES('10','Disconnected','#1c58ed','3','1','2020-11-12 21:25:05','2020-11-12 21:25:05');
INSERT INTO lead_statuses VALUES('11','Not Interested','#215df2','4','1','2020-11-12 21:25:27','2020-11-12 21:25:27');
INSERT INTO lead_statuses VALUES('12','Connected','#215df2','5','1','2020-11-12 21:26:09','2020-11-12 21:26:09');
INSERT INTO lead_statuses VALUES('13','Wrong Number','#215df2','6','1','2020-11-12 21:26:37','2020-11-12 21:26:37');
INSERT INTO lead_statuses VALUES('14','Won','#1f5cf5','9','1','2020-11-12 21:27:07','2020-11-12 21:41:42');
INSERT INTO lead_statuses VALUES('15','Loss','#2660f2','8','1','2020-11-12 21:27:22','2020-11-12 21:27:22');
INSERT INTO lead_statuses VALUES('16','Open','#0f42f2','1','1','2020-11-12 21:40:59','2020-11-12 21:41:25');



DROP TABLE IF EXISTS leads;

CREATE TABLE `leads` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `converted_lead` int(11) DEFAULT NULL,
  `lead_status_id` bigint(20) DEFAULT NULL,
  `lead_source_id` bigint(20) DEFAULT NULL,
  `assigned_user_id` bigint(20) DEFAULT NULL,
  `created_user_id` bigint(20) NOT NULL,
  `contact_date` date NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vat_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reg_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `custom_fields` longtext COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `hot` int(11) NOT NULL DEFAULT '0',
  `assign_count` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO leads VALUES('15','Jhon Doe','Jhon\'s Company','sagar@gmail.com','1','16','1','5','3','2020-11-06','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-05 17:17:30','2020-11-11 00:16:06');
INSERT INTO leads VALUES('16','Jhon Doe test','Jhon\'s Company','jhondoe@gmail.com','','16','1','4','4','1970-01-01','+6898784','www.google.com','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-09 21:16:56','2020-11-10 21:14:25');
INSERT INTO leads VALUES('17','Jhon Doe','Jhon\'s Company','jhondoe@gmail.com','','4','2','9','9','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','3','0','0','2020-11-10 23:00:12','2020-11-10 23:08:21');
INSERT INTO leads VALUES('18','test 1','test 1  company','test1@gmail.com','','7','2','9','9','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','3','0','0','2020-11-10 23:00:14','2020-11-10 23:00:14');
INSERT INTO leads VALUES('19','test2','test 2 company','test2@gmail.com','','5','2','9','9','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','3','0','0','2020-11-10 23:00:15','2020-11-10 23:08:15');
INSERT INTO leads VALUES('20','test 3','test 3 company','test3@gmail.com','','5','2','10','9','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','3','0','0','2020-11-10 23:00:16','2020-11-10 23:11:53');
INSERT INTO leads VALUES('21','test4','test 4 companu','test4@gmail.com','','7','2','9','9','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','3','0','0','2020-11-10 23:00:17','2020-11-10 23:00:17');
INSERT INTO leads VALUES('22','test 5','test 5 company','test5@gmail.com','','6','2','9','9','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','3','0','0','2020-11-10 23:00:18','2020-11-10 23:08:08');
INSERT INTO leads VALUES('23','Jhon Doe','Jhon\'s Company','jhondoe@gmail.com','','16','1','4','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-10 23:59:05','2020-11-10 23:59:05');
INSERT INTO leads VALUES('24','test 1','test 1  company','test1@gmail.com','','16','1','4','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-10 23:59:07','2020-11-10 23:59:07');
INSERT INTO leads VALUES('25','test2','test 2 company','test2@gmail.com','1','16','','5','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','1','0','2020-11-10 23:59:08','2020-12-03 21:56:26');
INSERT INTO leads VALUES('26','test 3','test 3 company','test3@gmail.com','','15','','4','3','1970-01-01','+6898784','','United States of America','INR','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-10 23:59:09','2020-12-03 21:59:23');
INSERT INTO leads VALUES('27','test4','test 4 companu','test4@gmail.com','','16','1','5','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-10 23:59:10','2020-11-12 20:24:38');
INSERT INTO leads VALUES('28','test 5 edit file','test 5 company','test5@gmail.com','1','14','1','4','3','1970-01-01','+6898784','','India','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-10 23:59:11','2020-11-12 22:03:49');
INSERT INTO leads VALUES('29','Jhon Doe','Jhon\'s Company','jhondoe@gmail.com','','','','5','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-17 16:21:29','2020-11-17 16:39:51');
INSERT INTO leads VALUES('30','Jhon Doe','Jhon\'s Company','jhondoe@gmail.com','','','','5','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-17 16:22:17','2021-01-13 14:53:09');
INSERT INTO leads VALUES('31','Deepak Lehri mehra','Jhon\'s Company test','jhondoe123@gmail.com','1','15','','5','3','1970-01-01','+6898784','https://www.google.com/','United States of America','INR','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','1','2020-11-17 16:39:37','2021-01-13 14:53:09');
INSERT INTO leads VALUES('32','Jhon Doe','Jhon\'s Company','jhondoe@gmail.com','1','','','4','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-11-23 21:03:31','2020-11-24 17:48:16');
INSERT INTO leads VALUES('33','Jhon Doe','Jhon\'s Company','jhondoe1234@gmail.com','','','','4','3','1970-01-01','+6898784','','United States of America','USD','','','Newark','NJ','7102','3167  Desert Broom Court','','1','0','0','2020-12-08 22:29:24','2020-12-08 22:29:24');



DROP TABLE IF EXISTS migrations;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES('1','2014_10_12_000000_create_users_table','1');
INSERT INTO migrations VALUES('2','2014_10_12_100000_create_password_resets_table','1');
INSERT INTO migrations VALUES('3','2018_06_01_080940_create_settings_table','1');
INSERT INTO migrations VALUES('4','2018_08_29_084110_create_permissions_table','1');
INSERT INTO migrations VALUES('5','2018_10_28_101819_create_contact_groups_table','1');
INSERT INTO migrations VALUES('6','2018_10_28_104344_create_contacts_table','1');
INSERT INTO migrations VALUES('7','2018_10_28_151911_create_taxs_table','1');
INSERT INTO migrations VALUES('8','2018_10_29_095644_create_items_table','1');
INSERT INTO migrations VALUES('9','2018_10_29_100449_create_products_table','1');
INSERT INTO migrations VALUES('10','2018_10_29_101301_create_services_table','1');
INSERT INTO migrations VALUES('11','2018_10_29_101756_create_suppliers_table','1');
INSERT INTO migrations VALUES('12','2018_11_12_152015_create_email_templates_table','1');
INSERT INTO migrations VALUES('13','2018_11_13_063551_create_accounts_table','1');
INSERT INTO migrations VALUES('14','2018_11_13_082226_create_chart_of_accounts_table','1');
INSERT INTO migrations VALUES('15','2018_11_13_082512_create_payment_methods_table','1');
INSERT INTO migrations VALUES('16','2018_11_13_141249_create_transactions_table','1');
INSERT INTO migrations VALUES('17','2018_11_14_134254_create_repeating_transactions_table','1');
INSERT INTO migrations VALUES('18','2018_11_17_142037_create_payment_histories_table','1');
INSERT INTO migrations VALUES('19','2019_03_07_084028_create_purchase_orders_table','1');
INSERT INTO migrations VALUES('20','2019_03_07_085537_create_purchase_order_items_table','1');
INSERT INTO migrations VALUES('21','2019_03_19_070903_create_current_stocks_table','1');
INSERT INTO migrations VALUES('22','2019_03_19_123527_create_company_settings_table','1');
INSERT INTO migrations VALUES('23','2019_03_19_133922_create_product_units_table','1');
INSERT INTO migrations VALUES('24','2019_03_20_113605_create_invoices_table','1');
INSERT INTO migrations VALUES('25','2019_03_20_113618_create_invoice_items_table','1');
INSERT INTO migrations VALUES('26','2019_05_11_080519_create_purchase_return_table','1');
INSERT INTO migrations VALUES('27','2019_05_11_080546_create_purchase_return_items_table','1');
INSERT INTO migrations VALUES('28','2019_05_27_153656_create_quotations_table','1');
INSERT INTO migrations VALUES('29','2019_05_27_153712_create_quotation_items_table','1');
INSERT INTO migrations VALUES('30','2019_06_22_062221_create_sales_return_table','1');
INSERT INTO migrations VALUES('31','2019_06_22_062233_create_sales_return_items_table','1');
INSERT INTO migrations VALUES('32','2019_06_23_055645_create_company_email_template_table','1');
INSERT INTO migrations VALUES('33','2019_10_31_172912_create_social_google_accounts_table','1');
INSERT INTO migrations VALUES('34','2019_11_04_133151_create_chat_messages_table','1');
INSERT INTO migrations VALUES('35','2019_11_07_105822_create_chat_groups_table','1');
INSERT INTO migrations VALUES('36','2019_11_08_063856_create_chat_group_users','1');
INSERT INTO migrations VALUES('37','2019_11_08_143329_create_group_chat_messages_table','1');
INSERT INTO migrations VALUES('38','2019_11_08_143607_create_group_chat_message_status_table','1');
INSERT INTO migrations VALUES('39','2019_11_11_170656_create_file_manager_table','1');
INSERT INTO migrations VALUES('40','2020_03_15_154649_create_currency_rates_table','1');
INSERT INTO migrations VALUES('41','2020_03_21_052934_create_companies_table','1');
INSERT INTO migrations VALUES('42','2020_03_21_070022_create_packages_table','1');
INSERT INTO migrations VALUES('43','2020_04_02_155956_create_cm_features_table','1');
INSERT INTO migrations VALUES('44','2020_04_02_160209_create_cm_faqs_table','1');
INSERT INTO migrations VALUES('45','2020_04_02_160249_create_cm_email_subscribers_table','1');
INSERT INTO migrations VALUES('46','2020_05_18_104400_create_invoice_templates_table','1');
INSERT INTO migrations VALUES('47','2020_05_24_152947_create_lead_statuses_table','1');
INSERT INTO migrations VALUES('48','2020_05_24_153000_create_lead_sources_table','1');
INSERT INTO migrations VALUES('49','2020_05_24_153224_create_leads_table','1');
INSERT INTO migrations VALUES('50','2020_06_03_112519_create_files_table','1');
INSERT INTO migrations VALUES('51','2020_06_03_112538_create_notes_table','1');
INSERT INTO migrations VALUES('52','2020_06_03_112553_create_activity_logs_table','1');
INSERT INTO migrations VALUES('53','2020_06_22_083001_create_projects_table','1');
INSERT INTO migrations VALUES('54','2020_06_22_095143_create_project_members_table','1');
INSERT INTO migrations VALUES('55','2020_06_23_083455_create_project_milestones_table','1');
INSERT INTO migrations VALUES('56','2020_06_23_112159_create_task_statuses_table','1');
INSERT INTO migrations VALUES('57','2020_06_23_144512_create_tasks_table','1');
INSERT INTO migrations VALUES('58','2020_06_25_065937_create_timesheets_table','1');
INSERT INTO migrations VALUES('59','2020_06_27_152210_create_notifications_table','1');
INSERT INTO migrations VALUES('60','2020_08_21_063443_add_related_to_company_email_template','1');
INSERT INTO migrations VALUES('61','2020_10_19_082621_create_staff_roles_table','1');
INSERT INTO migrations VALUES('62','2020_10_20_080849_add_description_to_invoice_items','1');



DROP TABLE IF EXISTS notes;

CREATE TABLE `notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `related_to` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_id` bigint(20) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO notes VALUES('1','leads','15','testing a lead note','3','1','2020-11-06 10:59:41','2020-11-06 10:59:41');
INSERT INTO notes VALUES('2','leads','16','test','3','1','2020-11-10 16:09:18','2020-11-10 16:09:18');
INSERT INTO notes VALUES('3','leads','31','test','3','1','2020-11-20 21:33:01','2020-11-20 21:33:01');
INSERT INTO notes VALUES('4','leads','26','test','3','1','2020-11-20 21:33:29','2020-11-20 21:33:29');
INSERT INTO notes VALUES('5','leads','26','tested','3','1','2020-11-20 21:34:47','2020-11-20 21:34:47');
INSERT INTO notes VALUES('6','leads','32','test','4','1','2020-12-03 22:08:43','2020-12-03 22:08:43');
INSERT INTO notes VALUES('7','leads','24','test','4','1','2020-12-03 22:09:23','2020-12-03 22:09:23');



DROP TABLE IF EXISTS notifications;

CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO notifications VALUES('17c20cb4-d9ed-471e-bdea-9eb3c6449736','App\\Notifications\\InvoiceUpdated','App\\User','7','{\"id\":2,\"url\":\"client\\/view_invoice\\/c81e728d9d4c2f636f067f89cc14862c\",\"client_url\":\"client\\/view_invoice\\/c81e728d9d4c2f636f067f89cc14862c\",\"title\":\"Updated Invoice\",\"content\":\"Invoice# 1002\"}','3','2020-11-06 12:48:22','2020-11-06 12:47:56','2020-11-06 12:48:22');
INSERT INTO notifications VALUES('204be7d4-f177-4048-87b7-21724bb4d9c0','App\\Notifications\\ProjectUpdated','App\\User','4','{\"id\":1,\"url\":\"projects\\/1\",\"client_url\":\"client\\/projects\\/1\",\"title\":\"Updated Project\",\"content\":\"Project 1# Test Website\"}','3','2020-11-09 19:01:41','2020-11-06 11:56:54','2020-11-09 19:01:41');
INSERT INTO notifications VALUES('81752d5b-6c6f-465a-b3df-db9e99f92f4f','App\\Notifications\\ProjectUpdated','App\\User','7','{\"id\":1,\"url\":\"projects\\/1\",\"client_url\":\"client\\/projects\\/1\",\"title\":\"Updated Project\",\"content\":\"Project 1# Test Website\"}','3','','2020-11-06 11:56:54','2020-11-06 11:56:54');
INSERT INTO notifications VALUES('886ff523-7f00-4144-b2b3-8ba87e000df2','App\\Notifications\\ProjectCreated','App\\User','4','{\"id\":1,\"url\":\"projects\\/1\",\"client_url\":\"client\\/projects\\/1\",\"title\":\"Created New Project\",\"content\":\"Project 1# DHS Website\"}','3','2020-11-05 12:37:20','2020-11-05 11:56:13','2020-11-05 12:37:20');
INSERT INTO notifications VALUES('cafd03b2-0703-4b5c-9cae-9d4961e7e89b','App\\Notifications\\InvoiceCreated','App\\User','7','{\"id\":2,\"url\":\"client\\/view_invoice\\/c81e728d9d4c2f636f067f89cc14862c\",\"client_url\":\"client\\/view_invoice\\/c81e728d9d4c2f636f067f89cc14862c\",\"title\":\"Created New Invoice\",\"content\":\"Invoice# 1002\"}','3','','2020-11-06 12:00:51','2020-11-06 12:00:51');
INSERT INTO notifications VALUES('d285496f-9477-44e9-bf40-8197a2b7d0dd','App\\Notifications\\InvoiceUpdated','App\\User','7','{\"id\":2,\"url\":\"client\\/view_invoice\\/c81e728d9d4c2f636f067f89cc14862c\",\"client_url\":\"client\\/view_invoice\\/c81e728d9d4c2f636f067f89cc14862c\",\"title\":\"Updated Invoice\",\"content\":\"Invoice# 1002\"}','3','','2020-12-03 17:25:45','2020-12-03 17:25:45');
INSERT INTO notifications VALUES('e32cd04e-c361-4de5-81e7-c26775c2ef45','App\\Notifications\\InvoiceCreated','App\\User','7','{\"id\":1,\"url\":\"client\\/view_invoice\\/c4ca4238a0b923820dcc509a6f75849b\",\"client_url\":\"client\\/view_invoice\\/c4ca4238a0b923820dcc509a6f75849b\",\"title\":\"Created New Invoice\",\"content\":\"Invoice# 1001\"}','3','','2020-11-06 11:58:27','2020-11-06 11:58:27');



DROP TABLE IF EXISTS packages;

CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `package_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost_per_month` decimal(10,2) NOT NULL,
  `cost_per_year` decimal(10,2) NOT NULL,
  `staff_limit` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contacts_limit` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_limit` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quotation_limit` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recurring_transaction` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `live_chat` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_manager` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `inventory_module` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pos_module` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hrm_module` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payroll_module` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `project_management_module` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `online_payment` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint(4) NOT NULL DEFAULT '0',
  `others` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO packages VALUES('1','Basic','10.00','99.00','a:2:{s:7:\"monthly\";s:1:\"3\";s:6:\"yearly\";s:2:\"10\";}','a:2:{s:7:\"monthly\";s:2:\"10\";s:6:\"yearly\";s:2:\"30\";}','a:2:{s:7:\"monthly\";s:2:\"20\";s:6:\"yearly\";s:3:\"300\";}','a:2:{s:7:\"monthly\";s:2:\"20\";s:6:\"yearly\";s:3:\"300\";}','a:2:{s:7:\"monthly\";s:2:\"No\";s:6:\"yearly\";s:2:\"No\";}','a:2:{s:7:\"monthly\";s:2:\"No\";s:6:\"yearly\";s:2:\"No\";}','a:2:{s:7:\"monthly\";s:2:\"No\";s:6:\"yearly\";s:2:\"No\";}','a:2:{s:7:\"monthly\";s:2:\"No\";s:6:\"yearly\";s:2:\"No\";}','','','','a:2:{s:7:\"monthly\";s:2:\"No\";s:6:\"yearly\";s:2:\"No\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:2:\"No\";}','0','','','2021-01-13 15:15:04');
INSERT INTO packages VALUES('2','Standard','25.00','199.00','a:2:{s:7:\"monthly\";s:2:\"10\";s:6:\"yearly\";s:2:\"20\";}','a:2:{s:7:\"monthly\";s:2:\"30\";s:6:\"yearly\";s:2:\"50\";}','a:2:{s:7:\"monthly\";s:3:\"300\";s:6:\"yearly\";s:3:\"500\";}','a:2:{s:7:\"monthly\";s:3:\"300\";s:6:\"yearly\";s:3:\"500\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','a:2:{s:7:\"monthly\";s:2:\"No\";s:6:\"yearly\";s:2:\"No\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','','','','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','a:2:{s:7:\"monthly\";s:2:\"No\";s:6:\"yearly\";s:2:\"No\";}','1','','','');
INSERT INTO packages VALUES('3','Business Plus','40.00','399.00','a:2:{s:7:\"monthly\";s:2:\"30\";s:6:\"yearly\";s:9:\"Unlimited\";}','a:2:{s:7:\"monthly\";s:9:\"Unlimited\";s:6:\"yearly\";s:9:\"Unlimited\";}','a:2:{s:7:\"monthly\";s:3:\"300\";s:6:\"yearly\";s:9:\"Unlimited\";}','a:2:{s:7:\"monthly\";s:3:\"300\";s:6:\"yearly\";s:9:\"Unlimited\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','','','','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','a:2:{s:7:\"monthly\";s:3:\"Yes\";s:6:\"yearly\";s:3:\"Yes\";}','0','','','');



DROP TABLE IF EXISTS password_resets;

CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS payment_histories;

CREATE TABLE `payment_histories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `package_id` int(11) NOT NULL,
  `package_type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_histories VALUES('13','1','Buy Business Plus Package','Rezorpay','USD','40.00','3','monthly','paid','2020-11-11 15:56:53','2020-11-11 15:57:46');
INSERT INTO payment_histories VALUES('14','3','Buy Business Plus Package','Rezorpay','USD','40.00','3','monthly','paid','2020-11-11 17:03:11','2020-11-11 17:03:46');
INSERT INTO payment_histories VALUES('20','1','Buy Standard Package','Rezorpay','USD','199.00','2','yearly','paid','2020-12-21 22:39:03','2020-12-21 22:39:18');
INSERT INTO payment_histories VALUES('21','4','Buy Standard Package','Rezorpay','USD','25.00','2','monthly','paid','2020-12-22 21:11:29','2020-12-22 21:11:47');
INSERT INTO payment_histories VALUES('23','5','Buy Business Plus Package','Rezorpay','USD','40.00','3','monthly','paid','2020-12-22 21:43:31','2020-12-22 21:43:51');
INSERT INTO payment_histories VALUES('24','6','Buy Business Plus Package','Rezorpay','USD','40.00','3','monthly','paid','2020-12-23 22:42:38','2020-12-23 22:42:50');
INSERT INTO payment_histories VALUES('25','1','Buy Standard Package','Offline','USD','199.00','2','yearly','paid','2021-01-13 15:15:22','2021-01-13 15:15:22');



DROP TABLE IF EXISTS payment_methods;

CREATE TABLE `payment_methods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_methods VALUES('1','Stripe','1','2020-11-06 12:45:03','2020-11-06 12:45:03');
INSERT INTO payment_methods VALUES('2','Paypal','1','2020-11-06 12:45:20','2020-11-06 12:45:20');
INSERT INTO payment_methods VALUES('3','Razorpay','1','2020-12-04 18:49:02','2020-12-04 18:49:02');
INSERT INTO payment_methods VALUES('4','Manual','1','2021-01-13 15:04:46','2021-01-13 15:04:46');



DROP TABLE IF EXISTS permissions;

CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20) NOT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('16','2','leads.create_note','2020-11-10 23:07:29','2020-11-10 23:07:29');
INSERT INTO permissions VALUES('17','2','leads.index','2020-11-10 23:07:29','2020-11-10 23:07:29');
INSERT INTO permissions VALUES('18','2','leads.create','2020-11-10 23:07:29','2020-11-10 23:07:29');
INSERT INTO permissions VALUES('19','2','leads.show','2020-11-10 23:07:29','2020-11-10 23:07:29');
INSERT INTO permissions VALUES('20','2','leads.edit','2020-11-10 23:07:29','2020-11-10 23:07:29');
INSERT INTO permissions VALUES('21','3','leads.import','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('22','3','leads.convert_to_customer','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('23','3','leads.create_note','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('24','3','leads.download_file','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('25','3','leads.upload_file','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('26','3','leads.index','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('27','3','leads.not-assigned-leads','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('28','3','leads.create','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('29','3','leads.edit','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('30','3','lead_statuses.create','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('31','3','lead_statuses.edit','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('32','3','lead_statuses.destroy','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('33','3','lead_sources.create','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('34','3','lead_sources.edit','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('35','3','lead_sources.destroy','2020-11-27 22:19:00','2020-11-27 22:19:00');
INSERT INTO permissions VALUES('42','5','leads.convert_to_customer','2020-12-23 22:43:32','2020-12-23 22:43:32');
INSERT INTO permissions VALUES('43','5','leads.create_note','2020-12-23 22:43:32','2020-12-23 22:43:32');
INSERT INTO permissions VALUES('44','5','leads.download_file','2020-12-23 22:43:32','2020-12-23 22:43:32');
INSERT INTO permissions VALUES('45','5','leads.upload_file','2020-12-23 22:43:32','2020-12-23 22:43:32');
INSERT INTO permissions VALUES('46','5','leads.index','2020-12-23 22:43:32','2020-12-23 22:43:32');
INSERT INTO permissions VALUES('47','5','leads.show','2020-12-23 22:43:32','2020-12-23 22:43:32');
INSERT INTO permissions VALUES('48','6','leads.import','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('49','6','leads.convert_to_customer','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('50','6','leads.create_note','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('51','6','leads.download_file','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('52','6','leads.upload_file','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('53','6','leads.index','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('54','6','leads.not-assigned-leads','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('55','6','leads.create','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('56','6','leads.show','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('57','6','leads.edit','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('58','6','lead_statuses.create','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('59','6','lead_statuses.edit','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('60','6','lead_sources.create','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('61','6','lead_sources.edit','2020-12-23 22:44:04','2020-12-23 22:44:04');
INSERT INTO permissions VALUES('62','1','leads.convert_to_customer','2021-01-13 15:11:22','2021-01-13 15:11:22');
INSERT INTO permissions VALUES('63','1','leads.create_note','2021-01-13 15:11:22','2021-01-13 15:11:22');
INSERT INTO permissions VALUES('64','1','leads.download_file','2021-01-13 15:11:22','2021-01-13 15:11:22');
INSERT INTO permissions VALUES('65','1','leads.upload_file','2021-01-13 15:11:22','2021-01-13 15:11:22');
INSERT INTO permissions VALUES('66','1','leads.index','2021-01-13 15:11:22','2021-01-13 15:11:22');
INSERT INTO permissions VALUES('67','1','leads.show','2021-01-13 15:11:22','2021-01-13 15:11:22');
INSERT INTO permissions VALUES('68','1','leads.edit','2021-01-13 15:11:22','2021-01-13 15:11:22');



DROP TABLE IF EXISTS previous_data;

CREATE TABLE `previous_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `month` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leads` int(11) DEFAULT NULL,
  `amount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO previous_data VALUES('185','1','2020','Jan','15','150','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('186','1','2020','Feb','30','200','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('187','1','2020','Mar','45','250','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('188','1','2020','Apr','60','300','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('189','1','2020','May','75','400','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('190','1','2020','Jun','90','450','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('191','1','2020','Jul','105','500','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('192','1','2020','Aug','120','600','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('193','1','2020','Sep','135','750','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('194','1','2020','Oct','150','900','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('195','1','2020','Nov','165','1000','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('196','1','2020','Dec','180','1200','2020-11-18 16:33:34','2020-11-18 16:33:34');
INSERT INTO previous_data VALUES('231','1','2019','Jan','15','150','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('232','1','2019','Feb','30','200','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('233','1','2019','Mar','45','250','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('234','1','2019','Apr','60','300','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('235','1','2019','May','75','400','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('236','1','2019','Jun','90','450','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('237','1','2019','Jul','105','500','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('238','1','2019','Aug','120','600','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('239','1','2019','Sep','135','750','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('240','1','2019','Oct','150','900','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('241','1','2019','Nov','165','1000','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('242','1','2019','Dec','180','1200','2020-11-23 15:09:47','2020-11-23 15:09:47');
INSERT INTO previous_data VALUES('243','1','2018','Jan','15','150','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('244','1','2018','Feb','30','200','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('245','1','2018','Mar','45','250','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('246','1','2018','Apr','60','300','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('247','1','2018','May','75','400','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('248','1','2018','Jun','90','450','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('249','1','2018','Jul','105','500','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('250','1','2018','Aug','120','600','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('251','1','2018','Sep','135','750','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('252','1','2018','Oct','150','900','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('253','1','2018','Nov','165','1000','2020-11-23 15:10:08','2020-11-23 15:10:08');
INSERT INTO previous_data VALUES('254','1','2018','Dec','180','1200','2020-11-23 15:10:08','2020-11-23 15:10:08');



DROP TABLE IF EXISTS product_units;

CREATE TABLE `product_units` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `unit_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_units VALUES('1','Kg','1','2020-11-06 11:48:10','2020-11-06 11:48:10');



DROP TABLE IF EXISTS products;

CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint(20) NOT NULL,
  `supplier_id` bigint(20) DEFAULT NULL,
  `product_cost` decimal(10,2) NOT NULL,
  `product_price` decimal(10,2) NOT NULL,
  `product_unit` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_method` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO products VALUES('1','1','1','50.00','50.00','Kg','inclusive','','Test','2020-11-06 11:48:20','2020-11-06 11:48:20');



DROP TABLE IF EXISTS project_members;

CREATE TABLE `project_members` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO project_members VALUES('1','1','4','2020-11-05 11:56:12','2020-11-05 11:56:12');



DROP TABLE IF EXISTS project_milestones;

CREATE TABLE `project_milestones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `due_date` date NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` decimal(10,2) DEFAULT NULL,
  `project_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS projects;

CREATE TABLE `projects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` bigint(20) NOT NULL,
  `progress` int(11) DEFAULT NULL,
  `billing_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fixed_rate` decimal(10,2) DEFAULT NULL,
  `hourly_rate` decimal(10,2) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `custom_fields` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO projects VALUES('1','Test Website','2','0','fixed','in_progress','1500.00','','2020-11-05','2020-11-30','<p>Test</p>','','3','1','2020-11-05 11:56:12','2020-11-06 11:56:53');



DROP TABLE IF EXISTS purchase_order_items;

CREATE TABLE `purchase_order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `quantity` decimal(8,2) NOT NULL,
  `unit_cost` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `tax_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `sub_total` decimal(10,2) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO purchase_order_items VALUES('2','1','1','Test','1.00','50.00','0.00','inclusive','0','0.00','50.00','1','2020-12-22 22:27:07','2020-12-22 22:27:07');



DROP TABLE IF EXISTS purchase_orders;

CREATE TABLE `purchase_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_date` date NOT NULL,
  `supplier_id` bigint(20) NOT NULL,
  `order_status` tinyint(4) NOT NULL,
  `order_tax_id` bigint(20) DEFAULT NULL,
  `order_tax` decimal(10,2) DEFAULT NULL,
  `order_discount` decimal(10,2) NOT NULL,
  `shipping_cost` decimal(10,2) NOT NULL,
  `product_total` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `payment_status` tinyint(4) NOT NULL,
  `attachemnt` text COLLATE utf8mb4_unicode_ci,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO purchase_orders VALUES('1','2020-12-22','2','1','','0.00','0.00','0.00','50.00','50.00','0.00','0','','','1','2020-12-22 22:26:26','2020-12-22 22:27:07');



DROP TABLE IF EXISTS purchase_return;

CREATE TABLE `purchase_return` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `return_date` date NOT NULL,
  `supplier_id` bigint(20) DEFAULT NULL,
  `account_id` bigint(20) NOT NULL,
  `chart_id` bigint(20) NOT NULL,
  `payment_method_id` bigint(20) NOT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `product_total` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `attachemnt` text COLLATE utf8mb4_unicode_ci,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS purchase_return_items;

CREATE TABLE `purchase_return_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_return_id` int(11) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `quantity` decimal(10,2) NOT NULL,
  `unit_cost` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `tax_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `sub_total` decimal(10,2) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS quotation_items;

CREATE TABLE `quotation_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `quantity` decimal(10,2) NOT NULL,
  `unit_cost` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `tax_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `sub_total` decimal(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO quotation_items VALUES('1','1','1','Test','1.00','50.00','0.00','inclusive','0','0.00','50.00','2020-11-06 11:48:45','2020-11-06 11:48:45');



DROP TABLE IF EXISTS quotations;

CREATE TABLE `quotations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `quotation_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quotation_date` date NOT NULL,
  `template` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `converted_total` decimal(10,2) DEFAULT NULL,
  `tax_total` decimal(10,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `related_to` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_id` bigint(20) DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO quotations VALUES('1','1001','2020-11-06','classic','50.00','50.00','0.00','','leads','15','1','2020-11-06 11:48:45','2020-11-06 11:48:45');



DROP TABLE IF EXISTS reminders;

CREATE TABLE `reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` int(11) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO reminders VALUES('1','32','3','2020-11-25 17:23:08','Testing reminder','0','2020-11-25 18:20:18','2021-01-13 14:48:15');
INSERT INTO reminders VALUES('2','31','3','2021-01-13 15:20:13','Testing crm','1','2020-11-24 11:45:31','2021-01-13 14:57:46');
INSERT INTO reminders VALUES('3','31','4','2021-01-13 15:20:13','Testing crm','1','2020-12-22 11:22:06','2021-01-13 14:57:46');
INSERT INTO reminders VALUES('4','25','3','2020-12-23 13:29:00','cpanel','0','2020-12-22 15:02:14','2020-12-23 13:35:21');
INSERT INTO reminders VALUES('5','33','4','2020-12-23 15:49:50','cpanel','0','2020-12-23 15:33:40','2021-01-13 14:55:31');
INSERT INTO reminders VALUES('6','33','3','2021-02-03 15:00:00','Testing crm','0','2021-01-13 14:55:14','2021-01-13 14:55:31');



DROP TABLE IF EXISTS repeating_transactions;

CREATE TABLE `repeating_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trans_date` date NOT NULL,
  `account_id` bigint(20) NOT NULL,
  `chart_id` bigint(20) NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dr_cr` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `base_amount` decimal(10,2) DEFAULT NULL,
  `payer_payee_id` bigint(20) DEFAULT NULL,
  `payment_method_id` bigint(20) NOT NULL,
  `reference` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `status` tinyint(4) DEFAULT '0',
  `trans_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS sales_return;

CREATE TABLE `sales_return` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `return_date` date NOT NULL,
  `customer_id` bigint(20) NOT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `product_total` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `converted_total` decimal(10,2) DEFAULT NULL,
  `attachemnt` text COLLATE utf8mb4_unicode_ci,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS sales_return_items;

CREATE TABLE `sales_return_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_return_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `quantity` decimal(8,2) NOT NULL,
  `unit_cost` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `tax_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `sub_total` decimal(10,2) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS services;

CREATE TABLE `services` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint(20) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `tax_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` bigint(20) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO services VALUES('1','2','125.00','','','All tax are inclusive.','2020-12-03 16:59:31','2021-01-13 14:59:35');
INSERT INTO services VALUES('2','3','150.00','','','','2021-01-13 14:59:24','2021-01-13 14:59:24');



DROP TABLE IF EXISTS settings;

CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO settings VALUES('1','mail_type','smtp','','2021-01-13 15:02:37');
INSERT INTO settings VALUES('2','backend_direction','ltr','','');
INSERT INTO settings VALUES('3','membership_system','enabled','','2020-11-11 16:26:46');
INSERT INTO settings VALUES('4','trial_period','5','','2020-11-11 16:26:46');
INSERT INTO settings VALUES('5','allow_singup','yes','','2020-11-11 16:26:46');
INSERT INTO settings VALUES('6','email_verification','disabled','','2020-11-11 16:26:46');
INSERT INTO settings VALUES('7','hero_title','a:1:{s:7:\"English\";s:28:\"Start Your Business With CRM\";}','','2021-01-13 15:25:57');
INSERT INTO settings VALUES('8','hero_sub_title','a:1:{s:7:\"English\";s:170:\"A simple, easy to customize, and powerful business platform for managing and tracking Projects, Tasks, Invoices, Quotations, Leads, Customers, Transactions and many more!\";}','','2021-01-13 15:25:57');
INSERT INTO settings VALUES('9','meta_keywords','invoice, projects, tasks, accounting, quotation, crm, business, erp, accounting software, live chat','','2020-11-11 16:51:38');
INSERT INTO settings VALUES('10','meta_description','A simple, easy to customize, and powerful business platform for managing and tracking Projects, Tasks, Invoices, Quotations, Leads, Customers, Transactions and many more!','','2020-11-11 16:51:38');
INSERT INTO settings VALUES('11','company_name','Digital','2020-11-03 11:05:07','2020-11-03 16:45:55');
INSERT INTO settings VALUES('12','site_title','Digital','2020-11-03 11:05:07','2020-11-03 16:45:55');
INSERT INTO settings VALUES('13','phone','9876543210','2020-11-03 11:05:07','2020-11-03 16:45:55');
INSERT INTO settings VALUES('14','email','dhsanuj@gmail.com','2020-11-03 11:05:07','2020-11-03 16:45:55');
INSERT INTO settings VALUES('15','timezone','Asia/Kolkata','2020-11-03 11:05:07','2020-11-03 16:45:55');
INSERT INTO settings VALUES('16','live_chat','enabled','2020-11-03 16:43:56','2020-11-11 16:49:08');
INSERT INTO settings VALUES('17','PUSHER_APP_ID','1101483','2020-11-03 16:43:56','2020-11-11 16:49:08');
INSERT INTO settings VALUES('18','PUSHER_KEY','3cb6f40607abe987b961','2020-11-03 16:43:56','2020-11-11 16:49:08');
INSERT INTO settings VALUES('19','PUSHER_SECRET','b71dec741d3190f276c7','2020-11-03 16:43:56','2020-11-11 16:49:08');
INSERT INTO settings VALUES('20','PUSHER_CLUSTER','ap2','2020-11-03 16:43:56','2020-11-11 16:49:08');
INSERT INTO settings VALUES('21','chat_max_upload_size','2','2020-11-03 16:43:56','2020-11-11 16:49:08');
INSERT INTO settings VALUES('22','chat_file_type_supported','png,jpg,jpeg,doc,pdf','2020-11-03 16:43:56','2020-11-11 16:49:08');
INSERT INTO settings VALUES('23','language','English','2020-11-03 16:45:55','2020-11-03 16:45:55');
INSERT INTO settings VALUES('24','address','noida','2020-11-03 16:45:55','2020-11-03 16:45:55');
INSERT INTO settings VALUES('25','logo','logo.png','2020-11-05 18:00:03','2020-11-05 18:00:03');
INSERT INTO settings VALUES('26','favicon','file_1604579405.png','2020-11-05 18:00:05','2020-11-05 18:00:05');
INSERT INTO settings VALUES('27','paypal_active','Yes','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('28','paypal_email','','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('29','paypal_currency','USD','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('30','stripe_active','Yes','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('31','stripe_secret_key','sk_test_51HyZs0Ew7uti2KFssZ58UzHfFfxSZZBJgUSm0IEgSvGyFvuctl44mxDLOjIj0dLdp9PdHEOnwUXpcdKoUNwKAniy00kZ1KNszy','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('32','stripe_publishable_key','pk_test_51HyZs0Ew7uti2KFsbCGvLNo8H8bQ9yjyuZ6mhmutTvv2oW15m8lkuM35xIaN3FKonfZtfe7GEsOwfvkkek28H1JD00rQMbL8Ny','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('33','stripe_currency','USD','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('34','razorpay_active','Yes','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('35','razorpay_key_id','rzp_test_AQgbp7wQbHxLpd','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('36','razorpay_secret_key','WA2sULsL9JgGFNd89vzGVvc1','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('37','razorpay_currency','INR','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('38','paystack_active','No','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('39','paystack_public_key','','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('40','paystack_secret_key','','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('41','paystack_currency','GHS','2020-11-05 18:02:22','2020-12-21 22:38:21');
INSERT INTO settings VALUES('42','currency','USD','2020-11-11 16:26:46','2020-11-11 16:26:46');
INSERT INTO settings VALUES('43','currency_position','left','2020-11-11 16:26:46','2020-11-11 16:26:46');
INSERT INTO settings VALUES('44','from_email','dhsanuj@gmail.com','2020-11-11 16:46:28','2021-01-13 15:02:37');
INSERT INTO settings VALUES('45','from_name','DHS CRM','2020-11-11 16:46:28','2021-01-13 15:02:37');
INSERT INTO settings VALUES('46','smtp_host','smtp.gmail.com','2020-11-11 16:46:28','2021-01-13 15:02:37');
INSERT INTO settings VALUES('47','smtp_port','587','2020-11-11 16:46:29','2021-01-13 15:02:37');
INSERT INTO settings VALUES('48','smtp_username','dhsanuj@gmail.com','2020-11-11 16:46:29','2021-01-13 15:02:37');
INSERT INTO settings VALUES('49','smtp_password','Dhsanuj#621','2020-11-11 16:46:29','2021-01-13 15:02:37');
INSERT INTO settings VALUES('50','smtp_encryption','tls','2020-11-11 16:46:29','2021-01-13 15:02:37');
INSERT INTO settings VALUES('51','website_title','DHS CRM','2020-11-11 16:51:38','2020-11-11 16:51:38');
INSERT INTO settings VALUES('52','website_copyright','a:1:{s:7:\"English\";s:20:\"Digital Hub Solution\";}','2021-01-13 15:25:57','2021-01-13 15:25:57');



DROP TABLE IF EXISTS social_google_accounts;

CREATE TABLE `social_google_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `provider_user_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS staff_roles;

CREATE TABLE `staff_roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO staff_roles VALUES('1','Sales Executive','Sales Team','1','2020-11-03 17:42:27','2020-11-03 17:42:27');
INSERT INTO staff_roles VALUES('2','Sales Executive','test','3','2020-11-10 23:03:24','2020-11-10 23:03:24');
INSERT INTO staff_roles VALUES('3','Lead Manager','Lead Manager','1','2020-11-27 22:17:43','2020-11-27 22:17:43');
INSERT INTO staff_roles VALUES('4','Test','','1','2020-12-22 21:55:04','2020-12-22 21:55:04');
INSERT INTO staff_roles VALUES('5','Sales Person','','6','2020-12-23 22:41:36','2020-12-23 22:41:36');
INSERT INTO staff_roles VALUES('6','Lead Manager','','6','2020-12-23 22:41:48','2020-12-23 22:41:48');



DROP TABLE IF EXISTS suppliers;

CREATE TABLE `suppliers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO suppliers VALUES('1','Blue Dart','Blue Dart','12','blue@gmail.com','9876543221','NH-24, D-247','India','Noida','VA - Virginia','201301','1','2020-11-06 11:47:06','2020-11-06 11:47:06');
INSERT INTO suppliers VALUES('2','Test','Test hub solution','','anuj.sharma@qmbsolution.in','9632145870','NH-24, D-247','India','Noida','VA - Virginia','201301','1','2020-12-22 22:26:03','2020-12-22 22:26:03');



DROP TABLE IF EXISTS task_statuses;

CREATE TABLE `task_statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int(11) DEFAULT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS tasks;

CREATE TABLE `tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `project_id` bigint(20) NOT NULL,
  `milestone_id` bigint(20) DEFAULT NULL,
  `priority` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `task_status_id` bigint(20) NOT NULL,
  `assigned_user_id` bigint(20) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `custom_fields` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS taxs;

CREATE TABLE `taxs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS timesheets;

CREATE TABLE `timesheets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `total_hour` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `project_id` bigint(20) NOT NULL,
  `task_id` bigint(20) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS transactions;

CREATE TABLE `transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trans_date` date NOT NULL,
  `account_id` bigint(20) NOT NULL,
  `chart_id` bigint(20) NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dr_cr` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `base_amount` decimal(10,2) DEFAULT NULL,
  `payer_payee_id` bigint(20) DEFAULT NULL,
  `invoice_id` bigint(20) DEFAULT NULL,
  `purchase_id` bigint(20) DEFAULT NULL,
  `purchase_return_id` bigint(20) DEFAULT NULL,
  `project_id` bigint(20) DEFAULT NULL,
  `payment_method_id` bigint(20) NOT NULL,
  `reference` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment` text COLLATE utf8mb4_unicode_ci,
  `note` text COLLATE utf8mb4_unicode_ci,
  `company_id` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO transactions VALUES('1','2020-12-04','1','1','income','cr','9265.62','9265.62','2','3','','','','3','','','','1','2020-12-04 18:49:02','2020-12-04 18:49:02');
INSERT INTO transactions VALUES('2','2021-01-13','1','1','income','cr','1200.00','1200.00','2','','','','','4','Test','','','1','2021-01-13 15:04:57','2021-01-13 15:04:57');



DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role_id` bigint(20) DEFAULT NULL,
  `profile_picture` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES('1','Anuj Sharma','dhsanuj@gmail.com','2020-11-03 11:04:15','$2y$10$7Up2DNxdbiRR.gU3IMJTbu63epYSHunJ.vkQWsD9oQYttC9yWIZWW','admin','','default.png','1','','','','2020-11-03 11:04:15','2020-11-03 11:04:15');
INSERT INTO users VALUES('2','Anuj Sharma','vishal@gmail.com','2020-11-03 16:54:30','$2y$10$kduQv234f8MEVPiZvV8DcuijlWFgn/U58D6ca6NawNU5qYHr7MIZS','client','','default.png','1','English','','','2020-11-03 16:54:30','2020-11-03 16:55:38');
INSERT INTO users VALUES('3','DHS Dehradun','dhsdehradun@gmail.com','2020-11-03 16:58:41','$2y$10$gjDkiWzyyaKbxOPAEi54EebLJ9HZ1bqCG8EcoL.yV/Ln8QMTjlTye','user','','profile_1604561553.png','1','','1','','2020-11-03 16:58:41','2020-11-10 23:21:04');
INSERT INTO users VALUES('4','Kapil','kapil.quickmicrobooks@gmail.com','2020-11-03 17:45:06','$2y$10$YQVMTk21r5dn.9mBzif2Eu0DJET8HnFIX5lqdQXwYJzypW7863nrS','staff','1','profile_1604914777.jpg','1','English','1','','2020-11-03 17:45:06','2020-11-10 19:13:27');
INSERT INTO users VALUES('5','Vipra','vipraquickbooks@gmail.com','2020-11-06 11:16:25','$2y$10$E21TXX/sx6bDH7SO2qVfte9eaJioaVS6a7jXLYaPBn/BpCWUU2hL.','staff','3','profile_1604641585.png','1','','1','','2020-11-08 11:16:26','2020-11-27 22:19:17');
INSERT INTO users VALUES('6','Sagar','sagar@gmail.com','2020-11-06 11:41:36','$2y$10$wwGFG2rjjclKXFUSkeJCuexSxJCcA97tFN3Nc.DGDVGCIA.yNEoEK','client','','default.png','1','','','','2020-11-06 11:41:36','2020-11-06 11:41:36');
INSERT INTO users VALUES('7','Test Client','test@gmail.com','2020-11-06 11:56:10','$2y$10$oGhKadmP4pyJtePNqtPHgOMr4C27fJOFhrg85nHUz08TESEfk80Ru','client','','default.png','1','','','','2020-11-06 11:56:10','2020-11-06 11:56:10');
INSERT INTO users VALUES('8','Vijay Jha','vijay@digitalhubsolution.com','2020-11-10 18:39:40','$2y$10$ffXUAKqeM1laswwieipy1utIqHnpkplJjiVwmCqIE8oOGDf0C1dj2','user','','profile_1604993980.png','1','','2','','2020-11-10 18:39:40','2020-11-10 18:39:40');
INSERT INTO users VALUES('9','Test 1','company1@gmail.com','2020-11-10 22:38:52','$2y$10$vG9waAnc/mKboY437BL1uuljZqrNR2cgNdbli016N5r8wDCzkkNIq','user','','profile_1605008332.jpg','1','','3','','2020-11-10 22:38:52','2020-11-10 22:38:52');
INSERT INTO users VALUES('10','kstest','kulbir@qmbsolution.in','2020-11-10 23:04:31','$2y$10$SaaDPlo2XSb9BXKkLQ5pJuRG5G1lfrwMtoZy5ZxVSn5X5/6NnoxlC','staff','2','profile_1605009871.jpg','1','','3','','2020-11-10 23:04:31','2020-11-10 23:04:31');
INSERT INTO users VALUES('11','Demo mehra','pooja.singh@digitalhubsolution.net','2020-12-22 21:07:53','$2y$10$pd2He7p7FKS3cYfoqU8Fq.ezUJqNz9bnKQ4IM500CSadYGrZP3rdW','user','','default.png','1','','4','','2020-12-22 21:07:53','2020-12-22 21:07:53');
INSERT INTO users VALUES('12','Demo Company','demo@company.com','2020-12-22 21:41:41','$2y$10$MXOZaoIq/LXtOG9BZsgqH.HB81z6VYq65TzIedWGAnnlZcdYogNHm','user','','default.png','1','','5','','2020-12-22 21:41:41','2020-12-22 21:41:41');
INSERT INTO users VALUES('13','Marilo','marilo@gmail.com','2020-12-23 22:29:24','$2y$10$Eva1DmyF9X.BrR.JPmki1ehhQ85irO32x4NJW.6jzaik86au27zvS','user','','default.png','1','','6','','2020-12-23 22:29:24','2020-12-23 22:29:24');
INSERT INTO users VALUES('14','Employee 1','emp1@gmail.com','2020-12-23 22:45:09','$2y$10$ZhwwDrNIGBekM/VbGJWWaOZsCBI9VEPVhr6uwm.6eSbKJTsVMO9Na','staff','6','default.png','1','','6','','2020-12-23 22:45:09','2020-12-23 22:45:09');
INSERT INTO users VALUES('15','Employee 2','emp2@gmail.com','2020-12-23 22:45:38','$2y$10$dU.EhiqDucZF8awMABsSO.nnHe40bTYvhrLGEI54EQ9SO1CfVskK.','staff','5','default.png','1','','6','','2020-12-23 22:45:38','2020-12-23 22:45:38');
INSERT INTO users VALUES('16','Employee 3','emp3@gmail.com','2020-12-23 22:46:02','$2y$10$Ze6qjhOgNTdpzy18hVn3buIlHoZbnHuoLCOhZFahX4Xd/2v9a6gce','staff','5','default.png','1','','6','','2020-12-23 22:46:02','2020-12-23 22:46:02');
INSERT INTO users VALUES('17','Deepak','deepakdehradun@gmail.com','2021-01-13 15:06:08','$2y$10$jrh0SU8yec1WD0C/oNveV.ZD4IUWKncVlcyS36vbkxNDRgLmx6.J2','staff','1','default.png','1','','1','','2021-01-13 15:06:08','2021-01-13 15:06:08');



