(function($) {

    "use strict";



    var tasks_table = $('#caller_table').DataTable({

        processing: true,

        serverSide: true,

        ajax: ({

            url: _url + '/customer/get_table_data',

            method: "POST",

            data: function (d) {



                d._token =  $('meta[name="csrf-token"]').attr('content');



                if($('select[name=type_status]').val() != ''){

                    d.type_status = $('select[name=type_status]').val();

                }
                if($('select[name=assigned_user]').val() != ''){

                    d.assigned_user = $('select[name=assigned_user]').val();

                }

                if($('select[name=remote_id]').val() != ''){

                    d.remote_id = $('select[name=remote_id]').val();

                }
                if($('select[name=payment_method]').val() != ''){

                    d.payment_method = $('select[name=payment_method]').val();

                }



                if($('input[name=date_range]').val() != ''){

                    d.date_range = $('input[name=date_range]').val();

                }

            },

            error: function (request, status, error) {

                console.log(request.responseText);

            }

        }),

        "columns" : [

            { data : 'customer_id', name : 'customer_id' },

            { data : 'name', name : 'name' },

            { data : 'phone', name : 'phone' },
            { data : 'email', name : 'email' },

            { data : 'agent.name', name : 'agent.name' },
            { data : 'amount', name : 'amount' },
            { data : 'assigneduser.name', name : 'assigneduser.name' },
            { data : 'type_status', name : 'type_status' },
            { data : 'created_at', name : 'created_at' },

            { data : "action", name : "action" },

        ],

        responsive: true,

        "bStateSave": true,

        "bAutoWidth":false,

        "ordering": false,

        "searching": false,

        "language": {

            "decimal":        "",

            "emptyTable":     $lang_no_data_found,

            "info":           $lang_showing + " _START_ " + $lang_to + " _END_ " + $lang_of + " _TOTAL_ " + $lang_entries,

            "infoEmpty":      $lang_showing_0_to_0_of_0_entries,

            "infoFiltered":   "(filtered from _MAX_ total entries)",

            "infoPostFix":    "",

            "thousands":      ",",

            "lengthMenu":     $lang_show + " _MENU_ " + $lang_entries,

            "loadingRecords": $lang_loading,

            "processing":     $lang_processing,

            "search":         $lang_search,

            "zeroRecords":    $lang_no_matching_records_found,

            "paginate": {

                "first":      $lang_first,

                "last":       $lang_last,

                "next":       $lang_next,

                "previous":   $lang_previous

            }

        }

    }).on( 'init.dt', function () {

        $('[data-toggle="tooltip"]').tooltip();

    });



    $('.select-filter').on('change', function(e) {

        tasks_table.draw();

    });



    $('#date_range').daterangepicker({

        autoUpdateInput: false,

        locale: {

            format: 'YYYY-MM-DD',

            cancelLabel: 'Clear'

        }

    });



    (function($) {

        "use strict";



        var tasks_table = $('#tasks_table').DataTable({

            processing: true,

            serverSide: true,

            ajax: ({

                url: _url + '/tasks/get_table_data',

                method: "POST",

                data: function (d) {



                    d._token =  $('meta[name="csrf-token"]').attr('content');



                    if($('select[name=project_id]').val() != ''){

                        d.project_id = $('select[name=project_id]').val();

                    }



                    if($('select[name=assigned_user_id]').val() != ''){

                        d.assigned_user_id = $('select[name=assigned_user_id]').val();

                    }



                    if($('select[name=task_status_id]').val() != null){

                        d.task_status_id = JSON.stringify($('select[name=task_status_id]').val());

                    }



                    if($('input[name=date_range]').val() != ''){

                        d.date_range = $('input[name=date_range]').val();

                    }

                },

                error: function (request, status, error) {

                    console.log(request.responseText);

                }

            }),

            "columns" : [

                { data : 'title', name : 'title' },

                { data : 'project.name', name : 'project.name' },

                { data : 'priority', name : 'priority' },

                { data : 'status.title', name : 'status.title' },

                { data : 'assigned_user.name', name : 'assigned_user.name' },

                { data : 'start_date', name : 'start_date' },

                { data : 'end_date', name : 'end_date' },

                { data : "action", name : "action" },

            ],

            responsive: true,

            "bStateSave": true,

            "bAutoWidth":false,

            "ordering": false,

            "searching": false,

            "language": {

                "decimal":        "",

                "emptyTable":     $lang_no_data_found,

                "info":           $lang_showing + " _START_ " + $lang_to + " _END_ " + $lang_of + " _TOTAL_ " + $lang_entries,

                "infoEmpty":      $lang_showing_0_to_0_of_0_entries,

                "infoFiltered":   "(filtered from _MAX_ total entries)",

                "infoPostFix":    "",

                "thousands":      ",",

                "lengthMenu":     $lang_show + " _MENU_ " + $lang_entries,

                "loadingRecords": $lang_loading,

                "processing":     $lang_processing,

                "search":         $lang_search,

                "zeroRecords":    $lang_no_matching_records_found,

                "paginate": {

                    "first":      $lang_first,

                    "last":       $lang_last,

                    "next":       $lang_next,

                    "previous":   $lang_previous

                }

            }

        }).on( 'init.dt', function () {

            $('[data-toggle="tooltip"]').tooltip();

        });



        $('.select-filter').on('change', function(e) {

            tasks_table.draw();

        });



        $('#date_range').daterangepicker({

            autoUpdateInput: false,

            locale: {

                format: 'YYYY-MM-DD',

                cancelLabel: 'Clear'

            }

        });



        $('#date_range').on('apply.daterangepicker', function(ev, picker) {

            $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));

            tasks_table.draw();

        });



        $('#date_range').on('cancel.daterangepicker', function(ev, picker) {

            $(this).val('');

        });



    })(jQuery);



    $('#date_range').on('apply.daterangepicker', function(ev, picker) {

        $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));

        tasks_table.draw();

    });



    $('#date_range').on('cancel.daterangepicker', function(ev, picker) {

        $(this).val('');

    });



})(jQuery);



