<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SaleTransaction extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'sale_transaction';
    protected $fillable =['group_id','amount','payment_id','item_id','payment_mode','subscription_type','payment_date','dr_cr','notes','status','payee_name','aph','account_number','route_name','bank_name','card_number','expiry_month','expiry_year','cvv','check_no','check_date','refund_type','refundable_amount','refund_payment_date','refund_payment_id'];
    public $timestamp= ['created_at','updated_at','deleted_at'];
    
    	public function group()
    {
        return $this->hasOne('App\ContactGroup','id','group_id')->withDefault();
    }

  /*  public function sales_return_items()
    {
        return $this->hasMany('App\SalesReturnItem',"sales_return_id");
    }

    public function customer()
    {
        return $this->belongsTo('App\Contact',"customer_id")->withDefault();
    }
	
	public function account()
    {
        return $this->belongsTo('App\Account',"account_id")->withDefault();
    }

    public function tax()
    {
        return $this->belongsTo('App\Tax',"tax_id")->withDefault();
    }
*/
}