<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'leads';
    
    public $fillable=[
        "id",
        "name",
        "email",
        "phone",
        "website",
        "lead_status_id",
        "company_name",
        "converted_lead",
        "lead_source_id",
        "assigned_user_id",
        "assigned_date",
        "created_user_id",
        "country",
        "sales_team",
        "lead_type",
        "status_date",
        "not_interested",
        "secondary_phone",
        "secondary_email",
        "time_zone",
        "status_time",
        "zone_state"
        ];
    
    
    public function lead_status()
    {
        return $this->belongsTo('App\LeadStatus','lead_status_id')->withDefault();
    }
    
    public function lead_activity()
    {
        return $this->belongsTo('App\ActivityLog','related_id')->withDefault();
    }

    public function lead_source()
    {
        return $this->belongsTo('App\LeadSource','lead_source_id')->withDefault();
    }

    public function assigned_user()
    {
        return $this->belongsTo('App\User','assigned_user_id')->withDefault();
    }
    
    public function created_user()
    {
        return $this->belongsTo('App\User','created_user_id')->withDefault();
    }

  public function zonename(){
    	return $this->belongsTo('App\TimeZoneList','time_zone')->withDefault();
    }
}