<?php

namespace App\Imports;

use App\Contact;
use App\SaleTransaction;
use App\User;
use App\ContactGroup;
use App\TimeZoneList;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Illuminate\Support\Facades\Validator;
use Auth;

class ContactsImport implements ToCollection, WithStartRow
{

    private $data;

    public function __construct(array $data = [])
    {
        $this->data = $data;
    }

    /**
     * @param Collection $rows
     */
    public function collection(Collection $rows)
    {
        $row_count = count($rows);
        if (!available_limit('contacts_limit', $row_count)) {
            return back()->with('error', _lang('Sorry, Your contacts limit is not enough !'));
        }

        $company_id = company_id();
        $i = 0;
        $j = 1;

        foreach ($rows as $row) {
            if ($row->filter()->isEmpty()) {
                continue;
            }

            Validator::make($rows->toArray(), [
                // "$i.0" => 'required|in:Company,Individual',
                "$i.0" => 'required',
                "$i.1" => 'required',
                "$i.4" => 'required',
                "$i.12" => 'required',
                "$i.18" => 'required',
                "$i.11" => 'required',
                "$i.13" => 'required',
                "$i.14" => 'required',
                "$i.19" => 'required',
                "$i.20" => 'required',
                "$i.21" => 'required',
            ], [
                "$i.0.required" => _lang('Row No') . " $j - " . _lang('Company field must required'),
                // "$i.0.in"       => _lang('Row No')." $j - "._lang('Profile Type must be Company or Individual'),
                "$i.1.required" => _lang('Row No') . " $j - " . _lang('Contact Phone field must required'),
                "$i.4.required" => _lang('Row No') . " $j - " . _lang('City field must required'),
                "$i.18.required" => _lang('Row No') . " $j - " . _lang('Card Number Must field must required'),
                "$i.12.max" => _lang('Row No') . " $j - " . _lang('Amount field must be required'),
                "$i.11.max" => _lang('Row No') . " $j - " . _lang('Subscription field must be required'),
                "$i.13.max" => _lang('Row No') . " $j - " . _lang('Payment Mode field must be required'),
                "$i.14.max" => _lang('Row No') . " $j - " . _lang('Payment Date field must be required'),
                "$i.19.max" => _lang('Row No') . " $j - " . _lang('Card Expiry month field must be required'),
                "$i.20.max" => _lang('Row No') . " $j - " . _lang('Card Expiry Year field must be required'),
                "$i.21.max" => _lang('Row No') . " $j - " . _lang('Card CVV Mumber field must be required'),
            ])->validate();

            $i++;
            $j++;

            $user_id = null;
            $user = User::where('email', $row[10])
                ->where('user_type', 'client')->first();
            if ($user) {
                $user_id = $user->id;
            }
            $userassignlead = User::where('email', $row[8])->first();
            if ($userassignlead) {
                $userassignlead_id = $userassignlead->id;
            } else {
                $userassignlead_id = Auth::user()->id;
            }

            //If Contact email already exists
            $client = Contact::where('contact_phone', $row[1])->first();
            if ($client) {
                continue;
            }

            //If Contact email already assign to company or staff
            $other = User::where('email', $row[10])
                ->where('user_type', '!=', 'client')->first();
            if ($other) {
                continue;
            }
            $tz = TimeZoneList::where('name', 'like', "%" . $row[4] . "%")->first();
            $cusis = Contact::max('customer_id');

            if (!empty($cusis)) {
                $maxv = (int)(explode("DHS", $cusis))[1];
            } else {
                $maxv = 0;
            }
//print_r($maxv);die;
            $newvalue = $maxv + 1;
            if ($newvalue <= 9) {
                $fvalue = "DHS000" . $newvalue;
            } elseif ($newvalue >= 10 && $newvalue <= 99) {
                $fvalue = "DHS00" . $newvalue;
            } elseif ($newvalue >= 100 && $newvalue <= 999) {
                $fvalue = "DHS0" . $newvalue;
            } else {
                $fvalue = "DHS" . $newvalue;
            }

            $contacts = Contact::create([
                'profile_type' => 'Company',
                'customer_id' => $fvalue,
                'company_name' => $row[0],
                'contact_name' => $row[9],
                'contact_email' => $row[10],
                //	'vat_id'     		=> $row[4],
                //	'reg_no'     		=> $row[5],
                'contact_phone' => $row[1],
                'country' => $row[3],
                'currency' => 'USD',
                'time_zone' => $tz->id ?? 0,
                'zone_state' => $row[5],
                'zip' => $row[6],
                'address' => $row[2],
                /*	'facebook'     		=> $row[13],
                    'twitter'     		=> $row[14],
                    'linkedin'     		=> $row[15],*/
                'remarks' => $row[7],
                'contact_image' => 'avatar.png',
                'group_id' => $this->data['group_id'],
                'user_id' => $user_id,
                'company_id' => $company_id,
                'converted_by_user_id' => $userassignlead_id
            ]);

            if ($contacts) {
                SaleTransaction::create([
                    'group_id' => $this->data['group_id'],
                    'item_id' => $contacts->id,
                    'payment_id' => $row[15],
                    'payment_mode' => $row[13],
                    'subscription_type' => $row[11],
                    'amount' => $row[12],
                    'payment_date' => \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject(intval($row[14]))->format('Y-m-d'),
                    'dr_cr' => 'Credit',
                    'status' => 0,
                    'notes' => $row[16],
                    'payee_name' => $row[17],
                    'card_number' => $row[18],
                    'expiry_month' => $row[19],
                    'expiry_year' => $row[20],
                    'cvv' => $row[21],
                    'bank_name' => $row[22],
                ]);
            }

        }

    }

    /**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }

}
