<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Service;
use App\Contact;
use App\Item;
use Validator;
use Illuminate\Validation\Rule;
use App\Imports\ServicesImport;
use Maatwebsite\Excel\Facades\Excel;
use DB;
use App\ServiceDuration;

class ServiceController extends Controller
{
	
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $items = Item::where("company_id",company_id())
		            ->where("item_type","service")
                    ->orderBy("id","desc")->get();
        return view('backend.accounting.service.list',compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
		if( ! $request->ajax()){
		   return view('backend.accounting.service.create');
		}else{
           return view('backend.accounting.service.modal.create');
		}
    }

    /** Excel Import**/
    public function import(Request $request)
    {       
        if($request->isMethod('get')){
            return view('backend.accounting.service.import');
        }else{
            @ini_set('max_execution_time', 0);
            @set_time_limit(0);

            $validator = Validator::make($request->all(), [
                'file' => 'required|mimes:xlsx',
            ]);
            
            if ($validator->fails()) {
                if($request->ajax()){ 
                    return response()->json(['result'=>'error','message'=>$validator->errors()->all()]);
                }else{
                    return redirect('services/import')->withErrors($validator)
                                                      ->withInput();
                }           
            }
                
            $new_rows = 0;

            DB::beginTransaction();
            
            $previous_rows = Item::where('company_id',company_id())->count();

            $import = Excel::import(new ServicesImport, request()->file('file'));

            $current_rows = Item::where('company_id',company_id())->count();

            $new_rows = $current_rows - $previous_rows;

            DB::commit();

            return back()->with('success',$new_rows.' '._lang('Rows Imported Sucessfully'));
        }           
        
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {	
		$validator = Validator::make($request->all(), [
			'item_name' => 'required',
            'cost' => 'required|numeric',
		]);
		
		if ($validator->fails()) {
			if($request->ajax()){ 
			    return response()->json(['result'=>'error','message'=>$validator->errors()->all()]);
			}else{
				return redirect('services/create')
							->withErrors($validator)
							->withInput();
			}			
		}
		
        DB::beginTransaction();	
		
        //Create Item
        $item = new Item();
        $item->item_name = $request->input('item_name');
        $item->item_type = 'service';
        $item->company_id = company_id();
        $item->save();


	    //Create Product
        $service = new Service();
	    $service->item_id = $item->id;
        $service->cost = $request->input('cost');
        $service->tax_method = $request->input('tax_method');
        $service->tax_id = $request->input('tax_id');
        $service->description = $request->input('description');
        
        $service->save();
		
		DB::commit();
        
		if(! $request->ajax()){
           return redirect('services/create')->with('success', _lang('Saved Sucessfully'));
        }else{
		   return response()->json(['result'=>'success','action'=>'store','message'=>_lang('Saved Sucessfully'),'data'=>$service]);
		}
        
   }
	

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        $item = Item::where("id",$id)->where("company_id",company_id())->first();

		if(! $request->ajax()){
		    return view('backend.accounting.service.view',compact('item','id'));
		}else{
			return view('backend.accounting.service.modal.view',compact('item','id'));
		} 
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        $item = Item::where("id",$id)->where("company_id",company_id())->first();

		if(! $request->ajax()){
		   return view('backend.accounting.service.edit',compact('item','id'));
		}else{
           return view('backend.accounting.service.modal.edit',compact('item','id'));
		}  
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
			'item_name' => 'required',
            'cost' => 'required|numeric',
		]);
		
		if ($validator->fails()) {
			if($request->ajax()){ 
			    return response()->json(['result'=>'error','message'=>$validator->errors()->all()]);
			}else{
				return redirect()->route('services.edit', $id)
							->withErrors($validator)
							->withInput();
			}			
		}
    
        //Update item
		DB::beginTransaction();
        $item = Item::where("id",$id)->where("company_id",company_id())->first();
        
        if( $item ){

            $item->item_name = $request->input('item_name');
            $item->item_type = 'service';
            $item->company_id = company_id();
            $item->save();

            
            $service = Service::where("item_id",$id)->first();
            $service->item_id = $item->id;
            $service->cost = $request->input('cost');
            $service->tax_method = $request->input('tax_method');
            $service->tax_id = $request->input('tax_id');
            $service->description = $request->input('description');
        
            $service->save();
			DB::commit();
        }else{
            if(! $request->ajax()){
                return redirect('services')->with('error', _lang('Update Failed !'));
             }else{
                return response()->json(['result'=>'error','message'=>_lang('Update Failed !')]);
             }
        }

		
		if(! $request->ajax()){
           return redirect('services')->with('success', _lang('Updated Sucessfully'));
        }else{
		   return response()->json(['result'=>'success','action'=>'update', 'message'=>_lang('Updated Sucessfully'),'data'=>$service]);
		}
	    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
		DB::beginTransaction();
        $item = Item::where("id",$id)->where("company_id",company_id());
        $item->delete();

        $service = Service::where("item_id",$id);
        $service->delete();
		DB::commit();
        return redirect('services')->with('success',_lang('Information has been deleted sucessfully'));
    }
    
    /**
     *
     * @return \Illuminate\Http\Response
     */
    public function get_client_service_data()
    {
        $items = Item::with('service')->where("company_id",company_id())
		            ->where("item_type","service")
                    ->orderBy("id","desc")->get();
        $contacts = Contact::with("group")->select('contacts.*')
										  ->where("contacts.company_id",company_id())
										  ->orderBy("contacts.id","desc")->get();
								  
        return view('backend.accounting.contacts.assign_contact_service',compact('items', 'contacts'));
    }
    
    /**
     *
     * @return \Illuminate\Http\Response
     */
    public function post_client_service_data(Request $request)
    {
        if($request->service_contact){
            
            $service_contact = ServiceDuration::find($request->service_contact);
            $service_contact->item_id = $request->item_id;
            $service_contact->company_id = company_id();
            $service_contact->contact_id = $request->contact_id;
            $service_contact->item_id = $request->item_id;
            $service_contact->user_id = $request->user_id;
            $service_contact->duration = $request->duration;
            $service_contact->status = $request->status;
            $service_contact->valid_to = date('Y-m-d', strtotime('+'.$request->duration.' months'));
            $service_contact->save();
            return redirect('/assign_service_contact_list')->with('success',_lang('Information has been Updated sucessfully'));
        }else{
            
            $service_contact = new ServiceDuration();
            $service_contact->item_id = $request->item_id;
            $service_contact->company_id = company_id();
            $service_contact->contact_id = $request->contact_id;
            $service_contact->item_id = $request->item_id;
            $service_contact->user_id = $request->user_id;
            $service_contact->duration = $request->duration;
            $service_contact->status = $request->status;
            $service_contact->valid_to = date('Y-m-d', strtotime('+'.$request->duration.' months'));
            $service_contact->save();
            return redirect('/assign_service_contact_list')->with('success',_lang('Information has been Created sucessfully'));
        }
    }
    
    /**
     *
     * @return \Illuminate\Http\Response
     */
    public function assign_service_contact_list(Request $request)
    {
        $service_contact = ServiceDuration::orderBy('created_at', 'desc')->get();
        return view('backend.accounting.contacts.list_assign_contact_service',compact('service_contact'));
    }
    
    public function edit_assign_service_contact($id)
    {
        $items = Item::with('service')->where("company_id",company_id())
		            ->where("item_type","service")
                    ->orderBy("id","desc")->get();
        $contacts = Contact::with("group")->select('contacts.*')
										  ->where("contacts.company_id",company_id())
										  ->orderBy("contacts.id","desc")->get();
		$service_contact = ServiceDuration::find($id);
								  
        return view('backend.accounting.contacts.edit_assign_contact_service',compact('items', 'contacts', 'service_contact'));
    }
    
    public function destroy_service_duration($id)
    {
		DB::beginTransaction();
        $service = ServiceDuration::where("id",$id);
        $service->delete();
		DB::commit();
        return redirect('/assign_service_contact_list')->with('success',_lang('Information has been deleted sucessfully'));
    }
    
    public function service_renewals()
    {
		DB::beginTransaction();
        $user_list = DB::select("SELECT contacts.*, service_durations.* FROM contacts JOIN service_durations ON contacts.company_id = service_durations.company_id WHERE MONTH(service_durations.valid_to) = MONTH(NOW()) ");
		DB::commit();
        return view('backend.accounting.contacts.service_renewals',compact('user_list'));
    }
}
