<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Transaction;
use App\RepeatTransaction;
use App\ServiceDuration;
use App\User;
use App\EmailTemplate;
use App\Company;
use Illuminate\Support\Facades\Mail;
use App\Mail\AlertNotificationMail;
use App\Utilities\Overrider;
use DB;
use Log;

class RenewalJobsController extends Controller
{
	
    /**
     * Show the application CronJobs.
     *
     * @return \Illuminate\Http\Response
     */
    public function run()
    {
		@ini_set('max_execution_time', 0);
		@set_time_limit(0);
		
		/** Update Currency Exchange Rate **/
		update_currency_exchange_rate(true);
		
		/** Process Repeat Transactions **/
		$date = date("Y-m-d");
		
		
		/** Send Alert Notification to User before expiry package **/
		$days_before = 2;
		$user_list = DB::select("SELECT contacts.*, service_durations.valid_to FROM contacts JOIN service_durations ON contacts.company_id = service_durations.company_id WHERE DATEDIFF(service_durations.valid_to, CURDATE()) <= $days_before ");
        Log::debug('Renewals '.count($user_list));
		if (count($user_list) > 0) {
            foreach ($user_list as $user) {
				/** Replace Paremeter **/
				$replace = array(
					'{name}'     => $user->contact_name,
					'{email}'    => $user->contact_email,
					'{valid_to}' => date('d M, Y', strtotime($user->valid_to)),
				);
				
				//Send email Confrimation
				Overrider::load("Settings");
				$template = EmailTemplate::where('name','alert_notification')->first();
				$template->body = process_string($replace, $template->body);
				
				try{
					Mail::to($user->contact_email)->send(new AlertNotificationMail($template));
				}catch (\Exception $e) {
					//Noting
				}
            }

        }

        echo 'Scheduled task runs successfully';
	
    }

}
