<?php

namespace App\Http\Controllers;

use App\Caller;
use App\Exports\ExportCaller;
use App\User;
use Illuminate\Http\Request;
use App\Task;
use App\TaskStatus;
use Validator;
use DataTables;
use Auth;
use DB;
use Excel;
use Notification;
use App\Notifications\TaskCreated;
use App\Notifications\TaskUpdated;

class CallerController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        date_default_timezone_set(get_company_option('timezone', get_option('timezone','Asia/Dhaka')));

        $this->middleware(function ($request, $next) {
            if( has_membership_system() == 'enabled' ){
                if( ! has_feature( 'project_management_module' ) ){
                    if( ! $request->ajax()){
                        return redirect('membership/extend')->with('message', _lang('Sorry, This feature is not available in your current subscription. You can upgrade your package !'));
                    }else{
                        return response()->json(['result'=>'error','message'=>_lang('Sorry, This feature is not available in your current subscription !')]);
                    }
                }
            }

            return $next($request);
        });
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($view_type = '')
    {
        $callermanager=User::where('user_type','staff')->get();

        if($view_type == 'kanban'){
            $company_id = company_id();
            $task_status = Caller::where('company_id', $company_id)
                ->orderBy('order','asc')
                ->get();

            return view('backend.accounting.task.kanban_view',compact('task_status','callermanager'));
        }else{
            return view('backend.accounting.caller.list',compact('callermanager'));
        }

    }

    /* Get Logs Data*/
    public function load_more_task(Request $request, $status_id, $task_id){

        if( $request->ajax()){
            $tasks = Task::where('company_id', company_id())
                ->where('task_status_id',$status_id)
                ->where('id','<', $task_id)
                ->with('assigned_user')
                ->latest()
                ->limit(20)
                ->get();
            echo json_encode($tasks);
        }
    }

    /** Update Lead Status **/
    public function update_task_status(Request $request, $status_id, $task_id){

        if( $request->ajax()){
            $task = Task::where('id',$task_id)
                ->where('company_id', company_id())
                ->first();

            if($task){
                $task->task_status_id = $status_id;
                $task->save();
                echo json_encode($task);
            }
        }
    }

    public function get_table_data(Request $request){
        $user_type = Auth::user();

        $tasks = Caller::where('company_id',company_id())
            ->when($user_type, function ($query, $user_type) {
                if($user_type->role_id == 19){
                    return $query;
                }elseif($user_type->user_type == 'staff' && $user_type->role_id == 12){
                    return $query;
                }elseif($user_type->user_type == 'staff' && $user_type->role_id == 16){
                    return $query->where('assigned_user', Auth::id());
                }
            })
            ->orderBy("id","desc");

        return Datatables::eloquent($tasks)
            ->filter(function ($query) use ($request) {
               /* if ($request->has('project_id')) {
                    $query->where('project_id', 'like', "%{$request->get('project_id')}%");
                }
*/
                if ($request->has('assigned_user')) {
                    $query->where('assigned_user', $request->get('assigned_user'));
                }

                if ($request->has('remote_id')) {
                    $query->where('remote_id', 'like', "%{$request->get('remote_id')}%");
                }
                if ($request->has('payment_method')) {
                    $query->where('payment_method', 'like', "%{$request->get('payment_method')}%");
                }
            /*  if ($request->has('search')) {
                    $query->where('email', 'like', "%{$request->get('search')}%")
                   ->orWhere('name', 'like', "%{$request->get('search')}%")
                        ->orWhere('phone', 'like', "%{$request->get('search')}%")
                        ->orWhere('customer_id', 'like', "%{$request->get('search')}%")
                        ->orWhere('customer_device', 'like', "%{$request->get('search')}%");
                }*/


                if ($request->has('type_status')) {
                    $query->where('type_status', 'like', "%{$request->get('type_status')}%");
                }

                if ($request->has('date_range')) {
                    $date_range = explode(" - ",$request->get('date_range'));
                    $query->whereBetween('created_at', [$date_range[0], $date_range[1]]);
                }
            })
            ->editColumn('caller_name', function ($task) {
                return $task->caller_name??'NA';
            })

        ->editColumn('assigneduser.name', function ($task) {
            return $task->assigneduser->name??'Admin';
        })
            ->editColumn('agent.name', function ($task) {
                return $task->agent->name??'';
            })
           /* ->editColumn('priority', function ($task) {
                return task_priority($task->priority);
            })*/
            /*->editColumn('status.title', function ($task) {
                $status_color = $task->status->color;
                return "<span class='badge badge-primary' style='background:{$status_color}'>{$task->status->title}</span>";
            })*/
  ->editColumn('created_at', function ($task) {
                $date_format = get_company_option('date_format','Y-m-d');
                return date("$date_format",strtotime($task->created_at));
            })

            ->addColumn('action', function ($task) {
                return '<form action="'.action('CallerController@destroy', $task['id']).'" class="text-center" method="post">'
                    .'<a href="'.action('CallerController@show', $task['id']).'" data-title="'. $task->name .'" class="btn btn-primary btn-xs"><i class="ti-eye"></i></a>&nbsp;'
                    .'<a href="'.action('CallerController@edit', $task['id']).'" data-title="'. _lang('Update Task') .'" class="btn btn-warning btn-xs"><i class="ti-pencil"></i></a>&nbsp;'
                    .csrf_field()
                    .'<input name="_method" type="hidden" value="DELETE">'
                    .'<button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>'
                    .'</form>';
            })
            ->setRowId(function ($task) {
                return "row_".$task->id;
            })
            ->rawColumns(['customer_id','name', 'email', 'phone', 'amount','type_status', 'action'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        if( ! $request->ajax()){
            $callermanager=User::where('user_type','staff')->get();
            return view('backend.accounting.caller.create',compact('callermanager'));
        }else{
            return view('backend.accounting.caller.create');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      //  $max_size = get_option('file_manager_max_upload_size',2) * 1024;
      //  $supported_file_types = get_option('file_manager_file_type_supported','png,pdf,jpg,jpeg');
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
           // 'address' => 'required',
            'phone' => 'required',
            'amount' => 'required',
            'file' => 'mimes:pdf,png,gif,jpg,jpeg|max:2048',
          //  'file' => "required|file|max:$max_size|mimes:$supported_file_types",
        ],
            [
                'mimes' => 'File type is not supported',
            ]);

        if ($validator->fails()) {
            if($request->ajax()){
                return response()->json(['result'=>'error','message'=>$validator->errors()->all()]);
            }else{
                return redirect()->route('customer.create')
                    ->withErrors($validator)
                    ->withInput();
            }
        }

        DB::beginTransaction();
        $cusis=Caller::max('customer_id');

        if(!empty($cusis)){
            $maxv= (int)(explode("DHS",$cusis))[1];
        }else{
            $maxv=0;
        }
//print_r($maxv);die;
        $newvalue=$maxv +1;
        if($newvalue<=9){
            $fvalue="DHS000".$newvalue;
        }elseif($newvalue>=10 && $newvalue<=99){
            $fvalue="DHS00".$newvalue;
        }elseif($newvalue>=100 && $newvalue<=999){
            $fvalue="DHS0".$newvalue;
        }else{
            $fvalue="DHS".$newvalue;
        }
        if($request->hasfile('file'))
        {
            $file = $request->file('file');
            $file_name = time().$file->getClientOriginalName();
            $file->move(public_path()."/uploads/caller/", $file_name);
        }else{
            $file_name='';
        }
        $task = new Caller();
        $task->name = $request->input('name');
        $task->email = $request->input('email');
        $task->phone = $request->input('phone');
        $task->address = $request->input('address');
        $task->customer_id = $fvalue;
        $task->file = $file_name;
        $task->amount = $request->input('amount');
        $task->type_status = $request->input('type_status');
        $task->payment_method = $request->input('payment_method');
        $task->comments = $request->input('comments');
        $task->customer_device = $request->input('customer_device');
        $task->printer_use_case = $request->input('printer_use_case');
        $task->printer_problem = $request->input('printer_problem');
        $task->caller_name = $request->input('caller_name');
        $task->remote_id = $request->input('remote_id');
        $task->loginId = $request->input('loginId');
        $task->password = $request->input('password');
        $task->assigned_user = $request->input('assigned_user')??'0';
        $task->subscription_duration = $request->input('subscription_duration');
        /*$task->name_card_check = $request->input('name_card_check');
        $task->card_number = $request->input('card_number');
        $task->expiry_date = $request->input('expiry_date');
        $task->card_cvv = $request->input('card_cvv');
        $task->routing_number = $request->input('routing_number');
        $task->account_number = $request->input('account_number');
        $task->check_number = $request->input('check_number');*/
        $task->user_id = Auth::id();
        $task->company_id = company_id();

        $task->save();

        create_log('caller', $task->id, _lang('Create New caller'));


        DB::commit();

        if(! $request->ajax()){
            return redirect()->route('customer.create')->with('success', _lang('Saved Sucessfully'));
        }else{
            return response()->json(['result'=>'success','action'=>'store','message'=>_lang('Saved Sucessfully'), 'data'=>$task, 'table' => '#caller_table']);
        }

    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        $task = Caller::where('id', $id)
            ->where('company_id',company_id())
            ->first();

        if(! $task){
            if(! $request->ajax()){
                return back()->with('error', _lang('Sorry, Task not found !'));
            }else{
                return response()->json(['result'=>'error', 'message' =>  _lang('Sorry, Task not found !')]);
            }
        }

        if(! $request->ajax()){
            return view('backend.accounting.caller.view',compact('task','id'));
        }else{
            return view('backend.accounting.caller.view',compact('task','id'));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        $task = Caller::where('id', $id)
            ->where('company_id',company_id())
            ->first();
        $callermanager=User::where('user_type','staff')->get();
        if(! $request->ajax()){
            return view('backend.accounting.caller.edit',compact('task','id','callermanager'));
        }else{
            return view('backend.accounting.caller.edit',compact('task','id','callermanager'));
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      //  $max_size = get_option('file_manager_max_upload_size',2) * 1024;
     //   $supported_file_types = get_option('file_manager_file_type_supported','png,pdf,jpg,jpeg');
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
           // 'address' => 'required',
            'phone' => 'required',
            'amount' => 'required',
            'file' => 'mimes:pdf,png,gif,jpg,jpeg|max:2048',
          //  'file' => "required|file|max:$max_size|mimes:$supported_file_types",
        ],
            [
                'mimes' => 'File type is not supported',
            ]);

        if ($validator->fails()) {
            if($request->ajax()){
                return response()->json(['result'=>'error','message'=>$validator->errors()->all()]);
            }else{
                return redirect()->route('customer.edit', $id)
                    ->withErrors($validator)
                    ->withInput();
            }
        }
        if($request->hasfile('file'))
        {
            $file = $request->file('file');
            $file_name = time().$file->getClientOriginalName();
            $file->move(public_path()."/uploads/caller/", $file_name);
        }


        $task = Caller::where('id', $id)
            ->where('company_id',company_id())
            ->first();
        if($request->hasfile('file')){
            $task->file = $file_name;
        }
        $task->name = $request->input('name');
        $task->email = $request->input('email');
        $task->phone = $request->input('phone');
        $task->address = $request->input('address');
       // $task->customer_id = 1;
        $task->amount = $request->input('amount');
        $task->type_status = $request->input('type_status');
        $task->comments = $request->input('comments');
        $task->payment_method = $request->input('payment_method');
        $task->comments = $request->input('comments');
        $task->customer_device = $request->input('customer_device');
        $task->printer_use_case = $request->input('printer_use_case');
        $task->printer_problem = $request->input('printer_problem');
        $task->caller_name = $request->input('caller_name');
        $task->subscription_duration = $request->input('subscription_duration');
        $task->remote_id = $request->input('remote_id');
        $task->loginId = $request->input('loginId');
        $task->password = $request->input('password');
        $task->assigned_user = $request->input('assigned_user')??'0';
       /* $task->name_card_check = $request->input('name_card_check');
        $task->card_number = $request->input('card_number');
        $task->expiry_date = $request->input('expiry_date');
        $task->card_cvv = $request->input('card_cvv');
        $task->routing_number = $request->input('routing_number');
        $task->account_number = $request->input('account_number');
        $task->check_number = $request->input('check_number');*/
        $task->user_id = Auth::id();
        $task->company_id = company_id();

        $task->save();

        create_log('caller', $task->id, _lang('Update caller').' - '.$task->id.'# '.$task->name);


        if(! $request->ajax()){
            return redirect()->route('customer.index')->with('success', _lang('Updated Sucessfully'));
        }else{
            return response()->json(['result'=>'success','action'=>'update', 'message'=>_lang('Updated Sucessfully'), 'data'=>$task, 'table' => '#caller_table']);
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $task = Caller::where('id', $id)
            ->where('company_id',company_id())
            ->first();
        create_log('caller', $task->id, _lang('Remove caller').' - '.$task->id.'# '.$task->name);
        $task->delete();
        return redirect()->route('customer.index')->with('success',_lang('Deleted Sucessfully'));
    }

    public function downloadCallerReport(Request $request){
        $callers=Caller::orderBy('id','desc')->get();
        return Excel::download(new ExportCaller($callers), 'customers.xlsx');
    }
}