<?php
 
namespace App\Console\Commands;
 
use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Lead;
use App\ActivityLog;
class TodayUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'TodayUsers:check';
 
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This Cronjob is used to check reminder set by user for today';
 
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }
 
    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
         $today = Carbon::now();
            $td = $today->format('Y-m-d');
            $count = \DB::table('reminders')
            ->whereDate('date', '=', $td)
            ->count();
            $leads = ActivityLog::with('lead_activity')->where('created_at', '<=', Carbon::now()->subDays(2)->toDateTimeString())->groupBy('related_id')->count();
        //\Log::info($leads);
    }
}