<?php $__env->startSection('content'); ?>

<?php if(\Session::has('paypal_success')): ?>
  <div class="alert alert-success text-center">
	<b><?php echo e(\Session::get('paypal_success')); ?></b>
  </div>
  <br>
<?php endif; ?>

<?php 
$currency = currency(); 
$date_format = get_company_option('date_format','Y-m-d');
?>

<!--Start Card-->
<div class="row">
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg1">
				<div class="p-4">
					<div class="seofct-icon">
						<span><?php echo e(_lang('Total Customers')); ?></span>
					</div>
					<h2><?php echo e($converted_by_user_id); ?></h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg2">
				<div class="p-4">
					<div class="seofct-icon">
						<span><?php echo e(_lang('Total Current Month Sale')); ?></span>
					</div>
					<h2><?php echo e(decimalPlace($total_current_month_sale, $currency)); ?></h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg4">
				<div class="p-4">
					<div class="seofct-icon">
						<span><?php echo e(_lang('Total Previous Month Sale')); ?></span>
					</div>
					<h2><?php echo e(decimalPlace($total_previous_month_sale, $currency)); ?></h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg2">
				<div class="p-4">
					<div class="seofct-icon">
						<span><?php echo e(_lang('Total Current Year Sale')); ?></span>
					</div>
					<h2><?php echo e(decimalPlace($total_current_year_sale, $currency)); ?></h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg3">
				<div class="p-4">
					<div class="seofct-icon">
						<span><?php echo e(_lang('Total Previous Year Sale')); ?></span>
					</div>
					<h2><?php echo e(decimalPlace($total_previous_year_sale, $currency)); ?></h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg1">
				<div class="p-4">
					<div class="seofct-icon">
						<span><?php echo e(_lang('Gross Income')); ?></span>
					</div>
					<h2><?php echo e(decimalPlace($total_sale, $currency)); ?></h2>
				</div>
			</div>
		</div>
	</div>

</div>


























































































































































































































<!--end row-->
<!--End Card-->

<div class="row">
  <div class="col-md-6">
	 <div class="card">
		<div class="card-body">
		   <h4 class="header-title mt-0"><?php echo e(_lang('Income VS Expense')." - ".date('Y')); ?></h4>
		   <div id="yearly_income_expense"></div>	
		</div>
	 </div>
  </div>

  <div class="col-md-6">
	 <div class="card">
		<div class="card-body">
			<div>
				<select id="year_select_box" class="form-control year_select_box">
           		<option value="">Select Year</option>
       			<?php
			  		$currently_selected = date('Y');
			  		$earliest_year = 2015;
			  		$latest_year = date('Y'); 
			  	?>
				<?php $__currentLoopData = range( $latest_year, $earliest_year ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				    <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>	
           	</select>
<a class="btn btn-primary btn-xs" id="upload_previous_data" style="display: none;" href="#" data-toggle="modal" data-target="#myModal">Upload File</a>
<a class="btn btn-primary btn-xs" href="https://crm.projectdigitalhubsolution.com/xlsx_sample/month.csv">Sample File</a>
			</div>
           	

			<div class="row">
		    <div class="col-md-6">
	<div id="piechart1" class="piechart">
		<?php echo $graph1; ?> 
	</div>
</div>
<div class="col-md-6">
	<div id="piechart2" class="piechart">
		<?php echo $graph2; ?> 
	</div>

  </div>	
</div>
		</div>
	 </div>
  </div>
 
</div>


<div class="container">
<!--   <h2>Modal Example</h2> -->
  <!-- Button to Open the Modal -->
<!--   <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
    Open modal
  </button> -->

  <!-- The Modal -->
  <div class="modal" id="myModal">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Upload CSV</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        
        <!-- Modal body -->
        <div class="modal-body">
         <form action="<?php echo e(url('/previous-data')); ?>" enctype="multipart/form-data" method="post">
         	<?php echo e(csrf_field()); ?>

		  <div class="form-group">
		    <label for="email">Attach File:</label>
		    <input type="hidden" class="form-control" name="year" id="year_csv">
		    <input type="file" class="form-control" placeholder="Enter email" id="email" name="file">
		  </div>
		  <button type="submit" class="btn btn-primary">Submit</button>
		</form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<div class="row d-flex align-items-stretch">

  <!-- Panel 1 -->
  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		    <h4 class="header-title mt-0"><?php echo e(_lang('Recent Projects')); ?></h4>
		    <div class="table-responsive card-scroll">
			    <table class="table">
				      <thead>
					    <tr>
							<th><?php echo e(_lang('Name')); ?></th>	
							<th><?php echo e(_lang('Start Date')); ?></th>
							<th><?php echo e(_lang('End Date')); ?></th>
							<th><?php echo e(_lang('Status')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = Auth::user()->projects->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						    <tr>
								<td><a href="<?php echo e(action('ProjectController@show', $project->id)); ?>"><?php echo e($project->name); ?></a></td>
								<td><?php echo e(date($date_format,strtotime($project->start_date))); ?></td>
								<td><?php echo e(date($date_format,strtotime($project->end_date))); ?></td>
								<td><?php echo clean(project_status($project->status)); ?></td>
								<td>
									<form action="<?php echo e(action('ProjectController@destroy', $project['id'])); ?>" class="text-center" method="post">
										<a href="<?php echo e(action('ProjectController@edit', $project['id'])); ?>" data-title="'. _lang('Update Project') .'" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
										<?php echo e(csrf_field()); ?>

										<input name="_method" type="hidden" value="DELETE">
										<button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
									</form>
								</td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div>
  <!-- End Panel 1 -->

  <!-- Panel 2 -->
  <!-- <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0"><?php echo e(_lang('Recent Tasks')); ?></h4>
		   <div class="table-responsive card-scroll">
			   <table class="table">
				    <thead>
					    <tr>
							<th><?php echo e(_lang('Name')); ?></th>	
							<th><?php echo e(_lang('Priority')); ?></th>
							<th><?php echo e(_lang('Status')); ?></th>
							<th><?php echo e(_lang('Deadline')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = Auth::user()->tasks->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						    <tr>
								<td><a href="<?php echo e(action('TaskController@show', $task->id)); ?>" data-title="<?php echo e($task->title); ?>" class="ajax-modal"><?php echo e($task->title); ?></a></td>
								<td><?php echo clean(task_priority($task->priority)); ?></td>
								<td>
									<span class='badge badge-primary' style='background:{$task->status->color}'><?php echo e($task->status->title); ?></span>
								</td>
								<td><?php echo e(date($date_format,strtotime($task->end_date))); ?></td>
								<td>
									<form action="<?php echo e(action('TaskController@destroy', $task['id'])); ?>" class="text-center" method="post">
										<a href="<?php echo e(action('TaskController@edit', $task['id'])); ?>" data-title="'. _lang('Update Project') .'" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
										<?php echo e(csrf_field()); ?>

										<input name="_method" type="hidden" value="DELETE">
										<button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
									</form>
								</td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div> -->

  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0"><?php echo e(_lang('Hot Prospect')); ?></h4>
		   <div class="table-responsive card-scroll">
			   <table class="table">
				    <thead>
					    <tr>
							<th><?php echo e(_lang('Name')); ?></th>
							<th><?php echo e(_lang('Email')); ?></th>
							<th><?php echo e(_lang('Phone')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						    <tr>
								<td><a href="<?php echo e(action('LeadController@show', $lead->id)); ?>" data-title="<?php echo e(_lang('View Lead Details')); ?>" class="ajax-modal"><?php echo e($lead->name); ?></a></td>
								<td><?php echo e($lead->email); ?></td>
								<td><?php echo e($lead->phone); ?></td>
								<td>
							<form action="<?php echo e(action('LeadController@destroy', $lead['id'])); ?>" class="text-center" method="post">
								<a href="<?php echo e(action('LeadController@show', $lead['id'])); ?>" data-title="<?php echo e(_lang('View Lead Details')); ?>" class="btn btn-primary btn-xs ajax-modal"><i class="ti-eye"></i></a>
								<a href="<?php echo e(action('LeadController@edit', $lead['id'])); ?>" data-title="<?php echo e(_lang('Update Lead')); ?>" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
                                <?php echo e(csrf_field()); ?>

                                <input name="_method" type="hidden" value="DELETE">
                                <button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
                            </form>
								</td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div>
  <!-- End Panel 2 -->

</div>

<div class="row mt-4 d-flex align-items-stretch">
  <!-- Panel 3 -->
  <!-- <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0"><?php echo e(_lang('Income vs Expense')." - ".date('M, Y')); ?></h4>
		   <div id="dn_income_expense"></div>
		</div>
	 </div>
  </div> -->

  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">Reminders</h4>
		   <div class="table-responsive">
			<table class="table table-bordered">
				<thead>
				  <tr>
					<th>Client</th>
					<th>Email</th>
					<th>Phone</th>
					<th>Note</th>
					<th>View</th>
				  </tr>
				</thead>
				<tbody>

				  <?php $__currentLoopData = $reminders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				  <?php
				  	$today = \Carbon\Carbon::now();
    				$td = $today->format('Y-m-d');
    				$re_date = date("Y-m-d", strtotime($value->date) );
				  ?>
				  <tr id="row_<?php echo e($value->id); ?>" class="<?php if($re_date >= $td): ?> <?php echo e('alert alert-success'); ?> <?php else: ?> <?php echo e('alert alert-danger'); ?> <?php endif; ?>">
					<td class='account_title'><?php echo e(client_name($value->lead_id)); ?></td>
					<td class='account_number'><?php echo e(client_email($value->lead_id)); ?></td>
					<td class='opening_balance'><?php echo e(client_phone($value->lead_id)); ?></td>
					<td class='opening_balance'><?php echo e($value->description); ?></td>
					<td class='opening_balance text-center'><a class="btn btn-primary btn-xs" href="<?php echo e(url('/')); ?>/leads/<?php echo e($value->lead_id); ?>"><i class="ti-eye"></i></a></td>
				  </tr>
				  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			  </table>
            </div>
		</div>
	 </div>
  </div>


  <!-- End Panel 3 -->
  <!-- Panel 4 -->

<div class="col-md-6">
	<div class="card h-100">
		<div class="card-body">
		  	<h4 class="header-title mt-0">Employee of the month</h4>
		  	<div class="table-responsive">
				<table class="table table-bordered">
					<thead>
					  <tr>
						<th>Name</th>
						<th>Email</th>
						<th>Score</th>
					  </tr>
					</thead>
					<?php if($user == 'no'): ?>
					<tbody>
						<tr id="row_1">
						<td>No record found!</td>
					  	</tr>
					</tbody>
					<?php else: ?>
					<tbody>
					  <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					  <tr id="row_<?php echo e($value['id']); ?>" class="alert alert-success">
						<td class='account_title'><?php echo e($value['name']); ?></td>
						<td class='account_number'><?php echo e($value['email']); ?></td>
						<td class='opening_balance text-right'><?php echo e(round($percentage)); ?>%</td>
					  </tr>
					  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
					<?php endif; ?>
				</table>
            </div>
		</div>
	</div>
</div>


   
  <!-- End Panel 4 -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script src="<?php echo e(URL::asset('/backend/assets/js/dashboard.js?v=1.1')); ?>"></script>
<script type="text/javascript">
 $(function () {
 $('[data-toggle="tooltip"]').tooltip()
})
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/backend/dashboard-user.blade.php ENDPATH**/ ?>