<?php $__env->startSection('content'); ?>
<div class="row">
<div class="col-12">
<form method="post" class="validate" autocomplete="off" action="<?php echo e(url('contacts')); ?>" enctype="multipart/form-data">
	<div class="row">
		<div class="col-md-8">
		<div class="card">
		<span class="d-none panel-title"><?php echo e(_lang('Add New Contact')); ?></span>

		<div class="card-body">
			<?php echo e(csrf_field()); ?>


			<div class="row">
				<div class="col-md-6" hidden>
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Profile Type')); ?></label>						
					<select class="form-control select2" name="profile_type" required>
						<option value="Company" selected><?php echo e(_lang('Company')); ?></option>
						<option value="Individual" <?php echo e(old('profile_type')=="Individual" ? "selected" : ""); ?>><?php echo e(_lang('Individual')); ?></option>
					</select>
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Company Name')); ?></label>						
					<input type="text" class="form-control" name="company_name" value="<?php echo e(old('company_name')); ?>" required>
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Contact Name')); ?></label>						
					<input type="text" class="form-control" name="contact_name" value="<?php echo e(old('contact_name')); ?>">
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Contact Email')); ?></label>						
					<input type="text" class="form-control" name="contact_email" value="<?php echo e(old('contact_email')); ?>">
				  </div>
				</div>
				
				<!--<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('VAT ID')); ?></label>						
					<input type="text" class="form-control" name="vat_id" value="<?php echo e(old('vat_id')); ?>">
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Reg No')); ?></label>						
					<input type="text" class="form-control" name="reg_no" value="<?php echo e(old('reg_no')); ?>">
				  </div>
				</div>-->

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Contact Phone')); ?></label>						
					<input type="text" class="form-control" name="contact_phone" value="<?php echo e(old('contact_phone')); ?>" required>
				  </div>
				</div>

				<div class="col-md-6" hidden="">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Country')); ?></label>						
					<select class="form-control select2" name="country">
					    <option value=""><?php echo e(_lang('Select Country')); ?></option>
						<?php echo e(get_country_list( old('country') )); ?>

					</select>
				  </div>
				</div>
				
				<div class="col-md-6 d-none">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Currency')); ?></label>						
					<select class="form-control" data-selected="<?php echo e(get_company_option('base_currency')); ?>" name="currency" id="currency" >
					   <option value=""><?php echo e(_lang('Select Currency')); ?></option>
						
						<option value="USD" selected>United States dollar - USD ($)</option>
					</select>
				  </div>
				</div>
				
				<div class="col-md-6">
				  <div class="form-group">
					<a href="<?php echo e(route('contact_groups.create')); ?>" data-reload="false" data-title="<?php echo e(_lang('Add Contact Group')); ?>" class="ajax-modal-2 select2-add"><i class="ti-plus"></i> <?php echo e(_lang('Add New')); ?></a>
					<label class="control-label"><?php echo e(_lang('Group')); ?></label>						
					<select class="form-control select2-ajax" data-value="id" data-display="name" data-table="contact_groups" data-where="1" name="group_id" required>
						<option value=""><?php echo e(_lang('- Select Group -')); ?></option>
					</select>
				 </div>
				</div>


				<div class="col-md-6">

					<div class="form-group">

						<label class="control-label"><?php echo e(_lang('TimeZone')); ?></label>

						<select class="form-control"  name="time_zone" id="time_zone" required>

							<option value=""><?php echo e(_lang('Select One')); ?></option>
							<?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timez): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($timez->id); ?>"><?php echo e($timez->name); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<!--<option value="Central">Central</option>
<option value="Mountain">Mountain</option>
<option value="Pacific">Pacific</option>
<option value="Hawaii-Aleutian">Hawaii-Aleutian</option>-->


						</select>

					</div>

				</div>
				<div class="col-md-6">

					<div class="form-group">

						<label class="control-label"><?php echo e(_lang('State')); ?></label>

						<select class="form-control select2"  name="zone_state" id="zone_state" required>

							<option value=""><?php echo e(_lang('Select One')); ?></option>


						</select>

					</div>

				</div>

				<!--<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Client IP')); ?></label>						
					<input type="text" class="form-control" name="client_ip" value="<?php echo e(old('client_ip')); ?>">
				  </div>
				</div>
				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('City')); ?></label>						
					<input type="text" class="form-control" name="city" value="<?php echo e(old('city')); ?>">
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('State')); ?></label>						
					<input type="text" class="form-control" name="state" value="<?php echo e(old('state')); ?>">
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Zip')); ?></label>						
					<input type="text" class="form-control" name="zip" value="<?php echo e(old('zip')); ?>">
				  </div>
				</div>-->

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Address')); ?></label>						
					<textarea class="form-control" name="address" required><?php echo e(old('address')); ?></textarea>
				  </div>
				</div>
				
				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Remarks')); ?></label>						
					<textarea class="form-control" name="remarks"><?php echo e(old('remarks')); ?></textarea>
				  </div>
				</div>

				<div class="col-md-12 d-none">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Facebook')); ?></label>						
					<input type="text" class="form-control" name="facebook" value="<?php echo e(old('facebook')); ?>">
				  </div>
				</div>

				<div class="col-md-12 d-none">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Twitter')); ?></label>						
					<input type="text" class="form-control" name="twitter" value="<?php echo e(old('twitter')); ?>">
				  </div>
				</div>

				<div class="col-md-12 d-none">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Linkedin')); ?></label>						
					<input type="text" class="form-control" name="linkedin" value="<?php echo e(old('linkedin')); ?>">
				  </div>
				</div>

				<div class="col-md-12 ">
				  <div class="form-group">
					<button type="reset" class="btn btn-danger"><?php echo e(_lang('Reset')); ?></button>
					<button type="submit" class="btn btn-primary"><?php echo e(_lang('Save')); ?></button>
				  </div>
				</div>
			</div>
		</div>
	  </div>
	 </div>
	 
	 <div class="col-md-4">

	 	<div class="card">
			<h5 class="card-header bg-dark text-white mt-0 text-center"><?php echo e(_lang('Client Portal Access')); ?></h5>
			<div class="card-body">
			    
			    <div class="alert alert-info">
			   	 	<span><?php echo e(_lang('If Client have already an account associated with Contact Email then client can login to his account using existing login details')); ?>.</span>
			   	</div> 
			   	
			   	<div class="alert alert-info">	
			    	<span><?php echo e(_lang('If Client do not have any previous account associated with Contact Email then client need to create a new account using that contact email')); ?>.</span>
			    </div>
			</div>
		</div>

		<div class="card">
			<div class="card-body">
			   <div class="col-md-12">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Contact Image')); ?> 300px X 300px</label>						
					<input type="file" class="form-control dropify" name="contact_image"  data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
				  </div>
				</div>
			</div>
		</div>

	  </div>
    </div>
 </form>
</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
	$(document).ready(function () {
		$('#time_zone').on('change', function () {
			var idCountry = this.value;
			$("#zone_state").html('');
			$.ajax({
				url: "<?php echo e(url('fetch-states')); ?>",
				type: "POST",
				data: {
					zone_id: idCountry,
					_token: '<?php echo e(csrf_token()); ?>'
				},
				dataType: 'json',
				success: function (result) {
					$('#zone_state').html('<option value="">Select State</option>');
					$.each(result.states, function (key, value) {
						$("#zone_state").append('<option value="' + value
								.name + '">' + value.name + '</option>');
					});
				}
			});
		});

	});

</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/backend/accounting/contacts/contact/create.blade.php ENDPATH**/ ?>