<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <a class="btn btn-primary btn-xs" href="<?php echo e(route('contacts.create')); ?>"><i class="ti-plus"></i>
                <?php echo e(_lang('Add New')); ?></a>

            <a class="btn btn-dark btn-xs" href="<?php echo e(route('contacts.import')); ?>"><i class="ti-import"></i>
                <?php echo e(_lang('Import')); ?></a>
            <?php if(Auth::user()->user_type == 'user'): ?>
                <a class="btn btn-success btn-xs disabled" href="#" id="lead-assign-btn" data-toggle="modal"
                    data-target="#exampleModal"><i class="ti-assign"></i>Lead Assign</a>
            <?php endif; ?>

            <div class="card mt-2">
                <span class="panel-title d-none"><?php echo e(_lang('List Contact')); ?></span>
                <div class="card-body">
                    <table id="contacts-table" class="table table-bordered">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="select-all"></th>
                                <th><?php echo e(_lang('Customer ID')); ?></th>
                                <th><?php echo e(_lang('Company Name')); ?></th> 
                                <th><?php echo e(_lang('Phone')); ?></th>
                                <th><?php echo e(_lang('Address')); ?></th>
                                <th><?php echo e(_lang('Contact Name')); ?></th>
                                <th><?php echo e(_lang('Assign')); ?></th>
                                <th><?php echo e(_lang('Current Assign')); ?></th>
                                <th class="text-center"><?php echo e(_lang('Action')); ?></th>

                            </tr>
                        </thead>

                        <thead>
 

                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>




<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Users List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php if(count($users) > 0): ?>
                <form id="assign_lead_id" action="<?php echo e(url('contacts/assign_lead')); ?>" method="post" autocomplete="off">
                    
                    <div class="modal-body">

                        <select name="user_id" id="user_id" class="form-control">
                            <option value="">Choose User</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>


<?php $__env->startSection('js-script'); ?>
    <script src="<?php echo e(URL::asset('/backend/assets/js/ajax-datatable/contacts.js')); ?>"></script>


    <script>
        // $(document).on("change", ".row-checkbox", function() {
        //     let anyChecked = $(".row-checkbox:checked").length > 0;

        //     if (anyChecked) {
        //         $("#lead-assign-btn").removeClass("disabled").removeAttr("disabled");
        //     } else {
        //         $("#lead-assign-btn").addClass("disabled").attr("disabled", true);
        //     }
        // });

        // $('#select-all').on('click', function() {
        //     var checked = this.checked;
        //     $('.row-checkbox').each(function() {
        //         this.checked = checked;
        //     });


        //     if (checked) {
        //         $("#lead-assign-btn").removeClass("disabled").removeAttr("disabled");
        //     } else {
        //         $("#lead-assign-btn").addClass("disabled").attr("disabled", true);
        //     }

        // });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/backend/accounting/contacts/contact/list.blade.php ENDPATH**/ ?>