<?php $__env->startSection('content'); ?>

    <?php if(Auth::user()->user_type == 'client'): ?>
        <style>
            #frame #sidepanel #bottom-bar button {
                width: 50% !important;
            }
        </style>
    <?php endif; ?>

    <link href="<?php echo e(URL::asset('/backend/assets/css/chat.css?v=1.2')); ?>" rel="stylesheet" type="text/css" />

    <!--Chat Box-->
    <div class="row">
        <!-- Panel 1 -->
        <div class="col-12">
            <span class="panel-title d-none"><?php echo e(_lang('Messenger')); ?></span>

            <div id="frame" class="chat-fullscreen">
                <div id="sidepanel">
                    <div id="profile">
                        <div class="wrap">
                            <img id="profile-img"
                                src="<?php echo e(Auth::user()->profile_picture != '' ? URL::asset('/uploads/profile/' . Auth::user()->profile_picture) : URL::asset('/images/avatar.png')); ?>"
                                class="online" alt="" />
                            <p id="profile-name"><?php echo e(Auth::user()->name); ?></p>
                        </div>
                    </div>
                    <div id="search">
                        <label for=""><i class="fa fa-search" aria-hidden="true"></i></label>
                        <input type="text" id="st" placeholder="<?php echo e(_lang('Search Contacts')); ?>" />
                    </div>
                    <?php
                        $chat_order = get_chat_order();
                        $group_chat_order = get_group_chat_order();
                    ?>

                    <div id="contacts" class="tab-content">
                        <div id="staff" class="tab-pane active">
                            <ul id="staff-list">
                                <?php $__currentLoopData = $staffs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="contact" id="user-<?php echo e($staff->id); ?>" data-id="<?php echo e($staff->id); ?>"
                                        data-order="<?php echo e(array_key_exists($staff->id, $chat_order) ? $chat_order[$staff->id] : $staff->id * 45); ?>">
                                        <div class="wrap">
                                            <span
                                                class="notifications <?php echo e($staff->unread_message_count > 0 ? 'show' : 'hidden'); ?>"><?php echo e($staff->unread_message_count); ?></span>
                                            <span class="contact-status offline"></span>
                                            <img src="<?php echo e($staff->profile_picture != '' ? URL::asset('/uploads/profile/' . $staff->profile_picture) : URL::asset('/images/avatar.png')); ?>"
                                                alt="" />
                                            <div class="meta">
                                                <p class="name"><?php echo e($staff->name); ?></p>
                                                <?php echo clean(get_last_message($staff->id)); ?>

                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <div id="groups" class="tab-pane">
                            <a href="<?php echo e(url('live_chat/create_group')); ?>" data-title="<?php echo e(_lang('Create Chat Group')); ?>"
                                class="btn-create-group btn-block ajax-modal"><?php echo e(_lang('Create New Group')); ?></a>

                            <ul id="group-list">
                                <?php $__currentLoopData = $chat_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="contact" id="group-<?php echo e($chat_group->id); ?>"
                                        data-group-id="<?php echo e($chat_group->id); ?>"
                                        data-admin-id="<?php echo e($chat_group->created_by); ?>"
                                        data-order="<?php echo e(array_key_exists($chat_group->id, $group_chat_order) ? $group_chat_order[$chat_group->id] : $chat_group->id * 45); ?>">
                                        <div class="wrap">
                                            <?php $msg_count = group_message_count($chat_group->id) ?>
                                            <span
                                                class="notifications <?php echo e($msg_count > 0 ? 'show' : 'hidden'); ?>"><?php echo e($msg_count); ?></span>
                                            <div class="group-img"><?php echo e(get_initials($chat_group->name)); ?></div>
                                            <div class="meta">
                                                <p class="name"><?php echo e($chat_group->name); ?></p>
                                                <p class="preview"><?php echo clean(get_last_group_message($chat_group->id)); ?></p>
                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <?php if(Auth::user()->user_type != 'client'): ?>
                            <div id="clients" class="tab-pane">
                                <ul id="clients-list">
                                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="contact" id="user-<?php echo e($client->id); ?>" data-id="<?php echo e($client->id); ?>"
                                            data-order="<?php echo e(array_key_exists($client->id, $chat_order) ? $chat_order[$client->id] : $client->id * 45); ?>">
                                            <div class="wrap">
                                                <span
                                                    class="notifications <?php echo e($client->unread_message_count > 0 ? 'show' : 'hidden'); ?>"><?php echo e($client->unread_message_count); ?></span>
                                                <span class="contact-status offline"></span>
                                                <img src="<?php echo e($client->profile_picture != '' ? URL::asset('/uploads/profile/' . $client->profile_picture) : URL::asset('/images/avatar.png')); ?>"
                                                    alt="" />
                                                <div class="meta">
                                                    <p class="name"><?php echo e($client->name); ?></p>
                                                    <?php echo clean(get_last_message($client->id)); ?>

                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div id="bottom-bar">
                        <button class="nav-link active" data-toggle="tab" data-target="#staff"><i class="fa fa-user"></i>
                            <span><?php echo e(_lang('Staff')); ?></span></button>
                        <button class="nav-link" data-toggle="tab" data-target="#groups"><i class="fa fa-users"></i>
                            <span><?php echo e(_lang('Group')); ?></span></button>
                        <?php if(Auth::user()->user_type != 'client'): ?>
                            <button class="nav-link" data-toggle="tab" data-target="#clients"><i
                                    class="fa fa-user-circle"></i> <span><?php echo e(_lang('Clients')); ?></span></button>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="content">
                    <div id="chat-preloader">
                        <i class="fas fa-circle-notch fa-pulse"></i>
                    </div>
                    <div class="contact-profile">
                        <img src="<?php echo e(URL::asset('/images/avatar.png')); ?>" alt="" />
                        <h5><?php echo e(_lang('Select Contact')); ?></h5>
                        <!--<div class="social-media">
          <i class="fab fa-facebook"></i>
          <i class="fab fa-twitter"></i>
          <i class="fab fa-instagram"></i>
         </div>-->
                        <button class="btn btn-dark btn-xs float-right" id="btn-fullscreen"><i
                                class="fa fa-search-minus"></i></button>
                        <div class="group-settings float-right">
                            <div class="dropdown">
                                <button class="btn-group-settings btn btn-primary btn-xs dropdown-toggle" type="button"
                                    data-toggle="dropdown"><i class="fas fa-users-cog"></i>
                                    <i class="fa fa-angle-down"></i></button>
                                <div class="dropdown-menu">
                                    <a href="" class="dropdown-item ajax-modal" id="btn-group-members"
                                        data-title="<?php echo e(_lang('Members')); ?>"><?php echo e(_lang('Group Members')); ?></a>
                                    <a href="" class="dropdown-item hidden"
                                        id="btn-left-group"><?php echo e(_lang('Left Group')); ?></a>
                                    <a href="" class="dropdown-item hidden ajax-modal" id="btn-edit-group"
                                        data-title="<?php echo e(_lang('Edit Group')); ?>"><?php echo e(_lang('Edit Group')); ?></a>
                                    <a href="" class="dropdown-item hidden"
                                        id="btn-remove-group"><?php echo e(_lang('Remove Group')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="messages">
                        
                        <ul>
                            <li class="select-chat-user">
                                <i class="typcn typcn-messages"></i><br>
                                <?php echo e(_lang('Welcome') . ', ' . Auth::user()->name); ?><br>
                                <?php echo e(_lang('Ready to Start Your Conversation')); ?>

                            </li>
                        </ul>
                    </div>
                    <div class="message-input">
                        <div class="wrap">
                            <form id="chat-form" method="post" autocomplete="off">
                                <input type="hidden" name="to" id="receiver">
                                <input type="hidden" name="group" id="group">
                                <input type="hidden" name="message_id" id="message_id">
                                <input type="text" name="message" id="message"
                                    placeholder="Write your message..." />

                                <input type="file" name="file" id="file" class="d-none"
                                    onchange="readFile(this);">
                                <span id="file_name"></span>
                                <button type="button" class="button btn-attachment"><i class="fa fa-paperclip"
                                        aria-hidden="true"></i></button>
                                <button type="submit" class="submit"><i class="fa fa-paper-plane"
                                        aria-hidden="true"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Panel 1 -->
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
    <script src="<?php echo e(URL::asset('/backend/assets/js/live_chat.js?v=1.0')); ?>" defer></script>

 
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Xampp8.0\htdocs\laravel\crmdehradun\resources\views/backend/live_chat/chat.blade.php ENDPATH**/ ?>