@extends('layouts.app')

@section('content')

@if (\Session::has('paypal_success'))
  <div class="alert alert-success text-center">
	<b>{{ \Session::get('paypal_success') }}</b>
  </div>
  <br>
@endif

@php 
$currency = currency(); 
$date_format = get_company_option('date_format','Y-m-d');
@endphp

<div class="row">
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg2">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Current Month Sale Credit') }}</span>
					</div>
					<h2>{{ decimalPlace($total_current_month_sale_credit, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg4">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Current Month Sale Refund') }}</span>
					</div>
					<h2>{{ decimalPlace($total_current_month_sale_refund, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg3">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Current Month Sale Dispute') }}</span>
					</div>
					<h2>{{ decimalPlace($total_current_month_sale_dispute, $currency) }}</h2>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 mb-4">
		<div class="card">
			<div class="seo-fact sbg1">
				<div class="p-4">
					<div class="seofct-icon">
						<span>{{ _lang('Total Current Month Gross Income') }}</span>
					</div>
					<h2>{{ decimalPlace($total_current_month_sale, $currency) }}</h2>
				</div>
			</div>
		</div>
		</div>


</div>


<div class="row d-flex align-items-stretch">
@if(Auth::user()->role_id == 8)
  <!-- Panel 1 -->
<!--  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		    <h4 class="header-title mt-0">{{ _lang('Recent new assigned lead') }}</h4>
		    <div class="table-responsive card-scroll">
			    <table class="table">
				    <thead>
					    <tr>
							<th>{{ _lang('Name') }}</th>
							<th>{{ _lang('Email') }}</th>
							<th>{{ _lang('Phone') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
						@foreach($new_leads as $key => $lead)
						    <tr>
								<td><a href="{{ action('LeadController@show', $lead->id) }}" data-title="{{ _lang('View Lead Details') }}" class="ajax-modal">{{ $lead->name }}</a></td>
								<td>{{ $lead->email }}</td>
								<td>{{ $lead->phone }}</td>
								<td>
							<form action="{{ action('LeadController@destroy', $lead['id']) }}" class="text-center" method="post">
								<a href="{{ action('LeadController@show', $lead['id']) }}" data-title="{{ _lang('View Lead Details') }}" class="btn btn-primary btn-xs"><i class="ti-eye"></i></a>
								<a href="{{ action('LeadController@edit', $lead['id']) }}" data-title="{{ _lang('Update Lead') }}" class="btn btn-warning btn-xs"><i class="ti-pencil"></i></a>
                                {{ csrf_field() }}
                            </form>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div>-->
  <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">Reminders</h4>
		   <div class="table-responsive">
			<table class="table table-bordered">
				<thead>
				  <tr>
					<th>Client</th>
					<th>Email</th>
					<th>Phone</th>
					<th>Note</th>
					<th>View</th>
				  </tr>
				</thead>
				<tbody>

				  @foreach($reminders as $key => $value)
				  @php
				  	$today = \Carbon\Carbon::now();
    				$td = $today->format('Y-m-d');
    				$re_date = date("Y-m-d", strtotime($value->date) );
				  @endphp
				  <tr id="row_{{ $value->id }}" class="@if($re_date >= $td) {{ 'alert alert-success' }} @else {{ 'alert alert-danger' }} @endif">
					<td class='account_title'>{{ client_name($value->lead_id) }}</td>
					<td class='account_number'>{{ client_email($value->lead_id) }}</td>
					<td class='opening_balance'>{{ client_phone($value->lead_id) }}</td>
					<td class='opening_balance'>{{ $value->description }}</td>
					<td class='opening_balance text-center'><a class="btn btn-primary btn-xs" href="{{ url('/') }}/leads/{{ $value->lead_id }}"><i class="ti-eye"></i></a></td>
				  </tr>
				  @endforeach
				</tbody>
			  </table>
            </div>
		</div>
	 </div>
  </div>
  @endif
  <!-- End Panel 1 -->

  <!-- Panel 2 -->
  @if(Auth::user()->role_id == 18 || Auth::user()->role_id == 19 || Auth::user()->role_id == 20 || Auth::user()->role_id == 21 || Auth::user()->role_id == 22 || Auth::user()->role_id == 23)
<div class="col-md-12">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">{{ _lang('Recent Tasks') }}</h4>
		   <div class="table-responsive card-scroll">
			   <table class="table">
				    <thead>
					    <tr>
							<th>{{ _lang('Name') }}</th>	
							<th>{{ _lang('Priority') }}</th>
							<th>{{ _lang('Status') }}</th>
							<th>{{ _lang('Deadline') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
						@foreach(Auth::user()->tasks->take(10) as $task)
						    <tr>
								<td><a href="{{ action('TaskController@show', $task->id) }}" data-title="{{ $task->title }}" class="ajax-modal">{{ $task->title }}</a></td>
								<td>{!! clean(task_priority($task->priority)) !!}</td>
								<td>
									<span class='badge badge-primary' style='background:{$task->status->color}'>{{ $task->status->title }}</span>
								</td>
								<td>{{ date($date_format,strtotime($task->end_date)) }}</td>
								<td>
									<form action="{{ action('TaskController@destroy', $task['id']) }}" class="text-center" method="post">
										<a href="{{ action('TaskController@edit', $task['id']) }}" data-title="'. _lang('Update Project') .'" class="btn btn-warning btn-xs ajax-modal"><i class="ti-pencil"></i></a>
										{{ csrf_field() }}
										<input name="_method" type="hidden" value="DELETE">
										<button class="btn btn-danger btn-xs btn-remove" type="submit"><i class="ti-eraser"></i></button>
									</form>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div>
@endif
  
  <!-- End Panel 2 -->

</div>

<div class="row mt-4 d-flex align-items-stretch">
  <!-- Panel 3 -->
  <!-- <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">{{ _lang('Income vs Expense')." - ".date('M, Y') }}</h4>
		   <div id="dn_income_expense"></div>
		</div>
	 </div>
  </div> -->

@if(Auth::user()->role_id == 8)  
<div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		   <h4 class="header-title mt-0">{{ _lang('Hot Prospect') }}</h4>
		   <div class="table-responsive card-scroll">
			   <table class="table">
				    <thead>
					    <tr>
							<th>{{ _lang('Name') }}</th>
							<th>{{ _lang('Email') }}</th>
							<th>{{ _lang('Phone') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
						@foreach($leads as $key => $lead)
						    <tr>
								<td><a href="{{ action('LeadController@show', $lead->id) }}" data-title="{{ _lang('View Lead Details') }}" class="ajax-modal">{{ $lead->name }}</a></td>
								<td>{{ $lead->email }}</td>
								<td>{{ $lead->phone }}</td>
								<td>
							<form action="{{ action('LeadController@destroy', $lead['id']) }}" class="text-center" method="post">
								<a href="{{ action('LeadController@show', $lead['id']) }}" data-title="{{ _lang('View Lead Details') }}" class="btn btn-primary btn-xs"><i class="ti-eye"></i></a>
								<a href="{{ action('LeadController@edit', $lead['id']) }}" data-title="{{ _lang('Update Lead') }}" class="btn btn-warning btn-xs"><i class="ti-pencil"></i></a>
                                {{ csrf_field() }}
                            </form>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	 </div>
  </div>

<div class="col-md-6">
	<div class="card h-100">
		<div class="card-body">
		  	<h4 class="header-title mt-0">Employee of the month</h4>
		  	<div class="table-responsive">
				<table class="table table-bordered">
					<thead>
					  <tr>
						<th>Name</th>
						<th>Email</th>
						<th>Score</th>
					  </tr>
					</thead>
					@if($user == 'no')
					<tbody>
						<tr id="row_1">
						<td>No record found!</td>
					  	</tr>
					</tbody>
					@else
					<tbody>
					  @foreach($user as $key => $value)
					  <tr id="row_{{ $value['id'] }}" class="alert alert-success">
						<td class='account_title'>{{ $value['name'] }}</td>
						<td class='account_number'>{{ $value['email'] }}</td>
						<td class='opening_balance text-right'>{{ round($percentage) }}%</td>
					  </tr>
					  @endforeach
					</tbody>
					@endif
				</table>
            </div>
		</div>
	</div>
</div>
@endif


  <!-- <div class="col-md-6">
	 <div class="card h-100">
		<div class="card-body">
		  <h4 class="header-title mt-0">{{ _lang('Financial Balance Status') }}</h4>
		  <div class="table-responsive">
			<table class="table table-bordered">
				<thead>
				  <tr>
					<th>{{ _lang('A/C') }}</th>
					<th>{{ _lang('A/C Number') }}</th>
					<th class="text-right">{{ _lang('Balance') }}</th>
				  </tr>
				</thead>
				<tbody>
				  @foreach(get_financial_balance() as $account)
				  <tr id="row_{{ $account->id }}">
					<td class='account_title'>{{ $account->account_title.' ('.$account->account_currency.')' }}</td>
					<td class='account_number'>{{ $account->account_number }}</td>
					<td class='opening_balance text-right'>{{ decimalPlace($account->balance, currency($account->account_currency)) }}</td>
				  </tr>
				  @endforeach
				</tbody>
			  </table>
            </div>
		</div>
	 </div>
  </div> -->
  <!-- End Panel 4 -->
</div>
@endsection

@section('js-script')
<script src="{{ URL::asset('/backend/assets/js/dashboard.js?v=1.1') }}"></script>
<script type="text/javascript">
 $(function () {
 $('[data-toggle="tooltip"]').tooltip()
})
</script>
@endsection
