@extends('layouts.app')

@section('content')
    @if((Auth::user()->id == $lead->created_user_id) || (Auth::user()->id == $lead->assigned_user_id) || (Auth::user()->user_type == 'user') || (Auth::user()->role_id == 17))
        <style>
            #main_modal .modal-lg {
                max-width: 900px;
            }

            #main_modal .modal-body {
                overflow: visible !important;
            }
        </style>
        <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <span class="panel-title d-none">{{ _lang('View Lead Details') }}</span>

                    @php $date_format = get_company_option('date_format','Y-m-d'); @endphp
                    @php $time_format = get_company_option('time_format',24) == '24' ? 'H:i' : 'h:i A'; @endphp
                    @php $currency = currency() @endphp

                    <div class="card-body">
                        <ul class="nav nav-tabs" id="leads-tab">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#lead_details">{{ _lang('Lead Details') }}</a>
                            </li>

                            <!--<li class="nav-item">
				    <a class="nav-link" data-toggle="tab" href="#quotations">{{ _lang('Quotation') }}</a>
				  </li>
				  <li class="nav-item">
				    <a class="nav-link" data-toggle="tab" href="#files">{{ _lang('Files') }}</a>
				  </li>-->


                            <!--<li class="nav-item">
				    <a class="nav-link" data-toggle="tab" href="#notes">{{ _lang('Notes') }}</a>
				  </li>
				  <li class="nav-item">
				    <a class="nav-link" data-toggle="tab" href="#card">{{ _lang('Card Details') }}</a>
				  </li>-->

                            @if(Auth::user()->user_type == 'user' || (Auth::user()->role_id == 8))
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#history">{{ _lang('History') }}</a>
                                </li>
                                <!--  <li class="nav-item">
				    <a class="nav-link" data-toggle="tab" href="#activity_log">{{ _lang('Activity Log') }}</a>
				  </li>-->
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#reminder">{{ _lang('Set Reminder') }}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ action('LeadController@edit', $lead->id) }}" data-title="{{ _lang('Update Lead') }}">{{ _lang('Edit') }}</a>
                                </li>
                            @endif
                        </ul>
                        <div class="tab-content mt-4">
                            <div class="tab-pane active" id="lead_details">
                                <input type="hidden" id="lead_id" value="{{ $lead->id }}">
                                <table class="table table-bordered">
                                    <tr>
                                        <td>{{ _lang('Name') }}</td>
                                        <td>
									<span class="float-left pt-1">{{ $lead->id.'# -'}}
									
    									<span class="data-name-span">{{$lead->name }}</span>
    									
    									<input type="text" name="name" value="{{ $lead->name }}"  class="data-name-edit" style="display:none;"/> 
									
									</span>
                                            <button class="edit-class-name edit-button btn btn-info" data-hider=".data-name-span" data-buttonshowwer=".save-name-button" data-shower=".data-name-edit" >Edit</button>
                                            <button class="btn btn-info save-name-button save-button" style="display:none;"  data-shower=".data-name-span" data-required="1"  data-hider=".data-name-edit"  data-buttonshowwer=".edit-class-name"  data-setter=".data-name-span" data-getter=".data-name-edit">Save</button>
                                            @if($lead->converted_lead!=1)
                                            <a href="{{ action('LeadController@convert_to_customer', $lead->id) }}" class="btn btn-info btn-xs float-right"><i class="fas fa-user-tie"></i> {{ _lang('Convert to Customer') }}</a>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>{{ _lang('Company Name') }}</td>
                                        <td>
                                            <span class="data-company_name-span">{{$lead->company_name }}</span>

                                            <input type="text" name="company_name" value="{{ $lead->company_name }}"  class="data-company_name-edit" style="display:none;"/>
                                            <button class="edit-class-company_name edit-button btn btn-info" data-hider=".data-company_name-span" data-buttonshowwer=".save-company_name-button" data-shower=".data-company_name-edit" >Edit</button>
                                            <button class="btn btn-info save-company_name-button save-button" style="display:none;"  data-shower=".data-company_name-span" data-required="1"  data-hider=".data-company_name-edit"  data-buttonshowwer=".edit-class-company_name"  data-setter=".data-company_name-span" data-getter=".data-company_name-edit">Save</button>

                                        </td>
                                    </tr>
                                    <tr><td>{{ _lang('Email') }}</td>
                                        <td>
                                            <span class="data-email-span">{{$lead->email }}</span>

                                            <!--<input type="text" name="email" value="{{ $lead->email }}"  class="data-email-edit" style="display:none;"/>
							    <button class="edit-class-email edit-button btn btn-info" data-hider=".data-email-span" data-buttonshowwer=".save-email-button" data-shower=".data-email-edit" >Edit</button> 
									<button class="btn btn-info save-email-button save-button" style="display:none;"  data-shower=".data-email-span" data-required="1"  data-hider=".data-email-edit"  data-buttonshowwer=".edit-class-email"  data-setter=".data-email-span" data-getter=".data-email-edit">Save</button>-->

                                        </td>
                                    </tr>
                                    <tr><td>{{ _lang('Secondary Email') }}</td><td>
                                            <span class="data-secondary_email-span">{{$lead->secondary_email }}</span>

                                            <input type="text" name="secondary_email" value="{{ $lead->secondary_email }}"  class="data-secondary_email-edit" style="display:none;"/>
                                            <button class="edit-class-secondary_email edit-button btn btn-info" data-hider=".data-secondary_phone-span" data-buttonshowwer=".save-secondary_email-button" data-shower=".data-secondary_email-edit" >Edit</button>
                                            <button class="btn btn-info save-secondary_email-button save-button" style="display:none;"  data-shower=".data-secondary_email-span" data-required="1"  data-hider=".data-secondary_email-edit"  data-buttonshowwer=".edit-class-secondary_email"  data-setter=".data-secondary_email-span" data-getter=".data-secondary_email-edit">Save</button>

                                        </td></tr>
                                    <tr><td>{{ _lang('Phone') }}</td><td>
                                            <span class="data-phone-span">{{$lead->phone }}</span>

                                            <!--<input type="text" name="phone" value="{{ $lead->phone }}"  class="data-phone-edit" style="display:none;"/>
							    <button class="edit-class-phone edit-button btn btn-info" data-hider=".data-phone-span" data-buttonshowwer=".save-phone-button" data-shower=".data-phone-edit" >Edit</button> 
									<button class="btn btn-info save-phone-button save-button" style="display:none;"  data-shower=".data-phone-span" data-required="1"  data-hider=".data-phone-edit"  data-buttonshowwer=".edit-class-phone"  data-setter=".data-phone-span" data-getter=".data-phone-edit">Save</button>-->

                                        </td></tr>
                                    <tr><td>{{ _lang('Secondary Phone') }}</td><td>
                                            <span class="data-secondary_phone-span">{{$lead->secondary_phone }}</span>

                                            <input type="text" name="secondary_phone" value="{{ $lead->secondary_phone }}"  class="data-secondary_phone-edit" style="display:none;"/>
                                            <button class="edit-class-secondary_phone edit-button btn btn-info" data-hider=".data-secondary_phone-span" data-buttonshowwer=".save-secondary_phone-button" data-shower=".data-secondary_phone-edit" >Edit</button>
                                            <button class="btn btn-info save-secondary_phone-button save-button" style="display:none;"  data-shower=".data-secondary_phone-span" data-required="1"  data-hider=".data-secondary_phone-edit"  data-buttonshowwer=".edit-class-secondary_phone"  data-setter=".data-secondary_phone-span" data-getter=".data-secondary_phone-edit">Save</button>

                                        </td></tr>
                                    <tr><td>{{ _lang('Website') }}</td><td>
                                            <span class="data-website-span">{{$lead->website }}</span>

                                            <input type="text" name="website" value="{{ $lead->website }}"  class="data-website-edit" style="display:none;"/>
                                            <button class="edit-class-website edit-button btn btn-info" data-hider=".data-website-span" data-buttonshowwer=".save-website-button" data-shower=".data-website-edit" >Edit</button>
                                            <button class="btn btn-info save-website-button save-button" style="display:none;"  data-shower=".data-website-span" data-required="1"  data-hider=".data-website-edit"  data-buttonshowwer=".edit-class-website"  data-setter=".data-website-span" data-getter=".data-website-edit">Save</button>

                                        </td></tr>
                                    <tr>
                                        <td>{{ _lang('Lead Status') }}</td>
                                        <td><span class='badge badge-primary' style="background:{{ $lead->lead_status->color }}">{{ $lead->lead_status->title }}</span></td>
                                    </tr>

                                    <!--	<tr><td>{{ _lang('Lead Type') }}</td><td>{{ $lead->lead_type }}</td></tr>
							<tr><td>{{ _lang('Project Type') }}</td><td>{{ $lead->project_type }}</td></tr>-->
                                    <tr><td>{{ _lang('Assigned ') }}</td><td>{{ $lead->assigned_user->name }}</td></tr>
                                    <!--	<tr><td>{{ _lang('Country') }}</td><td>{{ $lead->country }}</td></tr>-->
                                    <tr><td>{{ _lang('TimeZone') }}</td><td>{{ $lead->zonename->name??'' }}</td></tr>
                                    <tr><td>{{ _lang('State') }}</td><td>{{ $lead->zone_state }}</td></tr>
                                    <!--<tr><td>{{ _lang('Lead Source') }}</td><td>{{ $lead->lead_source->title }}</td></tr>
							
							<tr><td>{{ _lang('Contact Date') }}</td><td>{{ date($date_format, strtotime($lead->contact_date)) }}</td></tr>
							
							<tr><td>{{ _lang('LinkedIn') }}</td><td>{{ $lead->linkedin }}</td></tr>
							
							<tr><td>{{ _lang('City') }}</td><td>{{ $lead->city }}</td></tr>
							<tr><td>{{ _lang('State') }}</td><td>{{ $lead->state }}</td></tr>
							<tr><td>{{ _lang('Zip') }}</td><td>{{ $lead->zip }}</td></tr>-->
                                    <tr><td>{{ _lang('Address') }}</td><td>{!! $lead->address !!}</td></tr>
                                    @if((Auth::user()->id == $lead->assigned_user_id) || (Auth::user()->user_type == 'user') || (Auth::user()->role_id == 17))
                                        <!--<tr><td>{{ _lang('Sales Team Notes') }}</td><td><table id="notes_table" class="table">
								<tbody>
								    @foreach($notes as $note)
                                            <tr data-id="row_{{ $note->id }}">
										<td class='created'>
											<small>
												<a href="{{action('StaffController@show', $note->user->id??'0')}}" data-title="{{ _lang('View Staf Information') }}"class="ajax-modal-2">{{ $note->user->name }}</a>
												({{ date("$date_format $time_format", strtotime($note->created_at)) }})<br>
												{{ $note->note }}
                                            </small>
                                        </td>
                                        <td class="action wp-100">
                                            <a href="{{ url('leads/delete_note/'.$note->id) }}" class="note-remove ajax-get-remove"><i class="far fa-trash-alt text-danger"></i></a>
										</td>
								    </tr>
								    @endforeach

                                        <tr data-id="notes_id">
                                            <td class='created'></td>
                                            <td class="action wp-100"></td>
                                        </tr>
                                    </tbody>
                                </table></td></tr>-->
                                    @endif
                                    <tr><td>{{ _lang('Created') }}</td><td>{{ date($date_format, strtotime($lead->created_at)) }}</td></tr>
                                </table>
                            </div>

                            <div class="tab-pane" id="history">
                                <form method="post" autocomplete="off" action="{{ route('leads.create_note') }}">
                                    {{ csrf_field() }}

                                    <input type="hidden" name="related_id" value="{{ $lead->id }}" required>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="email">Note</label>
                                                <textarea class="form-control" name="note">{{ old('note') }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-3">

                                            <div class="form-group">

                                                <label class="control-label">{{ _lang('Lead Status') }}</label>

                                                <select id="lead_status_id" class="form-control select2-ajax" data-value="id" data-display="title" data-table="lead_statuses" data-where="1" name="lead_status_id">

                                                    <option value="">{{ _lang('Select One') }}</option>

                                                    {{ create_option('lead_statuses', 'id', 'title', $lead->lead_status_id,array("company_id="=>company_id())) }}
                                                    <option value="16" @if($lead->lead_status_id == 16) {{ 'selected' }} @endif>Open</option>
                                                </select>

                                            </div>

                                        </div>
                                        <div class="col-md-3" id="not_interested" <?php if ($lead->lead_status_id == 28 || $lead->lead_status_id == 27) { echo 'style="display: none;"';}else{ echo 'style="display: block;"'; } ?>>

                                            <div class="form-group">

                                                <label class="control-label">{{ _lang('Why not Interested') }}</label>

                                                <select class="form-control " name="not_interested">
                                                    <option value="">{{ _lang('Select One') }}</option>
                                                    <option @if($lead->not_interested == 1) {{ 'selected' }} @endif value="1">Budget Issue</option>
                                                    <option @if($lead->not_interested == 2) {{ 'selected' }} @endif value="2">Proceed with a different vendor</option>
                                                    <option @if($lead->not_interested == 3) {{ 'selected' }} @endif value="3">Project on Hold</option>
                                                </select>

                                            </div>

                                        </div>
                                        <!--<div class="col-md-3"  id="status_date" <?php if ($lead->lead_status_id == 33 || $lead->lead_status_id == 28 || $lead->lead_status_id == 27) { echo 'style="display: none;"';}else{ echo 'style="display: block;"'; } ?>>-->
                                        <div class="col-md-3"  id="status_date">
                                            <div class="form-group">

                                                <label class="control-label">{{ _lang('Date For Next Follow Up') }}</label>

                                                <input type="text" class="form-control datepicker" name="status_date" value="{{ $lead->status_date }}">

                                            </div>

                                        </div>
                                        <div class="col-md-3"  id="status_time">
                                            <div class="form-group">

                                                <label class="control-label">{{ _lang('Time For Next Follow Up') }}</label>

                                                <input type="time" class="form-control" name="status_time" value="{{ $lead->status_time }}">

                                            </div>

                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">{{ _lang('Tag Member') }}</label>
                                                <input type="text" class="form-control" name="members" value="">
                                                <!--<select class="form-control select2" name="members[]" id="members" multiple="true">
			{{ create_option_sales('users','id','name','',array('company_id=' => company_id())) }}
                                                </select>-->
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-info">Submit</button>
                                </form>
                                <div class="crm-scroll">
                                    <table id="notes_table" class="table">
                                        <tbody>
                                        @foreach($notes as $note)
                                            <tr data-id="row_{{ $note->id }}">
                                                <td class='created'>
                                                    <small>
                                                        <a href="{{action('StaffController@show', $note->user->id??'0')}}" data-title="{{ _lang('View Staf Information') }}"class="ajax-modal-2">{{ $note->user->name }}</a>
                                                        ({{ date("$date_format $time_format", strtotime($note->created_at)) }})<br>
                                                        {!! $note->note !!}
                                                    </small>
                                                </td>
                                                <td class="action wp-100">
                                                    <a href="{{ url('leads/delete_note/'.$note->id) }}" class="note-remove ajax-get-remove"><i class="far fa-trash-alt text-danger"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach

                                        <tr data-id="notes_id">
                                            <td class='created'></td>
                                            <td class="action wp-100"></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="tab-pane" id="quotations">
                                <a href="{{ route('quotations.create') }}?related_to=leads&lead_id={{ $lead->id }}" class="btn btn-info btn-xs mb-4"><i class="ti-plus"></i> {{ _lang('Create New') }}</a>
                                <table id="quotation-table" class="table table-bordered data-table">
                                    <thead>
                                    <tr>
                                        <th>{{ _lang('Quotation Number') }}</th>
                                        <th>{{ _lang('Quotation To') }}</th>
                                        <th>{{ _lang('Quotation Date') }}</th>
                                        <th class="text-right">{{ _lang('Grand Total') }}</th>
                                        <th class="text-center">{{ _lang('Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($quotations as $quotation)
                                        @php $lead_currency = currency($quotation->lead->currency); @endphp
                                        <tr>
                                            <td>{{ $quotation->quotation_number }}</td>
                                            <td>{{ $quotation->lead->name }}</td>
                                            <td>{{ date($date_format, strtotime($quotation->quotation_date)) }}</td>
                                            <td class="text-right">
                                                @if($lead_currency != $currency)
                                                    <span>{{ decimalPlace($quotation->grand_total, $currency) }}</span><br>
                                                    <span><b>{{ decimalPlace($quotation->converted_total, $currency) }}</b></span>
                                                @else
                                                    <span>{{ decimalPlace($quotation->grand_total, $currency) }}</span>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <div class="dropdown">
                                                    <button class="btn btn-primary btn-xs dropdown-toggle" type="button" data-toggle="dropdown">{{ _lang('Action') }}
                                                        <i class="fas fa-angle-down"></i></button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="{{ action('QuotationController@edit', $quotation->id) }}"><i class="fas fa-edit"></i> {{ _lang('Edit') }}</a></li>
                                                        <a class="dropdown-item" href="{{ action('QuotationController@show', $quotation->id) }}"><i class="fas fa-eye"></i> {{ _lang('View') }}</a></li>

                                                        <form action="{{ action('QuotationController@destroy', $quotation['id']) }}" method="post">
                                                            {{ csrf_field() }}
                                                            <input name="_method" type="hidden" value="DELETE">
                                                            <button class="button-link btn-remove" type="submit"><i class="fas fa-recycle"></i> {{ _lang('Delete') }}</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane" id="files">
                                <form method="post" class="ajax-screen-submit" autocomplete="off" action="{{ route('leads.upload_file') }}" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <input type="hidden" name="related_id" value="{{ $lead->id }}" required>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label">{{ _lang('Upload File') }}</label>
                                                <input type="file" class="form-control dropify" name="file" required>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">{{ _lang('UPLOAD NOW') }}</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                <table id="files_table" class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th>{{ _lang('Upload Date') }}</th>
                                        <th>{{ _lang('Uploaded') }}</th>
                                        <th>{{ _lang('File') }}</th>
                                        <th class="text-center">{{ _lang('Remove') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($projectfiles as $projectfile)
                                        <tr data-id="row_{{ $projectfile->id }}">
                                            <td class="created_at">{{ date("$date_format $time_format", strtotime($projectfile->created_at)) }}</td>
                                            <td class='user_id'><a href="{{action('StaffController@show', $projectfile->user->id??'0')}}" data-title="{{ _lang('View Staf Information') }}"class="ajax-modal-2">{{ $projectfile->user->name }}</a></td>
                                            <td class='file'><a href="{{ url('leads/download_file/'.$projectfile->file) }}">{{ $projectfile->file }}</a></td>
                                            <td class="remove text-center"><a class="ajax-get-remove" href="{{ url('leads/delete_file/'.$projectfile->id) }}">{{ _lang('Remove') }}</a></td>
                                        </tr>
                                    @endforeach
                                    <tr data-id="files_id">
                                        <td class="created_at"></td>
                                        <td class="user_id"></td>
                                        <td class='file'></td>
                                        <td class="remove text-center"></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane" id="notes">
                                <form method="post" class="ajax-screen-submit" autocomplete="off" action="{{ route('leads.create_note') }}">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <input type="hidden" name="related_id" value="{{ $lead->id }}" required>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label">{{ _lang('Note') }}</label>
                                                <textarea class="form-control" name="note" required>{{ old('note') }}</textarea>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">{{ _lang('ADD NOTE') }}</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                                <div class="crm-scroll">
                                    <table id="notes_table" class="table">
                                        <tbody>
                                        @foreach($notes as $note)
                                            <tr data-id="row_{{ $note->id }}">
                                                <td class='created'>
                                                    <small>
                                                        <a href="{{action('StaffController@show', $note->user->id??'0')}}" data-title="{{ _lang('View Staf Information') }}"class="ajax-modal-2">{{ $note->user->name }}</a>
                                                        ({{ date("$date_format $time_format", strtotime($note->created_at)) }})<br>
                                                        {{ $note->note }}
                                                    </small>
                                                </td>
                                                <td class="action wp-100">
                                                    <a href="{{ url('leads/delete_note/'.$note->id) }}" class="note-remove ajax-get-remove"><i class="far fa-trash-alt text-danger"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach

                                        <tr data-id="notes_id">
                                            <td class='created'></td>
                                            <td class="action wp-100"></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="tab-pane" id="activity_log">

                                <div class="crm-scroll">
                                    <table id="activity_log_table" class="table table-bordered">
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="tab-pane" id="reminder">

                                <form method="POST" action="{{ url('lead/reminder') }}" accept-charset="UTF-8" style="display:inline">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <input type="hidden" name="lead_id" value="{{ $lead->id }}">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label">Select Date:</label>
                                                <input type='text' name="date" class="form-control" id='datetimepicker1' />
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label">Note:</label>
                                                <input type='text' name="description" class="form-control" id='description' />
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary btn-sm" title="Delete contact">Set Reminder</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                            <div class="tab-pane" id="card">

                                <form method="POST" action="{{ url('lead/save_card') }}" accept-charset="UTF-8" style="display:inline">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <input type="hidden" name="lead_id" value="{{ $lead->id }}">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">Card Number:</label>
                                                <input type='text' name="c_number" class="form-control" id='cc_number' value="{{ $card ? $card[0]['c_number'] : '' }}" />
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">Card Expiry Month:</label>
                                                <input type='text' name="c_exp_month" class="form-control" id='c_exp_month'  value="{{ $card ? $card[0]['c_exp_month'] : '' }}" />
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">Card Expiry Year:</label>
                                                <input type='text' name="c_exp_year" class="form-control" id='cc_number' value="{{ $card ? $card[0]['c_exp_year'] : '' }}" />
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">Card CVV:</label>
                                                <input type='text' name="c_cvv" class="form-control" id='c_cvv' value="{{ $card ? $card[0]['c_cvv'] : '' }}" />
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label">Name On Card:</label>
                                                <input type='text' name="c_name" class="form-control" id='c_name' value="{{ $card ? $card[0]['c_name'] : '' }}" />
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary btn-sm" title="Delete contact">Submit Details</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-danger">
                    <strong>Danger!</strong> You don't have right to access this page.
                </div>
            </div>

        </div>
    @endif
@endsection

@section('js-script')
    <script>
        $('#lead_status_id').change(function(){
            var status_id = $(this).val();
            var arr = new Array(33, 28, 27);
            console.log($.inArray(status_id, arr));
            if (status_id == 33 || status_id == 28 || status_id == 27)
            {
                if(status_id == 33){
                    $('#not_interested').css('display', 'block');
                    $('#status_date').css('display', 'none');
                    $('#status_date input').prop('required',false);
                    return false;
                }
                $('#status_date').css('display', 'none');
                $('#status_date input').prop('required',false);
                return false;
            }else{
                $('#not_interested').css('display', 'none');
                $('#status_date').css('display', 'block');
                $('#status_date input').prop('required',true);
                console.log(status_id);
            }
        })
    </script>
    <script>
        (function($) {
            "use strict";


            $(document).on("click",".edit-button",function(){
                $($(this).data("hider")).hide();
                $($(this).data("shower")).show();
                $($(this).data("buttonshowwer")).show();
                $(this).hide();
            });
            $(document).on("click",".save-button",function(){
                var flag=1;
                if($(this).data("required")=="1"){
                    var  val=$($(this).data("getter")).val();
                    if(val!=""){
                        $($(this).data("setter")).html($($(this).data("getter")).val());
                        //Please do ajax
                        var data={_token:"{{ csrf_token() }}",field:$($(this).data("getter")).attr("name"),value:$($(this).data("getter")).val()};
                        var url="{{ route('update-field-wise-lead',$lead->id) }}";
                        $.post(url,data,function(){});
                    }else{
                        flag=0;
                        alert("Please fill this field");
                        $($(this).data("getter")).focus();
                    }
                }else{
                    $($(this).data("setter")).html($($(this).data("getter")).val());
                    //Please do ajax
                    var data={_token:"{{ csrf_token() }}",field:$($(this).data("getter")).attr("name"),value:$($(this).data("getter")).val()};
                    var url="{{ route('update-field-wise-lead',$lead->id) }}";
                    $.post(url,data,function(){});
                }
                if(flag==1){
                    $($(this).data("hider")).hide();
                    $($(this).data("shower")).show();
                    $($(this).data("buttonshowwer")).show();
                    $(this).hide();
                }

            });
            $('#leads-tab a').on('shown.bs.tab', function(event){
                var tab = $(event.target).attr("href");
                if(tab == '#activity_log'){
                    $.ajax({
                        url: "{{ url('leads/get_logs_data/'.$lead->id) }}",
                        beforeSend: function(){
                            $("#preloader").fadeIn();
                        },success: function(data){
                            $("#preloader").fadeOut();
                            var json = JSON.parse(data);
                            var rows = '';

                            $.each(json, function(index, element) {
                                rows += `<tr id="row_${element.id}">
										<td class='created'>
											<small>
												${element.created_at}<br>
												${element.created_by.name} - ${element.activity}
											</small>
										</td>	
								    </tr>`;

                            });

                            $("#activity_log_table tbody").html(rows);

                        }
                    });
                }
            });

        })(jQuery);
    </script>
    <!-- css added by kapil -->
    <link rel="stylesheet" href="{{ URL::asset('/backend/assets/css/bootstrap-datetimepicker.min.css') }}">
    <script src="{{ URL::asset('/backend/assets/js/bootstrap-datetimepicker.min.js') }}"></script>

    <!-- css added by kapil -->

    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({format: 'YYYY-MM-DD HH:mm:ss'});
        });
    </script>
    <script>
        CKEDITOR.replace( 'note' );
    </script>

@endsection
