@extends('layouts.app')

@section('content')

<div class="row">
	<div class="col-lg-12">
		
		<div class="card mt-2">
		    
			<span class="panel-title d-none">{{ _lang('Lead List') }}</span>
				
			<div class="card-body">
                

                <hr>

				<table id="leads_table" class="table table-striped">
					<thead>
					  <tr>
					      <th>ID</th>
					       <th>{{ _lang('Company Name') }}</th>
						<th>{{ _lang('Name') }}</th>
						<th>{{ _lang('Email') }}</th>
						<th>{{ _lang('Phone') }}</th>
						
						<th>{{ _lang('Sales Person ') }}</th>
						<th>{{ _lang('TimeZone') }}</th>
						<th>{{ _lang('State') }}</th>
						
						<th>{{ _lang('Assigned Date ') }}</th>
						<th class="text-center">{{ _lang('Action') }}</th>
					  </tr>
					</thead>
					<tbody>  
					    
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

@endsection

@section('js-script')
<!--<script src="{{ URL::asset('/backend/assets/js/ajax-datatable/leads.js') }}"></script>-->
<script>
    (function($) {

	"use strict";

	

	 var leads_table = $('#leads_table').DataTable({

		processing: true,

		serverSide: true,

		ajax: ({

			url : "{{ url()->current() }}",

			method: "POST",

			data: function (d) {
			    

				d._token =  $('meta[name="csrf-token"]').attr('content');

                

                if($('select[name=assigned_user_id]').val() != ''){

	                d.assigned_user_id = $('select[name=assigned_user_id]').val();

	            }
                
                if($('.search-filter').val() != ''){

	                d.keyword = $('.search-filter').val();

	            }
	            
	            if($('.search-email').val() != ''){

	                d.email = $('.search-email').val();

	            }
                

                if($('select[name=lead_status_id]').val() != null){

                	d.lead_status_id = JSON.stringify($('select[name=lead_status_id]').val());

                }



                if($('select[name=lead_source_id]').val() != ''){

	                d.lead_source_id = $('select[name=lead_source_id]').val();

	            }



                if($('select[name=country]').val() != ''){

	                d.country = $('select[name=country]').val();

	            }
	            
	            if($('select[name=project_type]').val() != ''){

	                d.project_type = $('select[name=project_type]').val();

	            }

            },

			 error: function (request, status, error) {

				console.log(request.responseText);

			 }

		}),
		@if(Auth::user()->user_type == 'user' || Auth::user()->role_id == 17 || Auth::user()->role_id == 8)
		"columns" : [
		    
		    { data : 'id', name : 'id' },
		    { data : 'company_name', name : 'company_name' },

			{ data : 'name', name : 'name' },

			{ data : 'email', name : 'email' },

			{ data : 'phone', name : 'phone' },
			
			{ data : 'assigned_date', name : 'assigned_date' },

			{ data : "action", name : "action" },

		],
		@else
		"columns" : [
		    
		    { data : 'id', name : 'id' },

			{ data : 'name', name : 'name' },

			{ data : 'email', name : 'email' },

			{ data : 'phone', name : 'phone' },
			
			{ data : 'assigned_user.name', name : 'assigned_user.name' },
			{ data : 'zonename.name', name : 'zonename.name' },
			{ data : 'zone_state', name : 'zone_state' },
			
			
			{ data : 'assigned_date', name : 'assigned_date' },
			{ data : "action", name : "action" },

		],
		@endif
		responsive: true,

		"bStateSave": true,

		"bAutoWidth":false,	

		"ordering": false,

		"searching": false,

		"language": {

		   "decimal":        "",

		   "emptyTable":     $lang_no_data_found,

		   "info":           $lang_showing + " _START_ " + $lang_to + " _END_ " + $lang_of + " _TOTAL_ " + $lang_entries,

		   "infoEmpty":      $lang_showing_0_to_0_of_0_entries,

		   "infoFiltered":   "(filtered from _MAX_ total entries)",

		   "infoPostFix":    "",

		   "thousands":      ",",

		   "lengthMenu":     $lang_show + " _MENU_ " + $lang_entries,

		   "loadingRecords": $lang_loading,

		   "processing":     $lang_processing,

		   "search":         $lang_search,

		   "zeroRecords":    $lang_no_matching_records_found,

		   "paginate": {

			  "first":      $lang_first,

			  "last":       $lang_last,

			  "next":       $lang_next,

			  "previous":   $lang_previous

		   }

		}

	});

	

	$('.select-filter').on('change', function(e) {

        leads_table.draw();

    });
    
    $(".search-filter").keyup(function(){

        leads_table.draw();

    });
    
    $(".search-email").keyup(function(){

        leads_table.draw();

    });

	

})(jQuery);
</script>





@endsection