@extends('layouts.app')



@section('content')

<div class="row">

	<div class="col-lg-12">

		<div class="card">

			<div class="card-header bg-primary text-white">

				<span class="panel-title">{{ _lang('Update Lead') }}</span>

			</div>

			<div class="card-body">

				<form method="post" class="validate" autocomplete="off" action="{{ action('LeadController@update', $id) }}" enctype="multipart/form-data">

					{{ csrf_field()}}

					<input name="_method" type="hidden" value="PATCH">

					<div class="row">

						<div class="col-md-3">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Name') }}</label>						

							   <input type="text" class="form-control" name="name" value="{{ $lead->name }}" >

						    </div>

						</div>



						<div class="col-md-3">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Company Name') }}</label>	

							   <input type="text" class="form-control" name="company_name" value="{{ $lead->company_name }}" required>

						    </div>

						</div>



						<div class="col-md-3">

					        <div class="form-group">

						        <label class="control-label">{{ _lang('Email') }}</label>		

						        <input type="text" class="form-control" name="email" value="{{ $lead->email }}">

					        </div>

					    </div>


						<div class="col-md-3">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Phone') }}</label>

							   <input type="text" class="form-control" name="phone" value="{{ $lead->phone }}" required>

						    </div>

						</div>
						

						<div class="col-md-3">

						    <div class="form-group">

						    	<a href="{{ route('lead_statuses.create') }}" data-reload="false" data-title="{{ _lang('New Lead Status') }}" class="ajax-modal-2 select2-add"><i class="ti-plus"></i> {{ _lang('Add New') }}</a>

							    <label class="control-label">{{ _lang('Lead Status') }}</label>	

							    <select id="lead_status_id" class="form-control select2-ajax" data-value="id" data-display="title" data-table="lead_statuses" data-where="1" name="lead_status_id">

					                <option value="">{{ _lang('Select One') }}</option>

									{{ create_option('lead_statuses', 'id', 'title', $lead->lead_status_id,array("company_id="=>company_id())) }}
                                    <option value="16" @if($lead->lead_status_id == 16) {{ 'selected' }} @endif>Open</option>
							    </select>

						    </div>

						</div>
						<div class="col-md-3"  id="status_date" <?php if ($lead->lead_status_id == 33 || $lead->lead_status_id == 28 || $lead->lead_status_id == 27) { echo 'style="display: none;"';}else{ echo 'style="display: block;"'; } ?>>

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Date For Next Follow Up') }}</label>

							   <input type="text" class="form-control datepicker" name="status_date" value="{{ $lead->status_date }}">

						    </div>

						</div>
							<div class="col-md-3"  id="status_time" <?php if ($lead->lead_status_id == 33 || $lead->lead_status_id == 28 || $lead->lead_status_id == 27) { echo 'style="display: none;"';}else{ echo 'style="display: block;"'; } ?>>

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Time For Next Follow Up') }}</label>

							   <input type="time" class="form-control" name="status_time" value="{{ $lead->status_time }}">

						    </div>

						</div>
						
						<div class="col-md-3" id="not_interested" <?php if ($lead->lead_status_id == 28 || $lead->lead_status_id == 27) { echo 'style="display: none;"';}else{ echo 'style="display: block;"'; } ?>>

						    <div class="form-group">

							    <label class="control-label">{{ _lang('Why not Interested') }}</label>	

							    <select class="form-control " name="not_interested">
					                <option value="">{{ _lang('Select One') }}</option>
					                <option @if($lead->not_interested == 1) {{ 'selected' }} @endif value="1">Budget Issue</option>
					                <option @if($lead->not_interested == 2) {{ 'selected' }} @endif value="2">Proceed with a different vendor</option>
					                <option @if($lead->not_interested == 3) {{ 'selected' }} @endif value="3">Project on Hold</option>
							    </select>

						    </div>

						</div>
						
					<!--	<div class="col-md-3">

						    <div class="form-group">

							    <label class="control-label">{{ _lang('Lead Type') }}</label>	

							    <select class="form-control " data-value="id" data-display="title" data-table="lead_sources" data-where="1" name="lead_type">

					                <option value="">{{ _lang('Select One') }}</option>
					                <option @if($lead->lead_type == 'Enquiry Lead') {{ 'selected' }} @endif value="Enquiry Lead">Enquiry Lead</option>
					                <option @if($lead->lead_type == 'Quality Lead') {{ 'selected' }} @endif value="Quality Lead">Quality Lead</option>

							    </select>

						    </div>

						</div>-->
						
					<!--	<div class="col-md-3">

						    <div class="form-group">

							    <label class="control-label">{{ _lang('Project Type') }}</label>	

							    <select class="form-control " data-value="id" data-display="title" data-table="lead_sources" data-where="1" name="project_type">

					                <option value="">{{ _lang('Select One') }}</option>
					                <option @if($lead->project_type == 'SEO') {{ 'selected' }} @endif value="SEO">SEO</option>
					                <option @if($lead->project_type == 'Web') {{ 'selected' }} @endif value="Web">Web</option>
					                <option @if($lead->project_type == 'Mobile') {{ 'selected' }} @endif value="Mobile">Mobile</option>

							    </select>

						    </div>

						</div>-->


                        @if((Auth::user()->role_id == 10) || (Auth::user()->user_type == 'user') || (Auth::user()->role_id == 17))
						<div class="col-md-3">

						    <div class="form-group">

							    <label class="control-label">{{ _lang('Assigned ') }}</label>	

							    <select class="form-control select2" name="assigned_user_id">

					                <option value="">{{ _lang('Select One') }}</option>

									{{ create_option_sales('users','id','name',$lead->assigned_user_id, array("company_id="=>company_id())) }}

							    </select>

						    </div>

						</div>
						@endif



						<!--<div class="col-md-6">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Contact Date') }}</label>

							   <input type="text" class="form-control datepicker" name="contact_date" value="{{ $lead->contact_date }}">

						    </div>

						</div>-->

						<div class="col-md-3">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Website') }}</label>

							   <input type="text" class="form-control" name="website" value="{{ $lead->website }}">

						    </div>

						</div>
                       <!-- <div class="col-md-3">

					        <div class="form-group">

						        <label class="control-label">{{ _lang('LinkedIn') }}</label>		

						        <input type="text" class="form-control" name="linkedin" value="{{ $lead->linkedin }}">

					        </div>

					    </div>-->
                        <div class="col-md-3">

						    <div class="form-group">

						    	<a href="{{ route('lead_sources.create') }}" data-reload="false" data-title="{{ _lang('New Lead Source') }}" class="ajax-modal-2 select2-add"><i class="ti-plus"></i> {{ _lang('Add New') }}</a>

							    <label class="control-label">{{ _lang('Lead Source') }}</label>	

							    <select class="form-control select2-ajax" data-value="id" data-display="title" data-table="lead_sources" data-where="1" name="lead_source_id">

					                <option value="">{{ _lang('Select One') }}</option>

									{{ create_option('lead_sources', 'id', 'title', $lead->lead_source_id,array("company_id="=>company_id())) }}

							    </select>

						    </div>

						</div>

					<!--	<div class="col-md-4">

						    <div class="form-group">

							    <label class="control-label">{{ _lang('Country') }}</label>

							    <select class="form-control select2 auto-select" data-selected="{{ $lead->country }}" name="country" >

					                <option value="">{{ _lang('Select One') }}</option>

									{{ get_country_list( $lead->country ) }}

							    </select>

						    </div>

						</div>-->

<div class="col-md-6">

					        <div class="form-group">

						        <label class="control-label">{{ _lang('TimeZone') }}</label>		

						         <select class="form-control" data-selected="{{ $lead->time_zone }}" name="time_zone" id="time_zone" required>

					                <option value="">{{ _lang('Select One') }}</option>
  @foreach($timezones as $timez)
<option value="{{$timez->id}}" {{$lead->time_zone==$timez->id?'selected':''}}>{{$timez->name}}</option>
@endforeach

							    </select>

					        </div>

					    </div>
					    <div class="col-md-6">

					        <div class="form-group">

						        <label class="control-label">{{ _lang('State') }}</label>
						        
						         <select class="form-control select2"  name="zone_state" id="zone_state"  required>

							    </select>
							  
					        </div>

					    </div>

						<!--<div class="col-md-6">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('City') }}</label>						

							   <input type="text" class="form-control" name="city" value="{{ $lead->city }}">

						    </div>

						</div>



						<div class="col-md-6">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('State') }}</label>

							   <input type="text" class="form-control" name="state" value="{{ $lead->state }}">

						    </div>

						</div>



						<div class="col-md-6">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Zip') }}</label>						

							   <input type="text" class="form-control" name="zip" value="{{ $lead->zip }}">

						    </div>

						</div>

                        <div class="col-md-6">

						    <div class="form-group">

							    <label class="control-label">{{ _lang('Mark Hot Prospect') }}</label>

							    <select class="form-control select2 auto-select" name="hot" data-selected="{{ $lead->hot }}">

					                <option value="">{{ _lang('Select One') }}</option>
					                <option value="1">Yes</option>
					                <option value="0">No</option>

							    </select>

						    </div>

						</div>-->

						<div class="col-md-12">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Address') }}</label>

							   <textarea class="form-control summernote" name="address" >{{ $lead->address }}</textarea>

						    </div>

						</div>
						
						<!--<div class="col-md-12">

						    <div class="form-group">

							   <label class="control-label">{{ _lang('Sales Comments') }}</label>

							   <textarea class="form-control summernote" name="sales_team">{{ $lead->sales_team }}</textarea>

						    </div>

						</div>-->

						<div class="col-md-12">

						    <div class="form-group">

							    <button type="submit" class="btn btn-primary">{{ _lang('Update') }}</button>

						    </div>

						</div>

					</div>	

				</form>

			</div>

		</div>

	</div>

</div>



@endsection


@section('js-script')

<script>
    $(document).ready(function() {
      
    myfunction({{$lead->time_zone}},"{{$lead->zone_state}}")
});

function myfunction(idd,zones){
    //  alert(zones)
                var idCountry = idd;
                $("#zone_state").html('');
                $.ajax({
                    url: "{{url('fetch-states')}}",
                    type: "POST",
                    data: {
                        zone_id: idCountry,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (result) {
                        $('#zone_state').html('<option value="">Select State</option>');
                        $.each(result.states, function (key, value) {
                           //  alert(zones)
                            if(value.name===zones){
                               // alert(zones)
                                 $("#zone_state").append('<option value="' + value
                                .name + '" selected>' + value.name + '</option>');
                            }else{
                            $("#zone_state").append('<option value="' + value
                                .name + '">' + value.name + '</option>');
                            }
                        });
                    }
                });
            
        
 
}
</script>
<script>
    $('#lead_status_id').change(function(){
        var status_id = $(this).val();
        var arr = new Array(33, 28, 27);
        console.log($.inArray(status_id, arr));
        if (status_id == 33 || status_id == 28 || status_id == 27)
        {
            if(status_id == 33){
                $('#not_interested').css('display', 'block');
                $('#status_date').css('display', 'none');
                $('#status_date input').prop('required',false);
                return false;
            }
            $('#status_date').css('display', 'none');
            $('#status_date input').prop('required',false);
            return false;
        }else{
            $('#status_date').css('display', 'block');
            $('#status_date input').prop('required',true);
            console.log(status_id);
        }
    })
</script>
   
   <script>
        $(document).ready(function () {
            $('#time_zone').on('change', function () {
                var idCountry = this.value;
                $("#zone_state").html('');
                $.ajax({
                    url: "{{url('fetch-states')}}",
                    type: "POST",
                    data: {
                        zone_id: idCountry,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (result) {
                        $('#zone_state').html('<option value="">Select State</option>');
                        $.each(result.states, function (key, value) {
                            $("#zone_state").append('<option value="' + value
                                .name + '">' + value.name + '</option>');
                        });
                    }
                });
            });
            
        });

    </script>


@endsection


