@extends('layouts.app')

@section('content')

<div class="row">
	<div class="col-12">
			
		<div class="card mt-2">
			<span class="panel-title d-none">{{ _lang('List') }}</span>
			<div class="card-body">
			<table id="contacts-table" class="table table-bordered data-table">
			<thead>
			  <tr>
			    <th>{{ _lang('S.No') }}</th>
				<th>{{ _lang('Name') }}</th>
				<th>{{ _lang('Email') }}</th>
				<th>{{ _lang('Phone') }}</th>
				<th>{{ _lang('Duration(Months)') }}</th>
				<th>{{ _lang('Expiry Date') }}</th>
				<th class="text-center">{{ _lang('Action') }}</th>
			  </tr>
			</thead>
			<tbody>
			    @php $i =1; @endphp
			  @foreach($user_list as $user)
				<tr id="row_{{ $user->id }}">
				    <td class='email'>{{ $i }}</td>
					<td class='name'><a href="{{ url('/contacts').'/'.$user->contact_id }}">{{ contact_name($user->contact_id) }}</a></td>
					<td class='email'>{{ contact_email($user->contact_id) }}</td>	
					<td class='email'>{{ contact_phone($user->contact_id) }}</td>
					<td>{{ $user->duration }}</td>
					<td>{{ $user->valid_to }}</td>
					<td class="text-center">
						<a href="{{ url('/edit_assign_service_contact').'/'.$user->id }}" data-title="{{ _lang('Update User') }}" class="btn btn-outline-warning btn-xs">{{ _lang('Edit') }}</a>
						<a href="{{ url('/destroy_service_duration').'/'.$user->id }}" data-title="{{ _lang('View User') }}" class="btn btn-outline-primary btn-xs">{{ _lang('Delete') }}</a>
					</td>
				</tr>
				@php $i++; @endphp
			  @endforeach
			</tbody>
		  </table>
			</div>
		</div>
	</div>
</div>

@endsection

@section('js-script')

@endsection


