@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-12">
            <a class="btn btn-primary btn-xs" href="{{ route('contacts.create') }}"><i class="ti-plus"></i>
                {{ _lang('Add New') }}</a>

            <a class="btn btn-dark btn-xs" href="{{ route('contacts.import') }}"><i class="ti-import"></i>
                {{ _lang('Import') }}</a>
            @if (Auth::user()->user_type == 'user')
                <a class="btn btn-success btn-xs disabled" href="#" id="lead-assign-btn" data-toggle="modal"
                    data-target="#exampleModal"><i class="ti-assign"></i>Lead Assign</a>
            @endif

            <div class="card mt-2">
                <span class="panel-title d-none">{{ _lang('List Contact') }}</span>
                <div class="card-body">
                    <table id="contacts-table" class="table table-bordered">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="select-all"></th>
                                <th>{{ _lang('Customer ID') }}</th>
                                <th>{{ _lang('Company Name') }}</th> 
                                <th>{{ _lang('Phone') }}</th>
                                <th>{{ _lang('Address') }}</th>
                                <th>{{ _lang('Contact Name') }}</th>
                                <th>{{ _lang('Assign') }}</th>
                                <th>{{ _lang('Current Assign') }}</th>
                                <th class="text-center">{{ _lang('Action') }}</th>

                            </tr>
                        </thead>

                        <thead>
 

                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection




<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Users List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @if (count($users) > 0)
                <form id="assign_lead_id" action="{{ url('contacts/assign_lead') }}" method="post" autocomplete="off">
                    {{-- @csrf --}}
                    <div class="modal-body">

                        <select name="user_id" id="user_id" class="form-control">
                            <option value="">Choose User</option>
                            @foreach ($users as $c)
                                <option value="{{ $c->id }}">{{ $c->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            @endif
        </div>
    </div>
</div>


@section('js-script')
    <script src="{{ URL::asset('/backend/assets/js/ajax-datatable/contacts.js') }}"></script>


    <script>
        // $(document).on("change", ".row-checkbox", function() {
        //     let anyChecked = $(".row-checkbox:checked").length > 0;

        //     if (anyChecked) {
        //         $("#lead-assign-btn").removeClass("disabled").removeAttr("disabled");
        //     } else {
        //         $("#lead-assign-btn").addClass("disabled").attr("disabled", true);
        //     }
        // });

        // $('#select-all').on('click', function() {
        //     var checked = this.checked;
        //     $('.row-checkbox').each(function() {
        //         this.checked = checked;
        //     });


        //     if (checked) {
        //         $("#lead-assign-btn").removeClass("disabled").removeAttr("disabled");
        //     } else {
        //         $("#lead-assign-btn").addClass("disabled").attr("disabled", true);
        //     }

        // });
    </script>
@endsection
