@extends('layouts.app')

@section('content')

<div class="row">
	<div class="col-lg-12">
		<a class="btn btn-primary btn-xs mb-2" data-title="{{ _lang('Create New Lead') }}" href="{{ route('leads.create') }}"><i class="ti-plus"></i> {{ _lang('Add New') }}</a>
		<a class="btn btn-dark btn-xs mb-2" href="{{ route('leads.import') }}"><i class="ti-upload"></i> {{ _lang('Imports') }}</a>
		 @if (Auth::user()->user_type == 'staff')   
		<!-- <a class="btn btn-secondary btn-xs mb-2" href="{{ url('leads/kanban') }}"><i class="ti-layout-column3"></i> {{ _lang('Kanban View') }}</a> -->
		@endif
		<div class="card mt-2">
		    
			<span class="panel-title d-none">{{ _lang('Lead List') }}</span>
				
			<div class="card-body">
                <div class="row">
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Marketing Person') }}</label>
                     	 <select class="form-control select2 select-filter" name="assigned_user_id">
                             <option value="">{{ _lang('ALL') }}</option>
                             {{ create_option_sales('users','id','name','',array('company_id=' => company_id(), 'user_type=' => 'staff')) }}
                     	 </select>
                     </div>	
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Lead Status') }}</label>
                     	 <select class="form-control select2 select-filter" data-placeholder="{{ _lang('ALL') }}" name="lead_status_id" multiple="true">
							{{ create_option('lead_statuses','id','title','',array('company_id=' => company_id())) }}
                     	 </select>
                     </div>	
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Lead Source') }}</label>
                     	 <select class="form-control select2 select-filter" name="lead_source_id">
                     	 	<option value="">{{ _lang('ALL') }}</option>
							{{ create_option('lead_sources','id','title','',array('company_id=' => company_id())) }}
                     	 </select>
                     </div>	

                      <div class="col-lg-3">
                     	 <label>{{ _lang('Country') }}</label>
                     	 <select class="form-control select2 select-filter" name="country">
                     	 	<option value="">{{ _lang('ALL') }}</option>
							{{ get_country_list() }}
                     	 </select>
                     </div>	
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Project Type') }}</label>
                     	 <select class="form-control select2 select-filter" name="project_type">
                     	 	<option value="">{{ _lang('ALL') }}</option>
                     	 	<option value="Mobile">Mobile</option>
                     	 	<option value="SEO">SEO</option>
                     	 	<option value="Web">Web</option>
							
                     	 </select>
                     </div>	
                      
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Search By Name') }}</label>
                     	 <input type="text" class="form-control search-filter" name="search">
                     </div>
                     
                     <div class="col-lg-3">
                     	 <label>{{ _lang('Search By Email') }}</label>
                     	 <input type="text" class="form-control search-email" name="email">
                     </div>
                     
                </div>

                <hr>

				<table id="leads_table" class="table table-striped">
					<thead>
					  <th>ID</th>
						<th>{{ _lang('Name') }}</th>
						<th>{{ _lang('Email') }}</th>
						<th>{{ _lang('Phone') }}</th>
						<th>{{ _lang('Status') }}</th>
						<th>{{ _lang('Sales Person ') }}</th>
						<th>{{ _lang('Marketing Person') }}</th>
						<th>{{ _lang('Assigned Date ') }}</th>
						<th>{{ _lang('Created Date ') }}</th>
						<th class="text-center">{{ _lang('Action') }}</th>
						
					</thead>
					<tbody>  
					    
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

@endsection

@section('js-script')
<!--<script src="{{ URL::asset('/backend/assets/js/ajax-datatable/leads.js') }}"></script>-->
<script>
    (function($) {

	"use strict";

	

	 var leads_table = $('#leads_table').DataTable({

		processing: true,

		serverSide: true,

		ajax: ({

			url : _url + '/leads/get_table_data',

			method: "POST",

			data: function (d) {
			    

				d._token =  $('meta[name="csrf-token"]').attr('content');

                

                if($('select[name=assigned_user_id]').val() != ''){

	                d.assigned_user_id = $('select[name=assigned_user_id]').val();

	            }
                
                if($('.search-filter').val() != ''){

	                d.keyword = $('.search-filter').val();

	            }
	            
	            if($('.search-email').val() != ''){

	                d.email = $('.search-email').val();

	            }
                

                if($('select[name=lead_status_id]').val() != null){

                	d.lead_status_id = JSON.stringify($('select[name=lead_status_id]').val());

                }



                if($('select[name=lead_source_id]').val() != ''){

	                d.lead_source_id = $('select[name=lead_source_id]').val();

	            }



                if($('select[name=country]').val() != ''){

	                d.country = $('select[name=country]').val();

	            }
	            
	            if($('select[name=project_type]').val() != ''){

	                d.project_type = $('select[name=project_type]').val();

	            }

            },

			 error: function (request, status, error) {

				console.log(request.responseText);

			 }

		}),
		"columns" : [
		    
		    { data : 'id', name : 'id' },

			{ data : 'name', name : 'name' },

			{ data : 'email', name : 'email' },

			{ data : 'phone', name : 'phone' },
			
			{ data : 'lead_status.title', name : 'lead_status.title' },
			
			{ data : 'assigned_user.name', name : 'assigned_user.name' },
			
			{ data : 'marketing_user.name', name : 'marketing_user.name' },
			
			{ data : 'assigned_date', name : 'assigned_date' },
			
			{ data : 'created_at', name : 'created_at' },

			{ data : "action", name : "action" },

		],
		responsive: true,

		"bStateSave": true,

		"bAutoWidth":false,	

		"ordering": false,

		"searching": false,

		"language": {

		   "decimal":        "",

		   "emptyTable":     $lang_no_data_found,

		   "info":           $lang_showing + " _START_ " + $lang_to + " _END_ " + $lang_of + " _TOTAL_ " + $lang_entries,

		   "infoEmpty":      $lang_showing_0_to_0_of_0_entries,

		   "infoFiltered":   "(filtered from _MAX_ total entries)",

		   "infoPostFix":    "",

		   "thousands":      ",",

		   "lengthMenu":     $lang_show + " _MENU_ " + $lang_entries,

		   "loadingRecords": $lang_loading,

		   "processing":     $lang_processing,

		   "search":         $lang_search,

		   "zeroRecords":    $lang_no_matching_records_found,

		   "paginate": {

			  "first":      $lang_first,

			  "last":       $lang_last,

			  "next":       $lang_next,

			  "previous":   $lang_previous

		   }

		}

	});

	

	$('.select-filter').on('change', function(e) {

        leads_table.draw();

    });
    
    $(".search-filter").keyup(function(){

        leads_table.draw();

    });
    
    $(".search-email").keyup(function(){

        leads_table.draw();

    });

	

})(jQuery);
</script>





@endsection