@extends('layouts.app')

@section('content')

<div class="row">
<div class="col-12">
<form method="post" class="validate" autocomplete="off" action="{{ url('assign_service_contact') }}" enctype="multipart/form-data">
	<div class="row">
		<div class="col-md-12">
		<div class="card">
		<span class="d-none panel-title">{{ _lang('Assign Service to Contact') }}</span>

		<div class="card-body">
			{{ csrf_field() }}

			<div class="row"><div class="col-md-6">
				  <div class="form-group">
					<label class="control-label">{{ _lang('Service Name') }}</label>						
					<select class="form-control select2" name="item_id">
					    <option value="">{{ _lang('Select Service') }}</option>
					    @foreach($items as $key => $value)
						    <option value="{{ $value->service->item_id }}">{{ $value->item_name }}</option>
						@endforeach
					</select>
				  </div>
				</div>
				
				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label">{{ _lang('Contact Name') }}</label>						
					<select class="form-control select2" name="contact_id" id="contact_id">
					    <option value="">{{ _lang('Select Contact') }}</option>
						@foreach($contacts as $key => $value)
						    <option value="{{ $value->id }}">{{ $value->contact_name }}</option>
						@endforeach
					</select>
				  </div>
				</div>
				
				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label">{{ _lang('Duration') }}</label>						
					<input type="text" class="form-control" name="duration" value="{{ old('duration') }}">
				  </div>
				</div>
				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label">{{ _lang('Respective Employee ID') }}</label>						
					<input type="text" class="form-control" id="user_id" readonly="readonly" name="user_id" value="{{ old('duration') }}">
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label">{{ _lang('Status') }}</label>						
					<select class="form-control select2" name="status">
					    <option value="">{{ _lang('Select Status') }}</option>
					    <option value="1">{{ _lang('Active') }}</option>
					    <option value="0">{{ _lang('Deactive') }}</option>
					</select>
				  </div>
				</div>

				<div class="col-md-12">
				  <div class="form-group">
					<button type="reset" class="btn btn-danger">{{ _lang('Reset') }}</button>
					<button type="submit" class="btn btn-primary">{{ _lang('Save') }}</button>
				  </div>
				</div>
			</div>
		</div>
	  </div>
	 </div>
    </div>
 </form>
</div>
</div>
@endsection
@section('custom_js')
<script>
    jQuery(document).on('change', '#contact_id', function() {
		var client_id = $(this).val();
		var _url = '<?php echo url("/"); ?>';
		jQuery.ajax({
			url: _url + '/contacts/get_client_info/' + client_id,
			beforeSend: function(){
				jQuery("#preloader").css("display","block");
			},success: function(data){
				jQuery("#preloader").css("display","none");
				var json = JSON.parse(data);
				jQuery("#user_id").val(json['converted_by_user_id']);
				 
			}
		});
	});	
</script>
@stop

