@extends('layouts.app')@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header bg-primary text-white"><span
                            class="panel-title">{{ _lang('Create Customer') }}</span></div>
                <div class="card-body">
                    <form method="post" id="task" class="validate" autocomplete="off"
                          action="{{ route('customer.store') }}"
                          enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Name') }}</label> <input
                                            type="text" class="form-control" name="name" value="{{ old('name') }}"
                                            required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Number') }}</label> <input
                                            type="text" class="form-control" name="phone" value="{{ old('phone') }}"
                                            required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Email') }}</label> <input
                                            type="email" class="form-control" name="email" value="{{ old('email') }}"
                                            required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer Device Type') }}</label> <select
                                            class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('Customer Device Type') }}"
                                            name="customer_device">
                                        <option value="">Please Select</option>
                                        <option value="Windows">Windows</option>
                                        <option value="Mac">Mac</option>
                                        <option value="Chromebook">Chromebook</option>
                                        <option value="Mobile">Mobile</option>
                                    </select></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Printer Use Case') }}</label> <select
                                            class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('Printer Use Case') }}" name="printer_use_case">
                                        <option value="">Please Select</option>
                                        <option value="Office --- ready to pay">Office --- ready to pay</option>
                                        <option value="Office --- not ready to pay">Office --- not ready to pay</option>
                                        <option value="Personal --- ready to pay">Personal --- ready to pay</option>
                                        <option value="Personal --- not ready to pay">Personal --- not ready to pay</option>
                                    </select></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Printer Problem') }}</label> <textarea
                                            class="form-control"
                                            name="printer_problem">{{ old('printer_problem') }}</textarea></div>
                            </div>
{{--<!--                            <div class="col-md-6">--}}
{{--                                <div class="form-group"><label class="control-label">{{ _lang('Caller Name') }}</label>--}}
{{--                                    <input type="text" class="form-control" name="caller_name"--}}
{{--                                           value="{{ old('caller_name') }}" required></div>--}}
{{--                            </div>-->--}}
                            <div class="col-md-6">
                                <div class="form-group"><label class="control-label">{{ _lang('Status') }}</label>
                                    <select class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('All Status') }}" name="type_status" required>
                                        <option value="">Please Select</option>
                                        <option value="Resolved">Resolved</option>
                                        <option value="Pending">Pending</option>
                                    </select></div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Subscription Duration') }}</label>
                                    <select class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('All Subscription Duration') }}" name="subscription_duration" required>
                                        <option value="">Please Select</option>
                                        <option value="One Time Fix-3 Months">One Time Fix-3 Months</option>
                                        <option value="6 months">6 months</option>
                                        <option value="1 year">1 Year</option>
                                        <option value="2 year">2 Year</option>
                                        <option value="3 year">3 Year</option>
                                        <option value="4 year">4 Year</option>
                                        <option value="5 year">5 Year</option>
                                        <option value="Lifetime">Lifetime</option>

                                    </select>
                            </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label class="control-label">{{ _lang('Amount') }}</label>
                                    <input type="number" min="0" value="0" step="any" class="form-control" name="amount"
                                           value="{{ old('amount') }}" required></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Customer  Address') }}</label> <textarea
                                            class="form-control" name="address">{{ old('address') }}</textarea></div>
                            </div>
                            <div class="col-md-6">

                                <div class="form-group">

                                    <label class="control-label">{{ _lang('File') }}</label>

                                    <input type="file" class="form-control dropify" name="file" >

                                </div>

                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Comment - Remarks') }}</label> <textarea
                                            class="form-control"
                                            name="comments">{{ old('comments') }}</textarea></div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Payment Method') }}</label> <select
                                            class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('Payment Method') }}" name="payment_method">
                                        <option value="">Please Select</option>
                                        <option value="Card with Paypal">Card with Paypal</option>
                                        <option value="Card with Bill.com">Card with Bill.com</option>

                                        <option value="Physical Check Mailed" >
                                            Physical Check Mailed
                                        </option>
                                        <option value="Echeck from scan check" >
                                            Echeck from scan check
                                        </option>

                                    </select></div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Remote ID') }}</label> <select
                                            class="form-control"
                                            data-placeholder="{{ _lang('Remote ID') }}" name="remote_id" id="remote_id" >
                                        <option value="">Please Select</option>
                                        <option value="Supremo">Supremo</option>
                                        <option value="LMI">LMI</option>

                                    </select></div>
                            </div>


                            <div class="col-md-6" style="display:none" id="loginId">
                                <div class="form-group"><label
                                            class="control-label">{{ _lang('Id') }}</label>
                                    <input type="text" class="form-control" name="loginId"
                                           value="{{ old('loginId') }}" ></div>
                            </div>
                            <div class="col-md-6" style="display:none" id="password">
                                <div class="form-group"><label class="control-label">{{ _lang('Password') }}</label>
                                    <input type="text" class="form-control" name="password"
                                           value="{{ old('password') }}" ></div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group"><label class="control-label">{{ _lang('Assigned User') }}</label>
                                    <select class="form-control select2 select-filter"
                                            data-placeholder="{{ _lang('All User') }}" name="assigned_user">
                                        <option value="">Please Select</option>
                                        <option value="0">Admin</option>
                                        @foreach($callermanager as $c)
                                        <option value="{{$c->id}}">{{$c->name}}</option>
                                        @endforeach

                                    </select></div>
                            </div>

                            <input type="hidden" name="related_to" value="projects">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <button type="reset" class="btn btn-danger">{{ _lang('Reset') }}</button>
                                    <button type="submit" class="btn btn-primary">{{ _lang('Save') }}</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js-script')
    <script>
$(document).ready(function () {
$('#remote_id').change(function () {

if ($('#remote_id').val() == "Supremo") {

document.getElementById("loginId").style.display = "block";
document.getElementById("password").style.display = "block";


//document.getElementsByName("loginId")[0].setAttribute('required', '');
//document.getElementsByName("password")[0].setAttribute('required', '');

}else if($('#remote_id').val() == 'LMI'){
document.getElementById("loginId").style.display = "block";
document.getElementById("password").style.display = "none";

   // document.getElementsByName("loginId")[0].setAttribute('required', '');
  //  document.getElementsByName("password")[0].setAttribute('', '');
}
else {

}
});
});
    </script>
@endsection