<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Transaction;
use App\Invoice;
use App\PreviousData;
use App\Project;
use App\Contact;
use App\Lead;
use App\User;
use DB;
use Auth;
use Carbon\Carbon;
class DashboardController extends Controller
{

    public function __construct()
    {
        date_default_timezone_set(get_company_option('timezone', get_option('timezone', 'Asia/Dhaka')));
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $type = Auth::user()->user_type;
        $today = Carbon::now();
        $td = $today->format('Y-m-d');

        if ($type == 'admin') {
            $data = array();
            $data['total_user'] = \App\User::where('user_type', 'user')
                ->count();

            $data['paid_user'] = \App\Company::where('membership_type', 'member')
                ->count();

            $data['trial_user'] = \App\Company::where('membership_type', 'trial')
                ->count();

            $data['total_payment'] = \App\PaymentHistory::selectRaw('SUM(amount) as total')
                ->where('status', 'paid')
                ->first()->total;

            $data['news_users'] = \App\User::where("user_type", "user")
                ->orderBy("id", "desc")
                ->limit(5)->get();

            $data['recent_payment'] = \App\PaymentHistory::where('status', 'paid')
                ->limit(5)
                ->orderBy('id', 'desc')
                ->get();

            return view('backend/dashboard-' . $type, $data);
        } else if ($type == 'client') {
            $client_ids = Auth::user()->client->pluck('id');

            $data = array();
            $data['company_currency'] = array();
            $data['currency_position'] = array();

            foreach (Auth::user()->client as $client) {
                $data['company_currency'][$client->company_id] = get_company_field($client->company_id, 'base_currency');
                $data['currency_position'][$client->company_id] = get_company_field($client->company_id, 'currency_position');
            }


            $data['invoices'] = Invoice::whereIn('client_id', $client_ids)
                ->orderBy('id', 'desc')
                ->limit(5)
                ->get();

            $data['transactions'] = Transaction::whereIn('payer_payee_id', $client_ids)
                ->orderBy('id', 'desc')
                ->limit(5)
                ->get();

            $data['recent_projects'] = Project::whereIn('client_id', $client_ids)
                ->orderBy('id', 'desc')
                ->limit(5)
                ->get();

            //Summary Data
            $data['total_project'] = DB::table('projects')->whereIn('client_id', $client_ids)->count();

            $data['invoice_value'] = DB::table('invoices')
                ->whereIn('client_id', $client_ids)
                ->selectRaw('sum(grand_total) as grand_total, sum(paid) as paid')
                ->first();

            $data['invoice_due_amount'] = DB::table('invoices')
                ->selectRaw('sum(grand_total) as grand_total, sum(paid) as paid')
                ->whereRaw("(Status = 'Unpaid' or Status = 'Partially_Paid')")
                ->whereIn('client_id', $client_ids)
                ->first();


            return view('backend/dashboard-' . $type, $data);
        } else if ($type == 'user') {
            $company_id = company_id();
            $data = array();

            $customers_sale = Contact::with(['transactions.group', 'assignuser'])->where("company_id", "=", company_id())
                // ->where('converted_by_user_id', '=', $user->id)
                ->get();
            $data['converted_by_user_id'] = count($customers_sale);
            //  current month sale
            $currentYear = Carbon::now()->year;
            $customers_sale_current_month_transaction = Contact::with([
                'transactions.group',
                'assignuser',
                'transactions' => function ($q) use ($currentYear) {
                    $q->whereMonth('payment_date', Carbon::now()->month)->whereYear('payment_date', $currentYear);
                }
            ])->where("company_id", "=", company_id());
            // ->where('converted_by_user_id', '=', $user->id);

            $customers_sale_current_month_transaction = $customers_sale_current_month_transaction->whereHas('transactions', function ($q) use ($currentYear) {
                $q->whereMonth('payment_date', Carbon::now()->month)->whereYear('payment_date', $currentYear);
            })->get();
            $dispute_total_c = 0;
            $refund_pf_c = 0;
            $total_credit_c = 0;
            // return $customers_sale_current_month_transaction;die;
            foreach ($customers_sale_current_month_transaction as $currentmonthsale) {
                $currentmonthsales = $currentmonthsale->transactions;

                foreach ($currentmonthsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_c = $dispute_total_c + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_c = $refund_pf_c + ($trans->refundable_amount ?? 0); 
                    }
                    $total_credit_c = $total_credit_c + ($trans->amount ?? 0);
                }
            }
            $data['total_current_month_sale'] =$total_credit_c - $refund_pf_c - $dispute_total_c;
        //    return $refund_pf_c;
        // die;
            //previousmonth sale
//             echo $total_credit_c;die;
// print_r($data['total_current_month_sale']);

            $customers_sale_previous_month_transaction = Contact::with([
                'transactions.group',
                'assignuser',
                'transactions' => function ($q) use ($currentYear) {
                    $q->whereMonth('payment_date', Carbon::now()->subMonth()->month)->whereYear('payment_date', $currentYear);
                }
            ])->where("company_id", "=", company_id());
            //   ->where('converted_by_user_id', '=', $user->id);

            $customers_sale_previous_month_transaction = $customers_sale_previous_month_transaction->whereHas('transactions', function ($q) use ($currentYear) {
                $q->whereMonth('payment_date', Carbon::now()->subMonth()->month)->whereYear('payment_date', $currentYear);
            })->get();
            $dispute_total_pre = 0;
            $refund_pf_pre = 0;
            $total_credit_pre = 0;
            foreach ($customers_sale_previous_month_transaction as $previousmonthsale) {
                $previousmonthsales = $previousmonthsale->transactions;

                foreach ($previousmonthsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_pre = $dispute_total_pre + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_pre = $refund_pf_pre + ($trans->refundable_amount ?? 0);
                    }
                    $total_credit_pre = $total_credit_pre + ($trans->amount ?? 0);

                }
            }
            $data['total_previous_month_sale'] = $total_credit_pre - $refund_pf_pre - $dispute_total_pre;

            //current Year sale

            // $previousYear = $currentYear - 1;
            $customers_sale_current_year_transaction = Contact::with([
                'transactions.group',
                'assignuser',
                'transactions' => function ($q) use ($currentYear) {
                    $q->whereYear('payment_date', $currentYear);
                }
            ])->where("company_id", "=", company_id());
            //->where('converted_by_user_id', '=', $user->id);

            $customers_sale_current_year_transaction = $customers_sale_current_year_transaction->whereHas('transactions', function ($q) use ($currentYear) {
                $q->whereYear('payment_date', $currentYear);
            })->get();
            $dispute_total_cy = 0;
            $refund_pf_cy = 0;
            $total_credit_cy = 0;
            foreach ($customers_sale_current_year_transaction as $currentyearsale) {
                $currentyearsales = $currentyearsale->transactions;

                foreach ($currentyearsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_cy = $dispute_total_cy + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_cy = $refund_pf_cy + ($trans->refundable_amount ?? 0);
                    }
                    $total_credit_cy = $total_credit_cy + ($trans->amount ?? 0);

                }
            }
            $data['total_current_year_sale'] = $total_credit_cy - $refund_pf_cy - $dispute_total_cy;

            //previous Year
            $previousYear = $currentYear - 1;
            $customers_sale_previous_year_transaction = Contact::with([
                'transactions.group',
                'assignuser',
                'transactions' => function ($q) use ($previousYear) {
                    $q->whereYear('payment_date', $previousYear);
                }
            ])->where("company_id", "=", company_id());
            // ->where('converted_by_user_id', '=', $user->id);

            $customers_sale_previous_year_transaction = $customers_sale_previous_year_transaction->whereHas('transactions', function ($q) use ($previousYear) {
                $q->whereYear('payment_date', $previousYear);
            })->get();
            $dispute_total_prey = 0;
            $refund_pf_prey = 0;
            $total_credit_prey = 0;
            foreach ($customers_sale_previous_year_transaction as $previousyearsale) {
                $previousyearsales = $previousyearsale->transactions;

                foreach ($previousyearsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_prey = $dispute_total_prey + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_prey = $refund_pf_prey + ($trans->refundable_amount ?? 0);
                    }
                    $total_credit_prey = $total_credit_prey + ($trans->amount ?? 0);

                }
            }
            // echo $dispute_total_prey;die;
            $data['total_previous_year_sale'] = $total_credit_prey - $refund_pf_prey - $dispute_total_prey;

            //Total sale
            // $previousYear = $currentYear - 1;
            $customers_sale_transaction = Contact::with(['transactions.group', 'assignuser'])->where("company_id", "=", company_id())
                //    ->where('converted_by_user_id', '=', $user->id)
                ->get();

            /*  $customers_sale_previous_year_transaction=$customers_sale_previous_year_transaction->whereHas('transactions', function($q)  {
                  $q->whereYear('payment_date', $previousYear);
              })->get();*/
            $dispute_total_ts = 0;
            $refund_pf_ts = 0;
            $total_credit_ts = 0;
            foreach ($customers_sale_transaction as $totalsale) {
                $totalsales = $totalsale->transactions;

                foreach ($totalsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_ts = $dispute_total_ts + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_ts = $refund_pf_ts + ($trans->refundable_amount ?? 0);
                        
                    }
                    
                    $total_credit_ts = $total_credit_ts + ($trans->amount ?? 0);

                }
            }
            $data['total_sale'] = $total_credit_ts - $refund_pf_ts - $dispute_total_ts;
            // echo $dispute_total_ts;die;

 











            $data['current_month_income'] = current_month_income();
            $data['current_month_expense'] = current_month_expense();
            $project_status = \App\Project::where('company_id', $company_id)
                ->selectRaw('status, COUNT(id) as c')
                ->groupBy('status')
                ->get();

            foreach ($project_status as $status) {
                $data['project_status'][$status->status] = $status->c;
            }

            $today = Carbon::now();
            $data['reminders'] = \DB::table('reminders')
                ->where('active', '=', 1)
                ->where('user_id', '=', Auth::user()->id)
                ->orderBy("date", "desc")
                ->get();

            $data['total_invoice_count'] = \App\Invoice::where('company_id', $company_id)->count();

            $data['total_employees_count'] = \App\User::where('company_id', $company_id)->where('user_type', '!=', 'user')->count();

            $data['total_new_employees_count'] = \App\User::where('company_id', $company_id)->whereDate('created_at', '>=', Carbon::now()->subDays(7))->count();

            $data['total_lead_count'] = \App\Lead::where('company_id', $company_id)->count();

            $data['total_converted_lead_count'] = \App\Lead::where('company_id', $company_id)->where('converted_lead', 1)->count();

            $data['total_follow_lead_count'] = \App\Lead::where('company_id', $company_id)->where('lead_status_id', 8)->count();

            $data['total_hot_lead_count'] = \App\Lead::where('company_id', $company_id)->where('hot', 1)->count();

            $data['unpaid_invoice_count'] = \App\Invoice::where('status', 'Unpaid')
                ->where('company_id', $company_id)->count();
            $data['canceled_invoice_count'] = \App\Invoice::where('status', 'Canceled')
                ->where('company_id', $company_id)->count();

            $data['total_demo'] = \App\Lead::where('company_id', $company_id)->where('lead_status_id', 18)->count();

            $data['canceled_demo'] = \App\Lead::where('company_id', $company_id)->where('lead_status_id', 17)->count();

            $days_before = 2;
            //$user_list = DB::select("SELECT contacts.*, service_durations.valid_to FROM contacts JOIN service_durations ON contacts.company_id = service_durations.company_id WHERE DATEDIFF(service_durations.valid_to, CURDATE()) <= $days_before ");
            $user_list = DB::select("SELECT contacts.*, service_durations.valid_to FROM contacts JOIN service_durations ON contacts.company_id = service_durations.company_id WHERE MONTH(service_durations.valid_to) = MONTH(NOW()) ");
            //print_r("SELECT contacts.*, service_durations.valid_to FROM contacts JOIN service_durations ON contacts.company_id = service_durations.company_id WHERE MONTH(service_durations.valid_to) =  MONTH(date('Y-m-d')) ");
            $data['upcoming_renewal'] = count($user_list);

            $data['invoice_due_amount'] = DB::table('invoices')
                ->selectRaw('sum(grand_total) as grand_total, sum(paid) as paid')
                ->where('company_id', $company_id)
                ->whereRaw("(Status = 'Unpaid' or Status = 'Partially_Paid')")
                ->first();
            $data['leads'] = Lead::with('lead_status')
                ->with('lead_source')
                ->with('assigned_user')
                ->where("company_id", "=", company_id())
                ->where('hot', '=', 1)
                ->orderBy("id", "desc")
                ->get();

            $converted_lead_by_user_in_current_month = DB::table('users')
                ->select(['users.name', 'users.id', \DB::raw('COUNT(*) as count')])
                ->join('contacts', function ($join) {
                    $join->on('contacts.converted_by_user_id', '=', 'users.id')->on('contacts.company_id', '=', 'users.company_id')->whereMonth('contacts.created_at', Carbon::now()->month);
                })
                ->groupBy('users.id')
                ->orderBy('count', 'desc')
                ->get()->toArray();

            $assigned_lead_to_user_in_current_month = DB::table('users')
                ->select(['users.name', 'users.id', \DB::raw('COUNT(*) as count')])
                ->join('leads', function ($join) {
                    $join->on('leads.assigned_user_id', '=', 'users.id')->on('leads.company_id', '=', 'users.company_id')->whereMonth('leads.created_at', Carbon::now()->month);
                })
                ->groupBy('users.id')
                ->orderBy('count', 'desc')
                ->get()->toArray();

            $per = array();
            foreach ($converted_lead_by_user_in_current_month as $key => $value) {
                $c = Lead::where('assigned_user_id', '=', $value->id)->count();

                if ($c > 0) {
                    $mul = $value->count * 100;
                    $div = $mul / $c;
                    $per[$value->id] = $div;
                }
            }

            if (count($per) > 0) {
                $maxs = array_keys($per, max($per));
                $data['percentage'] = max($per);
                $data['user'] = User::find($maxs)->toArray();
            } else {
                $data['percentage'] = 0;
                $data['user'] = 'no';
            }




            $year = now()->year;
            $prev_year = $year - 1;

            $company_id = company_id();
            $graph1 = PreviousData::where('company_id', '=', $company_id)->where('year', '=', $prev_year)->get()->toArray();
            $graph2 = PreviousData::where('company_id', '=', $company_id)->where('year', '=', $year)->get()->toArray();

            $f1 = '';
            $data['graph1'] = '';
            foreach ($graph1 as $key => $value) {
                $data['graph1'] .= '<div class="layer" data-html="true" data-toggle="tooltip" data-placement="top" title="Converted Lead: ' . $value['leads'] . '<br/> Total Amount: ' . $value["amount"] . '">' . $value["month"] . '</div>';
            }
            $data['graph1'] .= '<div class="innerCircle"><div class="content"><b>' . $prev_year . '</b></div></div>';
            $data['graph2'] = '';
            foreach ($graph2 as $key => $value) {
                $data['graph2'] .= '<div class="layer" data-html="true" data-toggle="tooltip" data-placement="top" title="Converted Lead: ' . $value['leads'] . '<br/> Total Amount: ' . $value["amount"] . '">' . $value["month"] . '</div>';
            }
            $data['graph2'] .= '<div class="innerCircle"><div class="content"><b>' . $year . '</b></div></div>';

            //   Sarkar Code Start -------******************************************************************--------------- 


            $currentMonth = Carbon::now()->month;
            $currentYear = Carbon::now()->year;
            // current month sale start 
            $customers_sale_current_month_transaction = Contact::with([
                'transactions' => function ($q) use ($currentMonth, $currentYear) {
                    $q->select('id','item_id', 'amount', 'payment_date')
                        ->whereMonth('payment_date', $currentMonth)
                        ->whereYear('payment_date', $currentYear);
                }
            ])->where("company_id", company_id());
            $customers_sale_current_month_transaction = $customers_sale_current_month_transaction->whereHas('transactions', function ($q) use ($currentMonth, $currentYear) {
                $q->whereMonth('payment_date', $currentMonth)
                    ->whereYear('payment_date', $currentYear);
            })->get();
//    echo  $thisMonthTotalAmount = $customers_sale_current_month_transaction->flatMap->transactions->sum('amount');
//    die;
            // current month sale end 

            // current month refund start 
             $customers_refund_current_month_transaction = Contact::with([
                'transactions' => function ($q) use ($currentMonth, $currentYear) {
                    $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date')
                        ->whereMonth('refund_payment_date', $currentMonth)
                        ->whereYear('refund_payment_date', $currentYear);
                }
            ])->where("company_id", company_id());
            $customers_refund_current_month_transaction = $customers_refund_current_month_transaction->whereHas('transactions', function ($q) use ($currentMonth, $currentYear) {
                $q->whereMonth('refund_payment_date', $currentMonth)
                    ->whereYear('refund_payment_date', $currentYear);
            })->get();
//                echo  $thisMonthTotalAmount = $customers_refund_current_month_transaction->flatMap->transactions->sum('refundable_amount');
//    die;
            // current month refund end  

            // current month dispute start 
            //  $customers_dispute_current_month_transaction = Contact::with([
            //     'transactions' => function ($q) use ($currentMonth, $currentYear) {
            //         $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date')
            //             ->whereMonth('refund_payment_date', $currentMonth)
            //             ->whereYear('refund_payment_date', $currentYear);
            //     }
            // ])->where("company_id", company_id());
            // $customers_dispute_current_month_transaction = $customers_dispute_current_month_transaction->whereHas('transactions', function ($q) use ($currentMonth, $currentYear) {
            //     $q->whereMonth('refund_payment_date', $currentMonth)
            //         ->whereYear('refund_payment_date', $currentYear)
            //         ->where('refund_type', 'Dispute');
            // })->get();
            // current month dispute end  


            // current year sale start 
            $customers_sale_current_year_transaction = Contact::with([
                'transactions' => function ($q) use ($currentYear) {
                    $q->select('id','item_id', 'amount', 'payment_date')
                         ->whereYear('payment_date', $currentYear);
                }
            ])->where("company_id", company_id());
            $customers_sale_current_year_transaction = $customers_sale_current_year_transaction->whereHas('transactions', function ($q) use ($currentYear) {
                $q->whereYear('payment_date', $currentYear);
            })->get();
            // current year sale end 

            // current year refund start 
             $customers_refund_current_year_transaction = Contact::with([
                'transactions' => function ($q) use ($currentMonth, $currentYear) {
                    $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date')
                         ->whereYear('refund_payment_date', $currentYear);
                }
            ])->where("company_id", company_id());
            $customers_refund_current_year_transaction = $customers_refund_current_year_transaction->whereHas('transactions', function ($q) use ($currentYear) {
                $q ->whereYear('refund_payment_date', $currentYear);
            })->get();
            // current year refund end  

            // current month dispute start 
            //  $customers_dispute_current_year_transaction = Contact::with([
            //     'transactions' => function ($q) use ($currentMonth, $currentYear) {
            //         $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date')
            //             ->whereYear('refund_payment_date', $currentYear);
            //     }
            // ])->where("company_id", company_id());
            // $customers_dispute_current_year_transaction = $customers_dispute_current_year_transaction->whereHas('transactions', function ($q) use ($currentYear) {
            //     $q->whereYear('refund_payment_date', $currentYear)
            //         ->where('refund_type', 'Dispute');
            // })->get();
            // current month dispute end  

           

            $thisMonthTotalAmount = $customers_sale_current_month_transaction->flatMap->transactions->sum('amount');
            $thisMonthTotalRefundAmount = $customers_refund_current_month_transaction->flatMap->transactions->sum('refundable_amount');
            // $thisMonthTotalDisputeAmount = $customers_dispute_current_month_transaction->flatMap->transactions->sum('refundable_amount');
            $thisYearTotalAmount = $customers_sale_current_year_transaction->flatMap->transactions->sum('amount');
            $thisYearTotalRefundAmount = $customers_refund_current_year_transaction->flatMap->transactions->sum('refundable_amount');
            // $thisYearTotalDisputeAmount = $customers_dispute_current_year_transaction->flatMap->transactions->sum('refundable_amount');
             
            
            $lastMonth = Carbon::now()->month-1;  
            $lastYear = $currentYear-1;  

            // last month sale start 
            $customers_sale_last_month_transaction = Contact::with([
                'transactions' => function ($q) use ($lastMonth, $currentYear) {
                    $q->select('id','item_id', 'amount', 'payment_date')
                        ->whereMonth('payment_date', $lastMonth)
                        ->whereYear('payment_date', $currentYear);
                }
            ])->where("company_id", company_id());
            $customers_sale_last_month_transaction = $customers_sale_last_month_transaction->whereHas('transactions', function ($q) use ($lastMonth, $currentYear) {
                $q->whereMonth('payment_date', $lastMonth)
                    ->whereYear('payment_date', $currentYear);
            })->get(); 
            // last month sale end 
  
            // last month refund start
            $customers_refund_last_month_transaction = Contact::with([
                'transactions' => function ($q) use ($lastMonth, $currentYear) {
                    $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date')
                        ->whereMonth('refund_payment_date', $lastMonth)
                        ->whereYear('refund_payment_date', $currentYear);
                }
            ])->where("company_id", company_id());
            $customers_refund_last_month_transaction = $customers_refund_last_month_transaction->whereHas('transactions', function ($q) use ($lastMonth, $currentYear) {
                $q->whereMonth('refund_payment_date', $lastMonth)
                    ->whereYear('refund_payment_date', $currentYear);
            })->get(); 
            // last month refund end
            
             // last month despute start
            // $customers_dispute_last_month_transaction = Contact::with([
            //     'transactions' => function ($q) use ($lastMonth, $currentYear) {
            //         $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date')
            //             ->whereMonth('refund_payment_date', $lastMonth)
            //             ->whereYear('refund_payment_date', $currentYear);
            //     }
            // ])->where("company_id", company_id());
            // $customers_dispute_last_month_transaction = $customers_dispute_last_month_transaction->whereHas('transactions', function ($q) use ($lastMonth, $currentYear) {
            //     $q->whereMonth('refund_payment_date', $lastMonth)
            //         ->whereYear('refund_payment_date', $currentYear)
            //         ->where('refund_type', 'Dispute');
            // })->get(); 
            // last month despute end

            // last year sale start 
            $customers_sale_last_year_transaction = Contact::with([
                'transactions' => function ($q) use ($lastYear) {
                    $q->select('id','item_id', 'amount', 'payment_date')
                         ->whereYear('payment_date', $lastYear);
                }
            ])->where("company_id", company_id());
            $customers_sale_last_year_transaction = $customers_sale_last_year_transaction->whereHas('transactions', function ($q) use ($lastYear) {
                $q->whereYear('payment_date', $lastYear);
            })->get(); 
            // last year sale end 
  
            // last year refund start
            $customers_refund_last_year_transaction = Contact::with([
                'transactions' => function ($q) use ($lastYear) {
                    $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date')
                        ->whereYear('refund_payment_date', $lastYear)
                        ->whereNotNull('refund_payment_date');
                }
            ])->where("company_id", company_id());
            $customers_refund_last_year_transaction = $customers_refund_last_year_transaction->whereHas('transactions', function ($q) use ($lastYear) {
                $q->whereYear('refund_payment_date', $lastYear)
                  ->whereNotNull('refund_payment_date');
            })->get(); 
            // last year refund end
            
             // last year despute start
            // $customers_dispute_last_year_transaction = Contact::with([
            //     'transactions' => function ($q) use ($lastYear) {
            //         $q->whereYear('refund_payment_date', $lastYear);
            //     }
            // ])->where("company_id", company_id());
            // $customers_dispute_last_year_transaction = $customers_dispute_last_year_transaction->whereHas('transactions', function ($q) use ($lastYear) {
            //     $q->whereYear('refund_payment_date', $lastYear)
            //         ->where('refund_type', 'Dispute');
            // })->get(); 
            // last year despute end


              // total sale start 
            $customers_total_sale_transaction = Contact::with([
                'transactions' => function ($q) use ($lastYear) {
                    $q->select('id','item_id', 'amount', 'payment_date');
                }
            ])->where("company_id", company_id())->get();  
            // total sale end 
  
            // total refund start
            $customers_total_refund_transaction = Contact::with([
                'transactions' => function ($q) use ($lastYear) {
                    $q->select('id','item_id', 'refundable_amount','refund_type','payment_date', 'refund_payment_date');
                }
            ])->where("company_id", company_id())->get();
          
            // total refund end
            
             // total despute start
            // $customers_total_dispute_transaction = Contact::with([
            //     'transactions' => function ($q) use ($lastYear) {
            //         $q->whereYear('refund_payment_date', $lastYear);
            //     }
            // ])->where("company_id", company_id());
            // $customers_total_dispute_transaction = $customers_total_dispute_transaction->whereHas('transactions', function ($q) use ($lastYear) {
            //     $q->whereYear('refund_payment_date', $lastYear)
            //         ->where('refund_type', 'Dispute');
            // })->get(); 
            // total despute end




            $lastMonthTotalAmount = $customers_sale_last_month_transaction->flatMap->transactions->sum('amount');
            $lastMonthTotalRefundAmount = $customers_refund_last_month_transaction->flatMap->transactions->sum('refundable_amount');
            // $lastMonthTotalDisputeAmount = $customers_dispute_last_month_transaction->flatMap->transactions->sum('refundable_amount');
         
        
            $lastYearTotalAmount = $customers_sale_last_year_transaction->flatMap->transactions->sum('amount');
            $lastYearTotalRefundAmount = $customers_refund_last_year_transaction->flatMap->transactions->sum('refundable_amount');
            // $lastYearTotalDisputeAmount = $customers_dispute_last_year_transaction->flatMap->transactions->sum('refundable_amount');
         
        
           $totalAmount = $customers_total_sale_transaction->flatMap->transactions->sum('amount');
           $totalRefund = $customers_total_refund_transaction->flatMap->transactions->sum('refundable_amount');
          
            $taaa = $customers_refund_last_year_transaction->flatMap->transactions;
            // echo $taaa;
            // die;
        //     foreach($taaa as $v){
        //         echo $v->item_id;
        //         echo "==";
        //         echo $v->refundable_amount;
        //         echo "==";
        //         echo $v->refund_payment_date;
        //         echo "==";
        //         echo $v->payment_date;
        //         echo "==";
        //         echo $v->refund_type;
        //         // print_r($v->refundable_amount."----".$v->refund_payment_date.'==');
        //         echo "<br>";
        //     }
        // //   echo $lastYearTotalRefundAmount; 
        //   die;
            $data['total_current_month_sale']   = $thisMonthTotalAmount-$thisMonthTotalRefundAmount;
            $data['total_current_year_sale']    = $thisYearTotalAmount-$thisYearTotalRefundAmount; 
            $data['total_previous_month_sale']  = $lastMonthTotalAmount-$lastMonthTotalRefundAmount; 
            $data['total_previous_year_sale']   = $lastYearTotalAmount-$lastYearTotalRefundAmount; 
            $data['total_sale']                 = $totalAmount-$totalRefund;
           
            
            // print_r("Last Month Total Amount: ".$lastMonthTotalAmount."<br>");
            // print_r("Last Month Total Refund Amount: ".$lastMonthTotalRefundAmount."<br>");
            // print_r("Last Month Total Customer: ".count($customers_sale_last_month_transaction)."<br>");
            // print_r("This Month Total Amount: ".$thisMonthTotalAmount."<br>");
            // print_r("This Month Total Refund Amount: ".$thisMonthTotalRefundAmount."<br>");
            // print_r("This Month Total Customer: ".count($customers_sale_current_month_transaction));
            // return $customers_sale_current_month_transaction;
            // die;
            // Sarkar Code End-------******************************************************************-------------- 


            return view('backend/dashboard-' . $type, $data);
        } else if ($type == 'staff') {
            $company_id = company_id();
            $data = array();
            $user = Auth::user();

            $data['reminders'] = \DB::table('reminders')
                ->where('active', '=', 1)
                ->orderBy("date", "desc")
                ->get();

            /*$con_leads = Contact::with('invoices')->where("company_id","=", company_id())
                     ->where('converted_by_user_id', '=', $user->id)
                     ->get();
                     $total = 0;
            foreach ($con_leads as $key => $value) {

                foreach ($value->invoices as $keys => $values) {
                        $total += $values->paid;

                }
            }*/
            //$current_month_sale = 0;

            /*$customers_sale= Contact::with(['transactions.group','assignuser'])->where("company_id","=", company_id())->where('converted_by_user_id', '=', $user->id)->get();
            $data['converted_by_user_id'] = count($customers_sale);*/

            //  current month sale
            $currentYear = Carbon::now()->month;

            $customers_sale_current_month_transaction = Contact::with([
                'transactions.group',
                'assignuser',
                'transactions' => function ($q) {
                    $q->whereDate('payment_date', 'like', Carbon::now()->format('Y-m') . '%');
                }
            ])->whereHas('transactions', function ($q) {
                $q->whereDate('payment_date', 'like', Carbon::now()->format('Y-m') . '%');
            })->where("company_id", "=", company_id())->where('converted_by_user_id', '=', $user->id)->get();
            $dispute_total_c = 0;
            $refund_pf_c = 0;
            $total_credit_c = 0;
            foreach ($customers_sale_current_month_transaction as $currentmonthsale) {
                $currentmonthsales = $currentmonthsale->transactions;

                foreach ($currentmonthsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_c = $dispute_total_c + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_c = $refund_pf_c + ($trans->refundable_amount ?? 0);
                    }
                    $total_credit_c = $total_credit_c + ($trans->amount ?? 0);

                }
            }
            $data['total_current_month_sale_credit'] = $total_credit_c;
            $data['total_current_month_sale_refund'] = $refund_pf_c;
            $data['total_current_month_sale_dispute'] = $dispute_total_c;
            $data['total_current_month_sale'] = $total_credit_c - $refund_pf_c - $dispute_total_c;
            //previousmonth sale


            /*$customers_sale_previous_month_transaction= Contact::with(['transactions.group','assignuser'])->where("company_id","=", company_id())->where('converted_by_user_id', '=', $user->id);

            $customers_sale_previous_month_transaction=$customers_sale_previous_month_transaction->whereHas('transactions', function($q) use($currentYear) {
                $q->whereMonth('payment_date', Carbon::now()->subMonth()->month)->whereYear('payment_date', $currentYear);
            })->get();
            $dispute_total_pre = 0;
            $refund_pf_pre = 0;
            $total_credit_pre = 0;
            foreach ($customers_sale_previous_month_transaction as $previousmonthsale) {
                $previousmonthsales = $previousmonthsale->transactions;

                foreach ($previousmonthsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_pre = $dispute_total_pre + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_pre = $refund_pf_pre + ($trans->refundable_amount ?? 0);
                    }
                    $total_credit_pre = $total_credit_pre + ($trans->amount ?? 0);

                }
            }
            $data['total_previous_month_sale'] = $total_credit_pre-$refund_pf_pre-$dispute_total_pre;*/

            //current Year sale

            // $previousYear = $currentYear - 1;
            /*$customers_sale_current_year_transaction= Contact::with(['transactions.group','assignuser'])->where("company_id","=", company_id())->where('converted_by_user_id', '=', $user->id);

            $customers_sale_current_year_transaction=$customers_sale_current_year_transaction->whereHas('transactions', function($q) use($currentYear) {
                $q->whereYear('payment_date', $currentYear);
            })->get();
            $dispute_total_cy = 0;
            $refund_pf_cy = 0;
            $total_credit_cy = 0;
            foreach ($customers_sale_current_year_transaction as $currentyearsale) {
                $currentyearsales = $currentyearsale->transactions;

                foreach ($currentyearsales as $trans) {

                    if ($trans->refund_type == 'Dispute') {
                        $dispute_total_cy = $dispute_total_cy + ($trans->refundable_amount ?? 0);
                    } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                        $refund_pf_cy = $refund_pf_cy + ($trans->refundable_amount ?? 0);
                    }
                    $total_credit_cy = $total_credit_cy + ($trans->amount ?? 0);

                }
            }
            $data['total_current_year_sale'] = $total_credit_cy-$refund_pf_cy-$dispute_total_cy;*/

            //previous Year
            /*  $previousYear = $currentYear - 1;
              $customers_sale_previous_year_transaction= Contact::with(['transactions.group','assignuser'])->where("company_id","=", company_id())->where('converted_by_user_id', '=', $user->id);

              $customers_sale_previous_year_transaction=$customers_sale_previous_year_transaction->whereHas('transactions', function($q) use($previousYear) {
                  $q->whereYear('payment_date', $previousYear);
              })->get();
              $dispute_total_prey = 0;
              $refund_pf_prey = 0;
              $total_credit_prey = 0;
              foreach ($customers_sale_previous_year_transaction as $previousyearsale) {
                  $previousyearsales = $previousyearsale->transactions;

                  foreach ($previousyearsales as $trans) {

                      if ($trans->refund_type == 'Dispute') {
                          $dispute_total_prey = $dispute_total_prey + ($trans->refundable_amount ?? 0);
                      } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                          $refund_pf_prey = $refund_pf_prey + ($trans->refundable_amount ?? 0);
                      }
                      $total_credit_prey = $total_credit_prey + ($trans->amount ?? 0);

                  }
              }
              $data['total_previous_year_sale'] = $total_credit_prey-$refund_pf_prey-$dispute_total_prey;*/

            //Total sale
            // $previousYear = $currentYear - 1;
            /* $customers_sale_transaction= Contact::with(['transactions.group','assignuser'])->where("company_id","=", company_id())->where('converted_by_user_id', '=', $user->id)->get();*/

            /*  $customers_sale_previous_year_transaction=$customers_sale_previous_year_transaction->whereHas('transactions', function($q)  {
                  $q->whereYear('payment_date', $previousYear);
              })->get();*/
            /*    $dispute_total_ts = 0;
                $refund_pf_ts = 0;
                $total_credit_ts = 0;
                foreach ($customers_sale_transaction as $totalsale) {
                    $totalsales = $totalsale->transactions;

                    foreach ($totalsales as $trans) {

                        if ($trans->refund_type == 'Dispute') {
                            $dispute_total_ts = $dispute_total_ts + ($trans->refundable_amount ?? 0);
                        } elseif ($trans->refund_type == 'Full amount' or $trans->refund_type == 'Partial') {
                            $refund_pf_ts = $refund_pf_ts + ($trans->refundable_amount ?? 0);
                        }
                        $total_credit_ts = $total_credit_ts + ($trans->amount ?? 0);

                    }
                }
                $data['total_sale'] = $total_credit_ts-$refund_pf_ts-$dispute_total_ts;
    */




            $data['new_leads'] = Lead::with('lead_status')
                ->with('lead_source')
                ->with('assigned_user')
                ->where("company_id", "=", company_id())
                ->where('assigned_user_id', '=', $user->id)
                ->orderBy("id", "desc")
                ->get();

            $data['leads'] = Lead::with('lead_status')
                ->with('lead_source')
                ->with('assigned_user')
                ->where("company_id", "=", company_id())
                ->where('hot', '=', 1)
                ->orderBy("id", "desc")
                ->get();

            $project_status = \App\Project::join('project_members', 'projects.id', 'project_members.project_id')
                ->where('project_members.user_id', Auth::id())
                ->selectRaw('status, COUNT(projects.id) as c')
                ->groupBy('status')
                ->get();

            $data['total_project'] = 0;
            foreach ($project_status as $status) {
                $data['total_project'] += $status->c;
                $data['project_status'][$status->status] = $status->c;
            }

            $converted_lead_by_user_in_current_month = DB::table('users')
                ->select(['users.name', 'users.id', \DB::raw('COUNT(*) as count')])
                ->join('contacts', function ($join) {
                    $join->on('contacts.converted_by_user_id', '=', 'users.id')->on('contacts.company_id', '=', 'users.company_id')->whereMonth('contacts.created_at', Carbon::now()->month);
                })
                ->groupBy('users.id')
                ->orderBy('count', 'desc')
                ->get()->toArray();

            $per = array();
            foreach ($converted_lead_by_user_in_current_month as $key => $value) {
                $c = Lead::where('assigned_user_id', '=', $value->id)->count();
                if ($c > 0) {
                    $mul = $value->count * 100;
                    $div = $mul / $c;
                    $per[$value->id] = $div;
                }
            }

            if (count($per) > 0) {
                $maxs = array_keys($per, max($per));
                $data['percentage'] = max($per);
                $data['user'] = User::find($maxs)->toArray();
            } else {
                $data['percentage'] = 0;
                $data['user'] = 'no';
            }

            $company_id = company_id();


            return view('backend/dashboard-' . $type, $data);
        }
    }


    public function json_month_wise_income_expense()
    {
        $income = $this->month_wise_income();
        $expense = $this->month_wise_expense();

        $months = '"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"';
        $income_string = '';
        $expense_string = '';

        foreach ($income as $i) {
            $income_string = $income_string . $i->amount . ",";
        }

        $income_string = rtrim($income_string, ",");

        foreach ($expense as $e) {
            $expense_string = $expense_string . $e->amount . ",";
        }
        $expense_string = rtrim($expense_string, ",");

        echo '{"Months":[' . $months . '], "Income":[' . $income_string . '], "Expense":[' . $expense_string . ']}';
        exit();
    }

    public function json_income_vs_expense()
    {
        $income = $this->current_month_income();
        $expense = $this->current_month_expense();
        echo '{"Income":[' . $income . '], "Expense":[' . $expense . ']}';
        exit();
    }

    private function month_wise_income()
    {
        $company_id = company_id();
        $date = date("Y-m-d");
        $query = DB::select("SELECT m.month, IFNULL(SUM(transactions.base_amount),0) as amount 
		FROM ( SELECT 1 AS MONTH UNION SELECT 2 AS MONTH UNION SELECT 3 AS MONTH UNION SELECT 4 AS MONTH 
		UNION SELECT 5 AS MONTH UNION SELECT 6 AS MONTH UNION SELECT 7 AS MONTH UNION SELECT 8 AS MONTH 
		UNION SELECT 9 AS MONTH UNION SELECT 10 AS MONTH UNION SELECT 11 AS MONTH UNION SELECT 12 AS MONTH ) AS m 
		LEFT JOIN transactions ON m.month = MONTH(trans_date) AND YEAR(transactions.trans_date)=YEAR('$date') 
		AND dr_cr='cr' AND company_id='$company_id' GROUP BY m.month ORDER BY m.month ASC");
        return $query;
    }

    private function month_wise_expense()
    {
        $company_id = company_id();
        $date = date("Y-m-d");
        $query = DB::select("SELECT m.month, IFNULL(SUM(transactions.base_amount),0) as amount 
		FROM ( SELECT 1 AS MONTH UNION SELECT 2 AS MONTH UNION SELECT 3 AS MONTH UNION SELECT 4 AS MONTH 
		UNION SELECT 5 AS MONTH UNION SELECT 6 AS MONTH UNION SELECT 7 AS MONTH UNION SELECT 8 AS MONTH 
		UNION SELECT 9 AS MONTH UNION SELECT 10 AS MONTH UNION SELECT 11 AS MONTH UNION SELECT 12 AS MONTH ) AS m 
		LEFT JOIN transactions ON m.month = MONTH(trans_date) AND YEAR(transactions.trans_date)=YEAR('$date') 
		AND dr_cr='dr' AND company_id='$company_id' GROUP BY m.month ORDER BY m.month ASC");
        return $query;
    }


    private function current_month_income()
    {
        $company_id = company_id();
        $date = date("Y-m-d");
        $query = DB::select("SELECT IFNULL(SUM(base_amount),0) as amount FROM transactions WHERE dr_cr='cr' 
	 AND trans_date BETWEEN ADDDATE(LAST_DAY(SUBDATE('$date', INTERVAL 1 MONTH)), 1) AND LAST_DAY('$date') 
	 AND company_id='$company_id'");
        return $query[0]->amount;
    }


    private function current_month_expense()
    {
        $company_id = company_id();
        $date = date("Y-m-d");
        $query = DB::select("SELECT IFNULL(SUM(base_amount),0) as amount FROM transactions WHERE dr_cr='dr' 
	 AND trans_date BETWEEN ADDDATE(LAST_DAY(SUBDATE('$date', INTERVAL 1 MONTH)), 1) AND LAST_DAY('$date') 
	 AND company_id='$company_id'");
        return $query[0]->amount;
    }


}
