<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'contacts';

    protected $guarded = [];

    public function group()
    {
        return $this->hasOne('App\ContactGroup', 'id', 'group_id')->withDefault();
    }

    public function user()
    {
        return $this->belongsTo('App\User')->withDefault();
    }

    public function company()
    {
        return $this->belongsTo('App\Company', 'company_id')->withDefault();
    }

    public function projects()
    {
        return $this->hasMany('App\Project', 'client_id');
    }
    // 	public function assignuser()
    // {
    //     return $this->belongsTo('App\User','converted_by_user_id')->withDefault();
    // }
    // 	public function assignuser_lead()
    // {
    //     return $this->belongsTo('App\User','assign_id')->withDefault();
    // }


    public function assignuser_lead()
    {
        return $this->belongsTo(User::class, 'assign_id')->withDefault();
    }

    public function assignuser()
    {
        return $this->belongsTo(User::class, 'converted_by_user_id')->withDefault();
    }


    public function invoices()
    {
        return $this->hasMany('App\Invoice', 'client_id')->where('status', '=', 'Paid');
    }

    public function zonename()
    {
        return $this->belongsTo('App\TimeZoneList', 'time_zone')->withDefault();
    }
    public function transactions()
    {
        return $this->hasMany('App\SaleTransaction', 'item_id');
    }
}