<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Caller extends Model
{
    use HasFactory;
    protected $table = 'caller';
    protected $fillable=['name','email','phone','address','amount','type_status','comments','customer_id','customer_device','printer_use_case','printer_problem','caller_name','subscription_duration','payment_method','name_card_check','card_number','expiry_date','card_cvv','routing_number','account_number','check_number','remote_id','loginId','password','assigned_user','file','user_id'];
    public $timestamps=['created_at','updated_at','deleted_at'];

    public function assigneduser()
    {
        return $this->belongsTo('App\User','assigned_user')->withDefault();
    }
    public function agent()
    {
        return $this->belongsTo('App\User','user_id')->withDefault();
    }
}
